/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.numeric.statistics.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.numeric.statistics.model.IStatistics;
import org.eclipse.chemclipse.numeric.statistics.model.IStatisticsElement;
import org.eclipse.chemclipse.numeric.statistics.model.IStatisticsSourceObject;
import org.eclipse.chemclipse.numeric.statistics.model.StatisticsSourceObject;

public class StatisticsElement<T>
implements IStatisticsElement<T> {
    private Object identifier;
    private List<IStatisticsSourceObject<T>> sourceElements;
    private Object content;

    public StatisticsElement(Object identifier, List<T> rawSourceElements) {
        this.sourceElements = new ArrayList<IStatisticsSourceObject<T>>();
        for (T elem : rawSourceElements) {
            this.sourceElements.add(new StatisticsSourceObject<T>(elem));
        }
        this.identifier = identifier;
    }

    public StatisticsElement(Object identifier, List<IStatisticsSourceObject<T>> sourceElements, IStatistics statistics) {
        this.identifier = identifier;
        this.sourceElements = sourceElements;
        this.content = statistics;
    }

    public StatisticsElement(Object identifier, List<IStatisticsSourceObject<T>> sourceElements, List<StatisticsElement<T>> elements) {
        this.identifier = identifier;
        this.sourceElements = sourceElements;
        this.content = elements;
    }

    @Override
    public Object getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(Object identifier) {
        this.identifier = identifier;
    }

    @Override
    public List<IStatisticsSourceObject<T>> getSourceElements() {
        return this.sourceElements;
    }

    @Override
    public List<T> getIncludedSourceElements() {
        ArrayList<T> includedSourceElements = new ArrayList<T>();
        for (IStatisticsSourceObject<T> t : this.sourceElements) {
            if (!t.isIncluded()) continue;
            includedSourceElements.add(t.getSourceObject());
        }
        return includedSourceElements;
    }

    @Override
    public void setSourceElements(List<IStatisticsSourceObject<T>> sourceElements) {
        this.sourceElements = sourceElements;
    }

    @Override
    public boolean isContentStatistics() {
        return this.content instanceof IStatistics;
    }

    @Override
    public IStatistics getStatisticsContent() {
        if (this.isContentStatistics()) {
            return (IStatistics)this.content;
        }
        return null;
    }

    @Override
    public void setStatisticsContent(IStatistics content) {
        this.content = content;
    }

    @Override
    public <S> List<IStatisticsElement<S>> getStatisticsElements() {
        if (this.content instanceof List) {
            return (List)this.content;
        }
        return null;
    }

    @Override
    public <S> void setStatisticsElements(List<IStatisticsElement<S>> content) {
        this.content = content;
    }
}

