/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.service.internal.commands.switchers;

import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.ISourceProviderService;
import org.polarsys.chess.core.profiles.CHESSProfileManager;
import org.polarsys.chess.core.views.DiagramStatus;
import org.polarsys.chess.service.internal.commands.switchers.SwitchSourceProvider;
import org.polarsys.chess.service.internal.palette.PaletteManager;
import org.polarsys.chess.service.utils.CHESSEditorUtils;

public class SwitchToView {
    public String commandId;
    private String theView;
    String checkedText;
    String uncheckedText;
    private boolean selected = false;

    public SwitchToView(String theView, String commandId) {
        this.theView = theView;
        this.commandId = commandId;
        this.checkedText = "Deactivate " + theView;
        this.uncheckedText = "Activate " + theView;
        SwitchSourceProvider.commandsToRefresh.add(commandId);
    }

    public void refresh() {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
        service.refreshElements(this.commandId, null);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editorPart = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        if (CHESSEditorUtils.isCHESSProject(editorPart) && CHESSProfileManager.ARE_VIEWS_LOADED) {
            DiagramStatus diagramStatus = CHESSEditorUtils.getDiagramStatus((PapyrusMultiDiagramEditor)editorPart);
            if (diagramStatus == null) {
                return null;
            }
            IWorkbenchWindow window = editorPart.getSite().getWorkbenchWindow();
            ISourceProviderService spService = (ISourceProviderService)window.getService(ISourceProviderService.class);
            SwitchSourceProvider sp = (SwitchSourceProvider)spService.getSourceProvider("org.polarsys.chess.service.commands.switchState");
            this.selected = diagramStatus.requestView(this.theView, !this.selected);
            this.hideShowElements((PapyrusMultiDiagramEditor)editorPart);
            PaletteManager.setPaletteVisibility((PapyrusMultiDiagramEditor)editorPart, diagramStatus);
            sp.updateStatus(editorPart);
        }
        return null;
    }

    private void hideShowElements(PapyrusMultiDiagramEditor editor) {
    }

    public void updateElement(UIElement element, Map parameters) {
        PapyrusMultiDiagramEditor editor = CHESSEditorUtils.getCHESSEditor();
        if (editor != null && CHESSProfileManager.ARE_VIEWS_LOADED) {
            DiagramStatus st = CHESSEditorUtils.getDiagramStatus(editor);
            if (st == null) {
                return;
            }
            DiagramStatus.DesignView currentView = st.getCurrentView();
            if (this.selected && currentView != null) {
                this.selected = st.getCurrentView().isEnabled(this.theView);
            }
        }
        element.setChecked(this.selected);
        if (this.selected) {
            element.setText(this.checkedText);
        } else {
            element.setText(this.uncheckedText);
        }
    }
}

