/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.service.internal.service;

import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.services.IServiceFactory;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.polarsys.chess.service.internal.service.CHESSService;

public class CHESSServiceFactory
implements IServiceFactory {
    private CHESSService service;
    private ServicesRegistry serviceRegistry;
    private ISashWindowsContainer container;
    private IPartListener partListener;

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.serviceRegistry = servicesRegistry;
        IWorkbenchWindow w = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.partListener = this.createPartListener();
        w.getPartService().addPartListener(this.partListener);
    }

    private IPartListener createPartListener() {
        return new IPartListener(){

            private void execute(IWorkbenchPart part) {
                if (part instanceof PapyrusMultiDiagramEditor) {
                    try {
                        CHESSServiceFactory.this.container = (ISashWindowsContainer)CHESSServiceFactory.this.serviceRegistry.getService(ISashWindowsContainer.class);
                        CHESSServiceFactory.this.createCHESSService();
                        boolean success = CHESSServiceFactory.this.service.start(part);
                        if (success) {
                            CHESSServiceFactory.this.removePartListner(this);
                        } else {
                            CHESSServiceFactory.this.service = null;
                        }
                    }
                    catch (ServiceException serviceException) {
                        CHESSServiceFactory.this.service = null;
                        CHESSServiceFactory.this.removePartListner(this);
                    }
                }
            }

            public void partOpened(IWorkbenchPart part) {
                this.execute(part);
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
                this.execute(part);
            }
        };
    }

    public void startService() throws ServiceException {
    }

    public void disposeService() throws ServiceException {
        this.removePartListner(this.partListener);
        if (this.service != null) {
            this.service.stopService();
            this.service = null;
        }
    }

    private void removePartListner(IPartListener partListener) {
        if (partListener != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().removePartListener(partListener);
        }
    }

    private void createCHESSService() {
        this.service = new CHESSService(this.container, this.serviceRegistry);
    }

    public Object createServiceInstance() throws ServiceException {
        return this.service;
    }
}

