/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.patterns.dialogs;

import java.util.Map;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;

public class MappingLabelProvider
extends ColumnLabelProvider {
    private int column;
    private Map<NamedElement, NamedElement> mappings;

    public MappingLabelProvider(int column, Map<NamedElement, NamedElement> mappings) {
        this.column = column;
        this.mappings = mappings;
    }

    public String getText(Object element) {
        NamedElement elem = (NamedElement)element;
        if (this.column == 1) {
            Property prop;
            String name = elem.getName();
            if (elem instanceof Port && elem.getOwner() instanceof NamedElement) {
                name = String.valueOf(name) + " (owner: " + ((NamedElement)elem.getOwner()).getQualifiedName() + ")";
            }
            if (elem instanceof Property && (prop = (Property)elem).getType() instanceof NamedElement) {
                name = String.valueOf(name) + " (type: " + prop.getType().getQualifiedName() + ")";
            }
            if (elem instanceof Connector) {
                Connector conn = (Connector)elem;
                Port firstRole = null;
                Port secondRole = null;
                Property firstProp = null;
                Property secondProp = null;
                if (conn.getEnds().size() == 2) {
                    if (((ConnectorEnd)conn.getEnds().get(0)).getRole() instanceof Port) {
                        firstRole = (Port)((ConnectorEnd)conn.getEnds().get(0)).getRole();
                    }
                    if (((ConnectorEnd)conn.getEnds().get(1)).getRole() instanceof Port) {
                        secondRole = (Port)((ConnectorEnd)conn.getEnds().get(1)).getRole();
                    }
                    if (((ConnectorEnd)conn.getEnds().get(0)).getPartWithPort() instanceof Property) {
                        firstProp = ((ConnectorEnd)conn.getEnds().get(0)).getPartWithPort();
                    }
                    if (((ConnectorEnd)conn.getEnds().get(1)).getPartWithPort() instanceof Property) {
                        secondProp = ((ConnectorEnd)conn.getEnds().get(1)).getPartWithPort();
                    }
                }
                if (firstRole != null && secondRole != null && firstProp != null && secondProp != null) {
                    name = String.valueOf(name) + " (" + firstProp.getName() + "." + firstRole.getName() + " - " + secondProp.getName() + "." + firstProp.getName() + ")";
                }
            }
            return name;
        }
        if (this.column == 2) {
            NamedElement mappedRole = this.mappings.get(elem);
            if (mappedRole instanceof NamedElement) {
                NamedElement mappedType = mappedRole;
                String name = mappedType.getName();
                if (mappedType.getOwner() instanceof NamedElement) {
                    name = String.valueOf(name) + " (from " + ((NamedElement)mappedType.getOwner()).getQualifiedName() + ")";
                }
                return name;
            }
            return "not mapped (to be created)";
        }
        return "";
    }
}

