/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.statebased;

import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.chess.statebased.Activator;
import org.polarsys.chess.statebased.StateBasedWithParametersCommand;

public class PeriodicExecutionDialog
extends Dialog
implements Runnable {
    private Text txtParams;
    private Text txtResults;
    private Text txtPeriod;
    private String user = "";
    private String password = "";
    private Button btnParams;
    private Button btnResults;
    private Button btnPeriodic;
    private Button btnCancel;
    private Button btnProceed;
    private Label lblParams;
    private Label lblResults;
    private Label lblPeriod;
    private Label lblMessage;
    private Label lblSeconds;
    private Button chkSaveParamsPath;
    private Button chkSaveResultsPath;
    private Composite container;
    private int iInterval = 0;
    private boolean bIsPeriodic = false;
    private ProgressMonitorPart monitor;
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private Future<?> currentJob;

    public PeriodicExecutionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(3, false);
        layout.marginRight = 5;
        layout.marginLeft = 10;
        this.container.setLayout((Layout)layout);
        this.lblParams = new Label(this.container, 0);
        GridData gd_lblParams = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblParams.horizontalIndent = 1;
        this.lblParams.setLayoutData((Object)gd_lblParams);
        this.lblParams.setText("Parameters File:");
        this.txtParams = new Text(this.container, 2048);
        this.txtParams.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtParams.setText(Activator.getDefault().getPreferenceStore().getString("PARAMFILE"));
        this.btnParams = new Button(this.container, 0);
        this.btnParams.setText("Browse");
        this.btnParams.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(PeriodicExecutionDialog.this.getParentShell());
                fd.setText("Select Parameters File");
                fd.setFileName(PeriodicExecutionDialog.this.txtParams.getText());
                PeriodicExecutionDialog.this.txtParams.setText(fd.open());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.chkSaveParamsPath = new Button(this.container, 32);
        this.chkSaveParamsPath.setText("Save as default");
        this.chkSaveParamsPath.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 3, 1));
        this.lblResults = new Label(this.container, 0);
        GridData gd_lblPassword = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblPassword.horizontalIndent = 1;
        this.lblResults.setLayoutData((Object)gd_lblPassword);
        this.lblResults.setText("Results File:");
        this.txtResults = new Text(this.container, 2048);
        this.txtResults.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtResults.setText(Activator.getDefault().getPreferenceStore().getString("RESULTFILE"));
        this.btnResults = new Button(this.container, 0);
        this.btnResults.setText("Browse");
        this.btnResults.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(PeriodicExecutionDialog.this.getParentShell());
                fd.setText("Select Results File");
                fd.setFileName(PeriodicExecutionDialog.this.txtResults.getText());
                fd.setOverwrite(true);
                PeriodicExecutionDialog.this.txtResults.setText(fd.open());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.chkSaveResultsPath = new Button(this.container, 32);
        this.chkSaveResultsPath.setText("Save as default");
        this.chkSaveResultsPath.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 3, 1));
        Label lblPeriodic = new Label(this.container, 0);
        GridData gd_lblPeriodic = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblPeriodic.horizontalIndent = 1;
        lblPeriodic.setLayoutData((Object)gd_lblPeriodic);
        lblPeriodic.setText("Periodic:");
        this.btnPeriodic = new Button(this.container, 32);
        this.btnPeriodic.setSelection(Activator.getDefault().getPreferenceStore().getBoolean("RUNPERIODIC"));
        this.btnPeriodic.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.btnPeriodic.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PeriodicExecutionDialog.this.txtPeriod.setEnabled(PeriodicExecutionDialog.this.btnPeriodic.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.lblPeriod = new Label(this.container, 0);
        GridData gd_lblPeriod = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblPeriod.horizontalIndent = 1;
        this.lblPeriod.setLayoutData((Object)gd_lblPeriod);
        this.lblPeriod.setText("Period:");
        this.txtPeriod = new Text(this.container, 2048);
        this.iInterval = Activator.getDefault().getPreferenceStore().getInt("EXECPERIOD");
        this.txtPeriod.setText(Integer.toString(this.iInterval));
        this.txtPeriod.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.txtPeriod.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String string = e.text;
                char[] chars = new char[string.length()];
                string.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        this.txtPeriod.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PeriodicExecutionDialog.this.setMessage("");
                if (PeriodicExecutionDialog.this.btnPeriodic.getSelection()) {
                    try {
                        PeriodicExecutionDialog.this.iInterval = Integer.parseInt(PeriodicExecutionDialog.this.txtPeriod.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        PeriodicExecutionDialog.this.setMessage("Period is invalid");
                    }
                    if (PeriodicExecutionDialog.this.iInterval < 60) {
                        PeriodicExecutionDialog.this.setMessage("A period of at least 60 seconds is strongly recommended");
                    }
                }
            }
        });
        this.lblSeconds = new Label(this.container, 0);
        this.lblSeconds.setText("seconds");
        this.lblMessage = new Label(this.container, 0);
        this.lblMessage.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.monitor = new ProgressMonitorPart(this.container, (Layout)new GridLayout());
        this.monitor.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.setControlsEnabledState(true);
        return this.container;
    }

    private void setMessage(String m) {
        Display.getDefault().asyncExec((Runnable)new MessageLabelUpdater(m));
    }

    private void setControlsEnabledState(boolean enabled) {
        Display.getDefault().asyncExec((Runnable)new EnabledStateUpdater(enabled));
    }

    private void beginTask(String name, int totalWork) {
        Display.getDefault().asyncExec((Runnable)new ProgressTaskBegin(name, totalWork));
    }

    private void resetControls() {
        this.setMessage("");
        this.setControlsEnabledState(true);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnProceed = this.createButton(parent, 10, IDialogConstants.PROCEED_LABEL, true);
        this.btnCancel = this.createButton(parent, 6, IDialogConstants.CANCEL_LABEL, false);
        this.btnProceed.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PeriodicExecutionDialog.this.setControlsEnabledState(false);
                PeriodicExecutionDialog.this.setMessage("Waiting...");
                if (PeriodicExecutionDialog.this.chkSaveParamsPath.getSelection()) {
                    Activator.getDefault().getPreferenceStore().setValue("PARAMFILE", PeriodicExecutionDialog.this.txtParams.getText());
                }
                if (PeriodicExecutionDialog.this.chkSaveResultsPath.getSelection()) {
                    Activator.getDefault().getPreferenceStore().setValue("RESULTFILE", PeriodicExecutionDialog.this.txtResults.getText());
                }
                PeriodicExecutionDialog.this.bIsPeriodic = PeriodicExecutionDialog.this.btnPeriodic.getSelection();
                StateBasedWithParametersCommand.acquireModel();
                StateBasedWithParametersCommand.setParamsFilePath(PeriodicExecutionDialog.this.txtParams.getText());
                StateBasedWithParametersCommand.setResultsFilePath(PeriodicExecutionDialog.this.txtResults.getText());
                PeriodicExecutionDialog.this.btnCancel.setText(IDialogConstants.STOP_LABEL);
                PeriodicExecutionDialog.this.btnCancel.setEnabled(true);
                PeriodicExecutionDialog.this.btnProceed.setEnabled(false);
                if (PeriodicExecutionDialog.this.bIsPeriodic) {
                    PeriodicExecutionDialog.this.currentJob = PeriodicExecutionDialog.this.executorService.scheduleAtFixedRate(PeriodicExecutionDialog.this, 0L, PeriodicExecutionDialog.this.iInterval, TimeUnit.SECONDS);
                } else {
                    PeriodicExecutionDialog.this.currentJob = PeriodicExecutionDialog.this.executorService.submit(PeriodicExecutionDialog.this);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnCancel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PeriodicExecutionDialog.this.cancelPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected IProgressMonitor getMonitor() {
        return this.monitor;
    }

    protected Point getInitialSize() {
        return new Point(650, 390);
    }

    protected void okPressed() {
        super.okPressed();
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void run() {
        Date nextRun = new Date(new Date().getTime() + (long)(this.iInterval * 1000));
        this.setMessage("Running...");
        this.beginTask("Analysis", 100);
        StateBasedWithParametersCommand.runStateBased();
        if (this.bIsPeriodic) {
            this.setMessage("Waiting until... " + nextRun + " (estimated)");
        } else {
            this.setMessage("Done.");
            this.setControlsEnabledState(true);
        }
    }

    protected void cancelPressed() {
        if (this.currentJob != null) {
            this.currentJob.cancel(true);
        }
        this.resetControls();
        if (this.btnCancel.getText() == IDialogConstants.STOP_LABEL) {
            this.btnCancel.setText(IDialogConstants.CANCEL_LABEL);
            this.btnProceed.setEnabled(true);
            this.setControlsEnabledState(true);
        } else {
            this.executorService.shutdownNow();
            super.cancelPressed();
        }
    }

    protected boolean isResizable() {
        return true;
    }

    protected void progress(final int work) {
        if (this.monitor != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!PeriodicExecutionDialog.this.monitor.isDisposed()) {
                        PeriodicExecutionDialog.this.monitor.worked(work);
                    }
                }
            });
        }
    }

    protected void subTask(final String name) {
        if (this.monitor != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!PeriodicExecutionDialog.this.monitor.isDisposed()) {
                        PeriodicExecutionDialog.this.monitor.subTask(name);
                    }
                }
            });
        }
    }

    protected void stopMonitor() {
        if (this.monitor != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!PeriodicExecutionDialog.this.monitor.isDisposed()) {
                        PeriodicExecutionDialog.this.monitor.setVisible(false);
                    }
                }
            });
        }
    }

    private class EnabledStateUpdater
    implements Runnable {
        private boolean s;

        public EnabledStateUpdater(boolean state) {
            this.s = state;
        }

        @Override
        public void run() {
            if (!PeriodicExecutionDialog.this.container.isDisposed()) {
                Control[] children = PeriodicExecutionDialog.this.container.getChildren();
                int i = 0;
                while (i < children.length) {
                    children[i].setEnabled(this.s);
                    ++i;
                }
                if (this.s) {
                    PeriodicExecutionDialog.this.txtPeriod.setEnabled(PeriodicExecutionDialog.this.btnPeriodic.getSelection());
                }
                PeriodicExecutionDialog.this.lblMessage.setEnabled(true);
                PeriodicExecutionDialog.this.btnCancel.setText(IDialogConstants.CANCEL_LABEL);
                PeriodicExecutionDialog.this.btnCancel.setEnabled(this.s);
                PeriodicExecutionDialog.this.btnProceed.setEnabled(this.s);
            }
        }
    }

    private class MessageLabelUpdater
    implements Runnable {
        private String m;

        public MessageLabelUpdater(String message) {
            this.m = message;
        }

        @Override
        public void run() {
            if (!PeriodicExecutionDialog.this.lblMessage.isDisposed()) {
                PeriodicExecutionDialog.this.lblMessage.setText(this.m);
            }
        }
    }

    private class ProgressTaskBegin
    implements Runnable {
        private String taskName;
        private int totalWork;

        public ProgressTaskBegin(String name, int work) {
            this.taskName = name;
            this.totalWork = work;
        }

        @Override
        public void run() {
            if (!PeriodicExecutionDialog.this.monitor.isDisposed()) {
                PeriodicExecutionDialog.this.monitor.setVisible(true);
                PeriodicExecutionDialog.this.monitor.beginTask(this.taskName, this.totalWork);
            }
        }
    }
}

