/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.BooleanBag;
import org.eclipse.collections.api.bag.primitive.ImmutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.iterator.BooleanIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.set.primitive.ImmutableBooleanSet;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.api.tuple.primitive.BooleanIntPair;
import org.eclipse.collections.impl.bag.mutable.primitive.BooleanHashBag;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedBooleanIntProcedure;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.BooleanBags;
import org.eclipse.collections.impl.factory.primitive.BooleanSets;
import org.eclipse.collections.impl.iterator.UnmodifiableBooleanIterator;

final class ImmutableBooleanHashBag
implements ImmutableBooleanBag,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableBooleanBag delegate;

    private ImmutableBooleanHashBag(boolean[] newElements) {
        this.checkOptimizedSize(newElements.length);
        this.delegate = BooleanHashBag.newBagWith(newElements);
    }

    private ImmutableBooleanHashBag(MutableBooleanBag delegate) {
        BooleanHashBag defensiveCopy = new BooleanHashBag((BooleanIterable)delegate);
        this.checkOptimizedSize(defensiveCopy.size());
        this.delegate = defensiveCopy;
    }

    private void checkOptimizedSize(int length) {
        if (length <= 1) {
            throw new IllegalArgumentException("Use BooleanBags.immutable.with() to instantiate an optimized collection");
        }
    }

    public static ImmutableBooleanHashBag newBagWith(boolean ... elements) {
        return new ImmutableBooleanHashBag(elements);
    }

    public static ImmutableBooleanHashBag newBagWith(MutableBooleanBag elements) {
        return new ImmutableBooleanHashBag(elements);
    }

    public ImmutableBooleanBag newWith(boolean element) {
        return BooleanHashBag.newBag((BooleanIterable)this.delegate).with(element).toImmutable();
    }

    public ImmutableBooleanBag newWithout(boolean element) {
        BooleanHashBag hashBag = BooleanHashBag.newBag((BooleanIterable)this.delegate);
        hashBag.remove(element);
        return hashBag.toImmutable();
    }

    public ImmutableBooleanBag newWithAll(BooleanIterable elements) {
        BooleanHashBag bag = BooleanHashBag.newBag((BooleanIterable)this.delegate);
        bag.addAll(elements);
        return bag.toImmutable();
    }

    public ImmutableBooleanBag newWithoutAll(BooleanIterable elements) {
        BooleanHashBag bag = BooleanHashBag.newBag((BooleanIterable)this.delegate);
        bag.removeAll(elements);
        return bag.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public boolean contains(boolean value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(BooleanIterable source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(boolean ... elements) {
        return this.delegate.containsAll(elements);
    }

    public void each(BooleanProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public ImmutableBooleanBag select(BooleanPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableBooleanBag selectByOccurrences(IntPredicate predicate) {
        return this.delegate.selectByOccurrences(predicate).toImmutable();
    }

    public ImmutableBooleanSet selectUnique() {
        MutableBooleanSet result = BooleanSets.mutable.empty();
        this.forEachWithOccurrences((BooleanIntProcedure & Serializable)(each, occurrences) -> {
            if (occurrences == 1) {
                result.add(each);
            }
        });
        return result.toImmutable();
    }

    public ImmutableList<BooleanIntPair> topOccurrences(int count) {
        return this.delegate.topOccurrences(count).toImmutable();
    }

    public ImmutableList<BooleanIntPair> bottomOccurrences(int count) {
        return this.delegate.bottomOccurrences(count).toImmutable();
    }

    public ImmutableBooleanBag reject(BooleanPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(BooleanToObjectFunction<? extends V> function) {
        MutableBag bag = this.delegate.collect(function);
        return bag.toImmutable();
    }

    public MutableBooleanList toList() {
        return this.delegate.toList();
    }

    public int sizeDistinct() {
        return this.delegate.sizeDistinct();
    }

    public int occurrencesOf(boolean item) {
        return this.delegate.occurrencesOf(item);
    }

    public void forEachWithOccurrences(BooleanIntProcedure booleanIntProcedure) {
        this.delegate.forEachWithOccurrences(booleanIntProcedure);
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public int count(BooleanPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public RichIterable<BooleanIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add((Object)this);
            } else {
                BooleanIterator iterator = this.booleanIterator();
                while (iterator.hasNext()) {
                    MutableBooleanBag batch = BooleanBags.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add((Object)batch.toImmutable());
                }
            }
        }
        return result.toImmutable();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MutableBooleanSet toSet() {
        return this.delegate.toSet();
    }

    public MutableBooleanBag toBag() {
        return this.delegate.toBag();
    }

    public ImmutableBooleanBag toImmutable() {
        return this;
    }

    public LazyBooleanIterable asLazy() {
        return this.delegate.asLazy();
    }

    public boolean[] toArray() {
        return this.delegate.toArray();
    }

    public boolean[] toArray(boolean[] target) {
        return this.delegate.toArray(target);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public BooleanIterator booleanIterator() {
        return new UnmodifiableBooleanIterator((BooleanIterator)this.delegate.booleanIterator());
    }

    private Object writeReplace() {
        return new ImmutableBooleanBagSerializationProxy((BooleanBag)this);
    }

    protected static class ImmutableBooleanBagSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private BooleanBag bag;

        public ImmutableBooleanBagSerializationProxy() {
        }

        protected ImmutableBooleanBagSerializationProxy(BooleanBag bag) {
            this.bag = bag;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.bag.sizeDistinct());
            try {
                this.bag.forEachWithOccurrences((BooleanIntProcedure)new CheckedBooleanIntProcedure(){

                    @Override
                    public void safeValue(boolean item, int count) throws IOException {
                        out.writeBoolean(item);
                        out.writeInt(count);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            BooleanHashBag deserializedBag = new BooleanHashBag();
            for (int i = 0; i < size; ++i) {
                deserializedBag.addOccurrences(in.readBoolean(), in.readInt());
            }
            this.bag = deserializedBag;
        }

        protected Object readResolve() {
            return this.bag.toImmutable();
        }
    }
}

