/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.bag.primitive.ImmutableDoubleBag;
import org.eclipse.collections.api.factory.bag.primitive.ImmutableDoubleBagFactory;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableDoubleEmptyBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableDoubleHashBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableDoubleSingletonBag;

public class ImmutableDoubleBagFactoryImpl
implements ImmutableDoubleBagFactory {
    @Override
    public ImmutableDoubleBag empty() {
        return ImmutableDoubleEmptyBag.INSTANCE;
    }

    @Override
    public ImmutableDoubleBag of() {
        return this.empty();
    }

    @Override
    public ImmutableDoubleBag with() {
        return this.empty();
    }

    @Override
    public ImmutableDoubleBag of(double one) {
        return this.with(one);
    }

    @Override
    public ImmutableDoubleBag with(double one) {
        return new ImmutableDoubleSingletonBag(one);
    }

    @Override
    public ImmutableDoubleBag of(double ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableDoubleBag with(double ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableDoubleHashBag.newBagWith(items);
    }

    @Override
    public ImmutableDoubleBag ofAll(DoubleIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableDoubleBag withAll(DoubleIterable items) {
        if (items instanceof ImmutableDoubleBag) {
            return (ImmutableDoubleBag)items;
        }
        return this.with(items.toArray());
    }
}

