/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable.primitive;

import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableShortBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortIntProcedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.tuple.primitive.ShortIntPair;
import org.eclipse.collections.impl.bag.mutable.primitive.UnmodifiableShortBag;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractSynchronizedShortCollection;
import org.eclipse.collections.impl.factory.primitive.ShortBags;
import org.eclipse.collections.impl.lazy.primitive.LazyShortIterableAdapter;

@ThreadSafe
public final class SynchronizedShortBag
extends AbstractSynchronizedShortCollection
implements MutableShortBag {
    private static final long serialVersionUID = 1L;

    public SynchronizedShortBag(MutableShortBag bag) {
        super(bag);
    }

    public SynchronizedShortBag(MutableShortBag bag, Object newLock) {
        super(bag, newLock);
    }

    @GuardedBy(value="getLock()")
    private MutableShortBag getMutableShortBag() {
        return (MutableShortBag)this.getShortCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedShortBag with(short element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableShortBag().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedShortBag without(short element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableShortBag().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedShortBag withAll(ShortIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableShortBag().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedShortBag withoutAll(ShortIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableShortBag().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOccurrences(short item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableShortBag().addOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeOccurrences(short item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortBag().removeOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sizeDistinct() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortBag().sizeDistinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int occurrencesOf(short item) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortBag().occurrencesOf(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachWithOccurrences(ShortIntProcedure procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableShortBag().forEachWithOccurrences(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableShortBag select(ShortPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortBag().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableShortBag selectByOccurrences(IntPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortBag().selectByOccurrences(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<ShortIntPair> topOccurrences(int count) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortBag().topOccurrences(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<ShortIntPair> bottomOccurrences(int count) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortBag().bottomOccurrences(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableShortBag reject(ShortPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortBag().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableBag<V> collect(ShortToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortBag().collect((ShortToObjectFunction)function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object otherBag) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortBag().equals(otherBag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortBag().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyShortIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyShortIterableAdapter(this);
        }
    }

    @Override
    public MutableShortBag asUnmodifiable() {
        return new UnmodifiableShortBag(this);
    }

    @Override
    public MutableShortBag asSynchronized() {
        return this;
    }

    @Override
    public ImmutableShortBag toImmutable() {
        return ShortBags.immutable.withAll(this);
    }
}

