/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.block.function.Function;

@Immutable
public final class CollectIterator<T, V>
implements Iterator<V> {
    private final Iterator<T> iterator;
    private final Function<? super T, ? extends V> function;

    public CollectIterator(Iterable<T> iterable, Function<? super T, ? extends V> function) {
        this(iterable.iterator(), function);
    }

    public CollectIterator(Iterator<T> newIterator, Function<? super T, ? extends V> function) {
        this.iterator = newIterator;
        this.function = function;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from a collect iterator");
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public V next() {
        if (this.hasNext()) {
            return this.function.valueOf(this.iterator.next());
        }
        throw new NoSuchElementException();
    }
}

