/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ByteFloatPredicate;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteFloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.map.primitive.ByteFloatMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteFloatMap;
import org.eclipse.collections.api.map.primitive.MutableByteFloatMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.tuple.primitive.ByteFloatPair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedByteFloatProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import org.eclipse.collections.impl.iterator.UnmodifiableFloatIterator;
import org.eclipse.collections.impl.map.mutable.primitive.ByteFloatHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableByteSet;

final class ImmutableByteFloatHashMap
implements ImmutableByteFloatMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableByteFloatMap delegate;

    ImmutableByteFloatHashMap(ByteFloatMap delegate) {
        this.delegate = new ByteFloatHashMap(delegate);
    }

    @Override
    public float get(byte key) {
        return this.delegate.get(key);
    }

    @Override
    public float getIfAbsent(byte key, float ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    @Override
    public float getOrThrow(byte key) {
        return this.delegate.getOrThrow(key);
    }

    @Override
    public boolean containsKey(byte key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(float value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public void forEachValue(FloatProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    @Override
    public void forEachKey(ByteProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(ByteFloatProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    @Override
    public LazyByteIterable keysView() {
        return this.delegate.keysView();
    }

    @Override
    public RichIterable<ByteFloatPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    @Override
    public ImmutableByteFloatMap select(ByteFloatPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableByteFloatMap reject(ByteFloatPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public ImmutableByteFloatMap toImmutable() {
        return this;
    }

    @Override
    public FloatIterator floatIterator() {
        return new UnmodifiableFloatIterator(this.delegate.floatIterator());
    }

    @Override
    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(FloatProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public int count(FloatPredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(FloatPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(FloatPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(FloatPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public ImmutableFloatBag select(FloatPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableFloatBag reject(FloatPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> collect(FloatToObjectFunction<? extends V> function) {
        RichIterable bag = this.delegate.collect((FloatToObjectFunction)function);
        return bag.toImmutable();
    }

    @Override
    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public double sum() {
        return this.delegate.sum();
    }

    @Override
    public float max() {
        return this.delegate.max();
    }

    @Override
    public float maxIfEmpty(float defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    @Override
    public float min() {
        return this.delegate.min();
    }

    @Override
    public float minIfEmpty(float defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public float[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableFloatList toSortedList() {
        return this.delegate.toSortedList();
    }

    @Override
    public float[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public boolean contains(float value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(float ... source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(FloatIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public MutableFloatList toList() {
        return this.delegate.toList();
    }

    @Override
    public MutableFloatSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableFloatBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public LazyFloatIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public ImmutableByteFloatMap newWithKeyValue(byte key, float value) {
        ByteFloatHashMap map = new ByteFloatHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    @Override
    public ImmutableByteFloatMap newWithoutKey(byte key) {
        ByteFloatHashMap map = new ByteFloatHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    @Override
    public ImmutableByteFloatMap newWithoutAllKeys(ByteIterable keys) {
        ByteFloatHashMap map = new ByteFloatHashMap(this.size());
        map.putAll(this);
        ByteIterator iterator = keys.byteIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableByteSet keySet() {
        return UnmodifiableByteSet.of(this.delegate.keySet());
    }

    @Override
    public MutableFloatCollection values() {
        return UnmodifiableFloatCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableByteFloatMapSerializationProxy(this);
    }

    protected static class ImmutableByteFloatMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ByteFloatMap map;

        public ImmutableByteFloatMapSerializationProxy() {
        }

        protected ImmutableByteFloatMapSerializationProxy(ByteFloatMap map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue(new CheckedByteFloatProcedure(){

                    @Override
                    public void safeValue(byte key, float value) throws IOException {
                        out.writeByte(key);
                        out.writeFloat(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            ByteFloatHashMap deserializedMap = new ByteFloatHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readByte(), in.readFloat());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

