/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import net.jcip.annotations.NotThreadSafe;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.DoubleSet;
import org.eclipse.collections.api.set.primitive.ImmutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractUnmodifiableDoubleCollection;
import org.eclipse.collections.impl.set.mutable.primitive.SynchronizedDoubleSet;

@NotThreadSafe
public final class UnmodifiableDoubleSet
extends AbstractUnmodifiableDoubleCollection
implements MutableDoubleSet {
    private static final long serialVersionUID = 1L;

    public UnmodifiableDoubleSet(MutableDoubleSet set) {
        super(set);
    }

    public static UnmodifiableDoubleSet of(MutableDoubleSet set) {
        if (set == null) {
            throw new IllegalArgumentException("cannot create an UnmodifiableDoubleSet for null");
        }
        return new UnmodifiableDoubleSet(set);
    }

    private MutableDoubleSet getMutableDoubleSet() {
        return (MutableDoubleSet)this.getDoubleCollection();
    }

    @Override
    public UnmodifiableDoubleSet with(double element) {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableDoubleSet without(double element) {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableDoubleSet withAll(DoubleIterable elements) {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableDoubleSet withoutAll(DoubleIterable elements) {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableDoubleSet select(DoublePredicate predicate) {
        return this.getMutableDoubleSet().select(predicate);
    }

    @Override
    public MutableDoubleSet reject(DoublePredicate predicate) {
        return this.getMutableDoubleSet().reject(predicate);
    }

    @Override
    public <V> MutableSet<V> collect(DoubleToObjectFunction<? extends V> function) {
        return this.getMutableDoubleSet().collect((DoubleToObjectFunction)function);
    }

    @Override
    public boolean equals(Object otherSet) {
        return this.getMutableDoubleSet().equals(otherSet);
    }

    @Override
    public int hashCode() {
        return this.getMutableDoubleSet().hashCode();
    }

    @Override
    public MutableDoubleSet asUnmodifiable() {
        return this;
    }

    @Override
    public MutableDoubleSet asSynchronized() {
        return new SynchronizedDoubleSet(this);
    }

    @Override
    public DoubleSet freeze() {
        return this.getMutableDoubleSet().freeze();
    }

    @Override
    public ImmutableDoubleSet toImmutable() {
        return this.getMutableDoubleSet().toImmutable();
    }
}

