/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.ObjectShortIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.list.primitive.ShortList;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableShortStack;
import org.eclipse.collections.api.stack.primitive.ShortStack;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.factory.primitive.ShortStacks;
import org.eclipse.collections.impl.iterator.UnmodifiableShortIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.stack.mutable.primitive.ShortArrayStack;

@Immutable
final class ImmutableShortSingletonStack
implements ImmutableShortStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final short element1;

    ImmutableShortSingletonStack(short element) {
        this.element1 = element;
    }

    @Override
    public ShortIterator shortIterator() {
        return new UnmodifiableShortIterator(ShortArrayStack.newStackWith(this.element1).shortIterator());
    }

    @Override
    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(ShortProcedure procedure) {
        procedure.value(this.element1);
    }

    @Override
    public int count(ShortPredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    @Override
    public boolean anySatisfy(ShortPredicate predicate) {
        return predicate.accept(this.element1);
    }

    @Override
    public boolean allSatisfy(ShortPredicate predicate) {
        return predicate.accept(this.element1);
    }

    @Override
    public boolean noneSatisfy(ShortPredicate predicate) {
        return !predicate.accept(this.element1);
    }

    @Override
    public short peek() {
        return this.element1;
    }

    @Override
    public ShortList peek(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return new ShortArrayList(0);
        }
        if (count == 1) {
            return ShortArrayList.newListWith(this.element1);
        }
        throw new IllegalArgumentException("Count must be less than or equal to size: Count = " + count + " Size = 1");
    }

    @Override
    public short peekAt(int index) {
        this.checkNegativeCount(index);
        if (index == 0) {
            return this.element1;
        }
        throw new IllegalArgumentException("Index must be less than size: Index = " + index + " Size = 1");
    }

    @Override
    public ImmutableShortStack select(ShortPredicate predicate) {
        return predicate.accept(this.element1) ? ShortStacks.immutable.with(this.element1) : ShortStacks.immutable.with();
    }

    @Override
    public ImmutableShortStack reject(ShortPredicate predicate) {
        return predicate.accept(this.element1) ? ShortStacks.immutable.with() : ShortStacks.immutable.with(this.element1);
    }

    @Override
    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    @Override
    public <V> ImmutableStack<V> collect(ShortToObjectFunction<? extends V> function) {
        return Stacks.immutable.with(function.valueOf(this.element1));
    }

    @Override
    public long sum() {
        return this.element1;
    }

    @Override
    public short max() {
        return this.element1;
    }

    @Override
    public short maxIfEmpty(short defaultValue) {
        return this.element1;
    }

    @Override
    public short min() {
        return this.element1;
    }

    @Override
    public short minIfEmpty(short defaultValue) {
        return this.element1;
    }

    @Override
    public double average() {
        return this.element1;
    }

    @Override
    public double median() {
        return this.element1;
    }

    @Override
    public short[] toSortedArray() {
        return new short[]{this.element1};
    }

    @Override
    public MutableShortList toSortedList() {
        return ShortArrayList.newListWith(this.element1);
    }

    @Override
    public short[] toArray() {
        return new short[]{this.element1};
    }

    @Override
    public boolean contains(short value) {
        return this.element1 == value;
    }

    @Override
    public boolean containsAll(short ... source) {
        for (short value : source) {
            if (this.element1 == value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(ShortIterable source) {
        ShortIterator iterator = source.shortIterator();
        while (iterator.hasNext()) {
            if (this.element1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableShortList toList() {
        return ShortArrayList.newListWith(this.element1);
    }

    @Override
    public MutableShortSet toSet() {
        return ShortHashSet.newSetWith(this.element1);
    }

    @Override
    public MutableShortBag toBag() {
        return ShortHashBag.newBagWith(this.element1);
    }

    @Override
    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter(this);
    }

    @Override
    public ImmutableShortStack toImmutable() {
        return this;
    }

    @Override
    public ImmutableShortStack push(short element) {
        return ShortStacks.immutable.with(this.element1, element);
    }

    @Override
    public ImmutableShortStack pop() {
        return ShortStacks.immutable.with();
    }

    @Override
    public ImmutableShortStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        if (count == 1) {
            return ShortStacks.immutable.with();
        }
        throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = 1");
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.element1);
    }

    @Override
    public short getFirst() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getFirst() not implemented yet");
    }

    @Override
    public int indexOf(short value) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".indexOf() not implemented yet");
    }

    @Override
    public <T> T injectIntoWithIndex(T injectedValue, ObjectShortIntToObjectFunction<? super T, ? extends T> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".injectIntoWithIndex() not implemented yet");
    }

    @Override
    public void forEachWithIndex(ShortIntProcedure procedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEachWithIndex() not implemented yet");
    }

    @Override
    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof ShortStack)) {
            return false;
        }
        ShortStack stack = (ShortStack)otherStack;
        if (stack.size() != 1) {
            return false;
        }
        return this.element1 == stack.peek();
    }

    @Override
    public int hashCode() {
        return 31 + this.element1;
    }

    @Override
    public String toString() {
        return "[" + this.element1 + ']';
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

