/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.factory.stack.primitive.MutableDoubleStackFactory;
import org.eclipse.collections.api.stack.primitive.MutableDoubleStack;
import org.eclipse.collections.impl.stack.mutable.primitive.DoubleArrayStack;

public class MutableDoubleStackFactoryImpl
implements MutableDoubleStackFactory {
    @Override
    public MutableDoubleStack empty() {
        return new DoubleArrayStack();
    }

    @Override
    public MutableDoubleStack of() {
        return this.empty();
    }

    @Override
    public MutableDoubleStack with() {
        return this.empty();
    }

    @Override
    public MutableDoubleStack of(double ... items) {
        return this.with(items);
    }

    @Override
    public MutableDoubleStack with(double ... items) {
        if (items.length == 0) {
            return this.empty();
        }
        return DoubleArrayStack.newStackWith(items);
    }

    @Override
    public MutableDoubleStack ofAll(DoubleIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableDoubleStack withAll(DoubleIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return DoubleArrayStack.newStack(items);
    }

    @Override
    public MutableDoubleStack ofAllReversed(DoubleIterable items) {
        return this.withAllReversed(items);
    }

    @Override
    public MutableDoubleStack withAllReversed(DoubleIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return DoubleArrayStack.newStackFromTopToBottom(items);
    }
}

