/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.factory.stack.primitive.MutableFloatStackFactory;
import org.eclipse.collections.api.stack.primitive.MutableFloatStack;
import org.eclipse.collections.impl.stack.mutable.primitive.FloatArrayStack;

public class MutableFloatStackFactoryImpl
implements MutableFloatStackFactory {
    @Override
    public MutableFloatStack empty() {
        return new FloatArrayStack();
    }

    @Override
    public MutableFloatStack of() {
        return this.empty();
    }

    @Override
    public MutableFloatStack with() {
        return this.empty();
    }

    @Override
    public MutableFloatStack of(float ... items) {
        return this.with(items);
    }

    @Override
    public MutableFloatStack with(float ... items) {
        if (items.length == 0) {
            return this.empty();
        }
        return FloatArrayStack.newStackWith(items);
    }

    @Override
    public MutableFloatStack ofAll(FloatIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableFloatStack withAll(FloatIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return FloatArrayStack.newStack(items);
    }

    @Override
    public MutableFloatStack ofAllReversed(FloatIterable items) {
        return this.withAllReversed(items);
    }

    @Override
    public MutableFloatStack withAllReversed(FloatIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return FloatArrayStack.newStackFromTopToBottom(items);
    }
}

