/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.primitive;

import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.lazy.primitive.CollectIntToObjectIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.SelectIntIterable;

public final class LazyIntIterate {
    private static final LazyIntIterable EMPTY_ITERABLE = IntLists.immutable.of().asLazy();

    private LazyIntIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static LazyIntIterable adapt(IntIterable iterable) {
        return new LazyIntIterableAdapter(iterable);
    }

    public static LazyIntIterable select(IntIterable iterable, IntPredicate predicate) {
        return new SelectIntIterable(iterable, predicate);
    }

    public static <V> LazyIterable<V> collect(IntIterable iterable, IntToObjectFunction<? extends V> function) {
        return new CollectIntToObjectIterable<V>(iterable, function);
    }

    public static <V> LazyIterable<V> collectIf(IntIterable iterable, IntPredicate predicate, IntToObjectFunction<? extends V> function) {
        return LazyIntIterate.select(iterable, predicate).collect((IntToObjectFunction)function);
    }

    public static LazyIntIterable empty() {
        return EMPTY_ITERABLE;
    }
}

