/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.parser.antlr.splitting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.internal.LexerSpecialStateTransitionSplitter;

public class AntlrLexerSplitter {
    public static final String INDENT = "    ";
    public static final String INDENT2 = "        ";
    public static final Pattern METHOD_SIGNATURE_PATTERN = Pattern.compile("public void mTokens\\(\\) throws RecognitionException \\{", 0);
    public static final Pattern METHOD_END_PATTERN = Pattern.compile("^\\s{4}}", 0);
    public static final Pattern OUTER_BLOCK_END_PATTERN = Pattern.compile("^\\s{8}}", 0);
    public static final Pattern INDENT_LEVEL_PATTERN = Pattern.compile("^\\s{12}", 0);
    public static final Pattern ASSIGNMENT_PATTERN = Pattern.compile("int (\\w+)=\\d+", 0);
    public static final Pattern DFA_ASSIGNMENT_PATTERN = Pattern.compile("\\w+ = dfa\\d+\\.predict\\(input\\);", 0);
    public static final Pattern BREAK_LINE_PATTERN = Pattern.compile("^\\s{12}\\s*break;", 0);
    public static final Pattern OUTER_SWITCH_PATTERN = Pattern.compile("^\\s{8}switch", 0);
    public static final Pattern OUTER_IF_PATTERN = Pattern.compile("^\\s{8}if", 0);
    public static final Pattern OUTER_BRACE_IN_IF_CASCADE_PATTERN = Pattern.compile("^(\\s{12}[^\\s]+.*)}\\s*$", 0);
    public static final Pattern DFA_TRANSITIONS_PATTERN = Pattern.compile("(static final String\\[\\] (DFA\\d+_transitionS) = )\\{", 0);
    public static final Pattern DFA_FIELD_END_PATTERN = Pattern.compile("^\\s{4}};", 0);
    private List<ExtractedMethod> extractedMethods = new ArrayList<ExtractedMethod>();
    private StringBuilder stringBuilder;
    private final Scanner scanner;
    private boolean allowDFAStaticClasses = true;
    private int casesPerSpecialStateSwitch = -1;

    public List<ExtractedMethod> getExtractedMethods() {
        return Collections.unmodifiableList(this.extractedMethods);
    }

    public AntlrLexerSplitter(String content) {
        this.scanner = new Scanner(content);
    }

    private boolean copyUntilMethod() {
        while (this.scanner.hasNextLine()) {
            String line = this.scanner.nextLine();
            this.stringBuilder.append(line);
            this.stringBuilder.append("\n");
            if (!METHOD_SIGNATURE_PATTERN.matcher(line).find()) continue;
            return true;
        }
        return false;
    }

    public String transform() {
        if (this.stringBuilder != null) {
            return this.stringBuilder.toString();
        }
        this.stringBuilder = new StringBuilder();
        if (this.copyUntilMethod()) {
            this.refactorAndExtract();
            this.produceMethods();
        }
        this.copyTailAndRefactorDfaTransitionS();
        String result = this.stringBuilder.toString();
        LexerSpecialStateTransitionSplitter lexerSplitter = new LexerSpecialStateTransitionSplitter(false);
        lexerSplitter.setAllowDFAStaticClasses(this.allowDFAStaticClasses);
        lexerSplitter.setCasesPerSpecialStateSwitch(this.casesPerSpecialStateSwitch);
        result = lexerSplitter.transform(result);
        return result;
    }

    public void produceMethods() {
        for (ExtractedMethod m : this.extractedMethods) {
            m.writeTo(this.stringBuilder);
            this.stringBuilder.append("\n");
        }
    }

    public void refactorAndExtract() {
        this.refacatorAndExtract();
    }

    @Deprecated
    public void refacatorAndExtract() {
        this.stringBuilder.append(this.scanner.nextLine());
        this.stringBuilder.append("\n");
        String varDecl = this.scanner.nextLine();
        this.stringBuilder.append(varDecl);
        this.stringBuilder.append("\n");
        String varName = AntlrLexerSplitter.getVarnameFromDecl(varDecl);
        if (varName != null) {
            this.stringBuilder.append(this.scanner.nextLine());
            this.stringBuilder.append("\n");
            int lineNo = 2;
            do {
                ++lineNo;
                String line = this.scanner.nextLine();
                this.stringBuilder.append(line);
                this.stringBuilder.append("\n");
                if (OUTER_SWITCH_PATTERN.matcher(line).find()) {
                    this.extractMethodsFromSwitch(varName);
                    break;
                }
                if (!OUTER_IF_PATTERN.matcher(line).find()) continue;
                Pattern switchPattern = Pattern.compile(String.format("^        switch \\(%s\\) \\{", varName));
                this.extractMethodsFromIf(varName, switchPattern);
                break;
            } while (lineNo <= 4);
        }
        while (this.scanner.hasNextLine()) {
            String line = this.scanner.nextLine();
            this.stringBuilder.append(line);
            this.stringBuilder.append("\n");
            if (!METHOD_END_PATTERN.matcher(line).find()) continue;
            break;
        }
    }

    private void extractMethodsFromSwitch(String varName) {
        while (this.scanner.hasNextLine()) {
            String line = this.scanner.nextLine();
            this.stringBuilder.append(line);
            this.stringBuilder.append("\n");
            if (!OUTER_BLOCK_END_PATTERN.matcher(line).find()) continue;
            break;
        }
    }

    private void extractMethodsFromIf(String varName, Pattern endPattern) {
        while (this.scanner.hasNextLine()) {
            String line = this.scanner.nextLine();
            if (INDENT_LEVEL_PATTERN.matcher(line).find()) {
                ExtractedMethod method = new ExtractedMethod(varName, this.extractedMethods.size() + 1);
                AntlrLexerSplitter.extractMethod(this.stringBuilder, this.scanner, varName, method, line);
                this.extractedMethods.add(method);
            } else {
                this.stringBuilder.append(line);
                this.stringBuilder.append("\n");
            }
            if (!endPattern.matcher(line).find()) continue;
            break;
        }
    }

    static void extractMethod(StringBuilder sb, Scanner scanner, String varName, ExtractedMethod method, String firstLine) {
        boolean addBrace = method.addLine(firstLine) == ExtractedMethod.ExtractedMethodLineState.ignoredClosingBrace;
        boolean simplyEndOfMethod = false;
        String line = null;
        do {
            if (addBrace || simplyEndOfMethod) {
                sb.append(INDENT2);
                sb.append(INDENT);
                sb.append(varName);
                sb.append(" = ");
                sb.append(method.getName());
                sb.append("();");
                if (addBrace) {
                    sb.append("}");
                }
                sb.append("\n");
                if (line == null) break;
                sb.append(line);
                sb.append("\n");
                break;
            }
            if (!scanner.hasNextLine()) continue;
            line = scanner.nextLine();
            if (INDENT_LEVEL_PATTERN.matcher(line).find() || "".equals(line)) {
                addBrace = method.addLine(line) == ExtractedMethod.ExtractedMethodLineState.ignoredClosingBrace;
                continue;
            }
            simplyEndOfMethod = true;
        } while (scanner.hasNextLine());
    }

    private static String getVarnameFromDecl(String varDecl) {
        Matcher m = ASSIGNMENT_PATTERN.matcher(varDecl);
        if (!m.find()) {
            return null;
        }
        return m.group(1);
    }

    private void copyTailAndRefactorDfaTransitionS() {
        this.copyAndBeginNestedClass();
        this.copyFieldAndEndNestedClass();
        this.copyTail();
    }

    private void copyAndBeginNestedClass() {
        while (this.scanner.hasNextLine()) {
            String line = this.scanner.nextLine();
            Matcher matcher = DFA_TRANSITIONS_PATTERN.matcher(line);
            if (matcher.find()) {
                String fieldDecl = matcher.group(1);
                String fieldName = matcher.group(2);
                this.stringBuilder.append(INDENT).append(fieldDecl).append(fieldName).append("_.").append(fieldName).append(";\n");
                this.stringBuilder.append(INDENT).append("private static final class ").append(fieldName).append("_ {\n");
                this.stringBuilder.append(INDENT).append(line).append('\n');
                break;
            }
            this.stringBuilder.append(line);
            if (!this.scanner.hasNextLine()) continue;
            this.stringBuilder.append("\n");
        }
    }

    private void copyFieldAndEndNestedClass() {
        while (this.scanner.hasNextLine()) {
            String line = this.scanner.nextLine();
            this.stringBuilder.append(INDENT).append(line).append("\n");
            if (!DFA_FIELD_END_PATTERN.matcher(line).matches()) continue;
            this.stringBuilder.append(INDENT).append("}\n");
            break;
        }
    }

    private void copyTail() {
        while (this.scanner.hasNextLine()) {
            this.stringBuilder.append(this.scanner.nextLine());
            if (!this.scanner.hasNextLine()) continue;
            this.stringBuilder.append("\n");
        }
    }

    public boolean isAllowDFAStaticClasses() {
        return this.allowDFAStaticClasses;
    }

    public void setAllowDFAStaticClasses(boolean value) {
        this.allowDFAStaticClasses = value;
    }

    public int getCasesPerSpecialStateSwitch() {
        return this.casesPerSpecialStateSwitch;
    }

    public void setCasesPerSpecialStateSwitch(int value) {
        this.casesPerSpecialStateSwitch = value;
    }

    public static class ExtractedMethod {
        private final int index;
        private final List<String> lines = new ArrayList<String>();
        private final Pattern assignmentPattern;

        public ExtractedMethod(String resultVar, int index) {
            this.index = index;
            this.assignmentPattern = Pattern.compile(resultVar + "=(\\d+);", 0);
        }

        public ExtractedMethodLineState addLine(String line) {
            if (BREAK_LINE_PATTERN.matcher(line).find()) {
                return ExtractedMethodLineState.ignored;
            }
            Matcher m = OUTER_BRACE_IN_IF_CASCADE_PATTERN.matcher(line);
            if (m.find()) {
                this.lines.add(m.group(1));
                return ExtractedMethodLineState.ignoredClosingBrace;
            }
            this.lines.add(line);
            return ExtractedMethodLineState.added;
        }

        public Object getName() {
            return String.format("mTokensHelper%03d", this.index);
        }

        public void writeTo(StringBuilder sb) {
            sb.append(AntlrLexerSplitter.INDENT);
            sb.append("private int ");
            sb.append(this.getName());
            sb.append("() throws RecognitionException {\n");
            for (String s : this.lines) {
                sb.append(this.getAsExtractedLine(s));
                sb.append("\n");
            }
            sb.append(AntlrLexerSplitter.INDENT);
            sb.append("}\n");
        }

        public String getAsExtractedLine(String s) {
            return this.assignmentPattern.matcher(s).replaceFirst("return $1;").replaceFirst(AntlrLexerSplitter.INDENT, "");
        }

        private static enum ExtractedMethodLineState {
            added,
            ignored,
            ignoredClosingBrace;

        }
    }
}

