/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.core.build.IBuildObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.MultiSourceEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.build.BuildInputContext;
import org.eclipse.pde.internal.ui.editor.build.BuildInputContextManager;
import org.eclipse.pde.internal.ui.editor.build.BuildOutlinePage;
import org.eclipse.pde.internal.ui.editor.build.BuildPage;
import org.eclipse.pde.internal.ui.editor.build.BuildSourcePage;
import org.eclipse.pde.internal.ui.editor.build.BuildUndoManager;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.PluginExportAction;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class BuildEditor
extends MultiSourceEditor {
    private PluginExportAction fExportAction;

    @Override
    protected String getEditorID() {
        return "org.eclipse.pde.ui.buildEditor";
    }

    @Override
    protected void createResourceContexts(InputContextManager manager, IFileEditorInput input) {
        IFile file = input.getFile();
        manager.putContext((IEditorInput)input, new BuildInputContext(this, (IEditorInput)input, true));
        manager.monitorFile(file);
    }

    @Override
    protected InputContextManager createInputContextManager() {
        BuildInputContextManager manager = new BuildInputContextManager(this);
        manager.setUndoManager(new BuildUndoManager(this));
        return manager;
    }

    @Override
    public void monitoredFileAdded(IFile file) {
        if (this.fInputContextManager == null) {
            return;
        }
        String name = file.getName();
        if (name.equalsIgnoreCase("build.properties") && !this.fInputContextManager.hasContext("build-context")) {
            FileEditorInput in = new FileEditorInput(file);
            this.fInputContextManager.putContext((IEditorInput)in, new BuildInputContext(this, (IEditorInput)in, false));
        }
    }

    @Override
    public boolean monitoredFileRemoved(IFile file) {
        return true;
    }

    @Override
    public void editorContextAdded(InputContext context) {
        this.addSourcePage(context.getId());
    }

    @Override
    public void contextRemoved(InputContext context) {
        this.close(false);
    }

    @Override
    protected void createSystemFileContexts(InputContextManager manager, FileStoreEditorInput input) {
        manager.putContext((IEditorInput)input, new BuildInputContext(this, (IEditorInput)input, true));
    }

    @Override
    protected void createStorageContexts(InputContextManager manager, IStorageEditorInput input) {
        manager.putContext((IEditorInput)input, new BuildInputContext(this, (IEditorInput)input, true));
    }

    @Override
    protected void addEditorPages() {
        try {
            if (this.getEditorInput() instanceof IFileEditorInput) {
                this.addPage((IFormPage)new BuildPage(this));
            }
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
        this.addSourcePage("build-context");
    }

    @Override
    protected String computeInitialPageId() {
        String firstPageId = super.computeInitialPageId();
        if (firstPageId == null) {
            return "build";
        }
        return firstPageId;
    }

    @Override
    protected PDESourcePage createSourcePage(PDEFormEditor editor, String title, String name, String contextId) {
        return new BuildSourcePage(editor, title, name);
    }

    @Override
    protected ISortableContentOutlinePage createContentOutline() {
        return new BuildOutlinePage(this);
    }

    protected IPropertySheetPage getPropertySheet(PDEFormPage page) {
        return null;
    }

    @Override
    public String getTitle() {
        return super.getTitle();
    }

    protected boolean isModelCorrect(Object model) {
        return model != null ? ((IBuildModel)model).isValid() : false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasKnownTypes() {
        try {
            TransferData[] types = this.getClipboard().getAvailableTypes();
            Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
            TransferData[] transferDataArray = types;
            int n = types.length;
            int n2 = 0;
            block2: while (true) {
                if (n2 >= n) {
                    return false;
                }
                TransferData type = transferDataArray[n2];
                Transfer[] transferArray = transfers;
                int n3 = transfers.length;
                int n4 = 0;
                while (true) {
                    if (n4 >= n3) {
                        ++n2;
                        continue block2;
                    }
                    Transfer transfer = transferArray[n4];
                    if (transfer.isSupportedType(type)) {
                        return true;
                    }
                    ++n4;
                }
                break;
            }
        }
        catch (SWTError sWTError) {}
        return false;
    }

    @Override
    public <T> T getAdapter(Class<T> key) {
        if (key.equals(IPropertySheetPage.class)) {
            return null;
        }
        return super.getAdapter(key);
    }

    @Override
    protected InputContext getInputContext(Object object) {
        InputContext context = null;
        if (object instanceof IBuildObject) {
            context = this.fInputContextManager.findContext("build-context");
        }
        return context;
    }

    @Override
    public void contributeToToolbar(IToolBarManager manager) {
        manager.add((IAction)this.getExportAction());
    }

    private PluginExportAction getExportAction() {
        if (this.fExportAction == null) {
            this.fExportAction = new PluginExportAction(this);
            this.fExportAction.setToolTipText(PDEUIMessages.PluginEditor_exportTooltip);
            this.fExportAction.setImageDescriptor(PDEPluginImages.DESC_EXPORT_PLUGIN_TOOL);
        }
        return this.fExportAction;
    }
}

