/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.CommandEvent;
import org.eclipse.comma.actions.actions.EventPattern;
import org.eclipse.comma.actions.actions.Multiplicity;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.component.component.CONNECTION_QUANTIFIER;
import org.eclipse.comma.behavior.component.component.CommandReply;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.component.component.ComponentPart;
import org.eclipse.comma.behavior.component.component.Connection;
import org.eclipse.comma.behavior.component.component.ConstraintState;
import org.eclipse.comma.behavior.component.component.EventReception;
import org.eclipse.comma.behavior.component.component.ExpressionConnectionState;
import org.eclipse.comma.behavior.component.component.ExpressionInterfaceState;
import org.eclipse.comma.behavior.component.component.FunctionalConstraint;
import org.eclipse.comma.behavior.component.component.PortAwareEvent;
import org.eclipse.comma.behavior.component.component.PortSelector;
import org.eclipse.comma.behavior.component.component.PredicateFunctionalConstraint;
import org.eclipse.comma.behavior.component.component.StateBasedFunctionalConstraint;
import org.eclipse.comma.behavior.component.component.TraceFragment;
import org.eclipse.comma.behavior.component.utilities.ComponentUtilities;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionAddition;
import org.eclipse.comma.expressions.expression.ExpressionAnd;
import org.eclipse.comma.expressions.expression.ExpressionAny;
import org.eclipse.comma.expressions.expression.ExpressionBracket;
import org.eclipse.comma.expressions.expression.ExpressionBulkData;
import org.eclipse.comma.expressions.expression.ExpressionConstantBool;
import org.eclipse.comma.expressions.expression.ExpressionConstantInt;
import org.eclipse.comma.expressions.expression.ExpressionConstantReal;
import org.eclipse.comma.expressions.expression.ExpressionConstantString;
import org.eclipse.comma.expressions.expression.ExpressionDivision;
import org.eclipse.comma.expressions.expression.ExpressionEnumLiteral;
import org.eclipse.comma.expressions.expression.ExpressionEqual;
import org.eclipse.comma.expressions.expression.ExpressionFunctionCall;
import org.eclipse.comma.expressions.expression.ExpressionGeq;
import org.eclipse.comma.expressions.expression.ExpressionGreater;
import org.eclipse.comma.expressions.expression.ExpressionLeq;
import org.eclipse.comma.expressions.expression.ExpressionLess;
import org.eclipse.comma.expressions.expression.ExpressionMap;
import org.eclipse.comma.expressions.expression.ExpressionMapRW;
import org.eclipse.comma.expressions.expression.ExpressionMaximum;
import org.eclipse.comma.expressions.expression.ExpressionMinimum;
import org.eclipse.comma.expressions.expression.ExpressionMinus;
import org.eclipse.comma.expressions.expression.ExpressionModulo;
import org.eclipse.comma.expressions.expression.ExpressionMultiply;
import org.eclipse.comma.expressions.expression.ExpressionNEqual;
import org.eclipse.comma.expressions.expression.ExpressionNot;
import org.eclipse.comma.expressions.expression.ExpressionOr;
import org.eclipse.comma.expressions.expression.ExpressionPlus;
import org.eclipse.comma.expressions.expression.ExpressionPower;
import org.eclipse.comma.expressions.expression.ExpressionQuantifier;
import org.eclipse.comma.expressions.expression.ExpressionRecord;
import org.eclipse.comma.expressions.expression.ExpressionRecordAccess;
import org.eclipse.comma.expressions.expression.ExpressionSubtraction;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.ExpressionVector;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.monitoring.generator.EventPatternMixin;
import org.eclipse.comma.monitoring.generator.TypesJavaGenerator;
import org.eclipse.comma.types.types.NamedElement;
import org.eclipse.comma.types.utilities.CommaUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class FunctionalConstraintGenerator
extends EventPatternMixin {
    private Iterable<Interface> interfaces;
    private boolean inEventReception = false;
    private String eventReceptionPort = "";
    private String eventReceptionConnection = "";

    public FunctionalConstraintGenerator(Iterable<Interface> interfaces, IFileSystemAccess fsa) {
        super(null, fsa);
        this.interfaces = interfaces;
    }

    public void generateUtilityClass(Component c, FunctionalConstraint fc) {
        ArrayList _arrayList;
        this.quantifiersInMachines = _arrayList = new ArrayList();
        this.quantifiersInMachines.addAll(this.getQuantifiersInContainer((EObject)fc));
        this.fsa.generateFile(TypesJavaGenerator.generatedFileName(FunctionalConstraintGenerator.utilityClassName(c, fc).toString()), this.utilityClassContent(fc, c));
    }

    public void generateConstraintClass(Component c, FunctionalConstraint fc) {
        ArrayList _arrayList;
        this.quantifiersInMachines = _arrayList = new ArrayList();
        this.quantifiersInMachines.addAll(this.getQuantifiersInContainer((EObject)fc));
        this.fsa.generateFile(TypesJavaGenerator.generatedFileName(FunctionalConstraintGenerator.constraintClassName(c, fc).toString()), this.constraintClassContent(fc, c));
    }

    public CharSequence constraintClassImportPart() {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.Arrays;");
        _builder.newLine();
        _builder.append("import java.util.ArrayList;");
        _builder.newLine();
        _builder.append("import java.util.HashSet;");
        _builder.newLine();
        _builder.append("import java.util.List;");
        _builder.newLine();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".messages.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".values.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".utils.Utils;");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _constraintClassContent(PredicateFunctionalConstraint fc, Component c) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _constraintClassImportPart = this.constraintClassImportPart();
        _builder.append((Object)_constraintClassImportPart);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public class ");
        String _constraintClassName = FunctionalConstraintGenerator.constraintClassName(c, (FunctionalConstraint)fc);
        _builder.append(_constraintClassName);
        _builder.append(" extends CFunctionalConstraint {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private ");
        String _utilityClassName = FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName, "\t");
        _builder.append(" stateOfDecisionClass;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        String _constraintClassName_1 = FunctionalConstraintGenerator.constraintClassName(c, (FunctionalConstraint)fc);
        _builder.append(_constraintClassName_1, "\t");
        _builder.append("(String name, String componentInstanceName) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("super(name, componentInstanceName);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("stateOfDecisionClass = new ");
        String _utilityClassName_1 = FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName_1, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setState(CFunctionalConstraintState state) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("stateOfDecisionClass = (");
        String _utilityClassName_2 = FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName_2, "\t\t");
        _builder.append(") state;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public CFunctionalConstraintState getInitialState() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return stateOfDecisionClass;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public CFunctionalConstraintResult consume(CObservedMessage message) {");
        _builder.newLine();
        _builder.append("\t    ");
        _builder.append("CFunctionalConstraintResult result = new CFunctionalConstraintResult();");
        _builder.newLine();
        _builder.append("\t\t");
        String _xblockexpression = null;
        this.inEventReception = true;
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("determineContextPort(message)");
        this.eventReceptionPort = _builder_1.toString();
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("determineContextConnection(message)");
        this.eventReceptionConnection = _builder_2.toString();
        _xblockexpression = "";
        _builder.append(_xblockexpression, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("if((");
        CharSequence _generateExpression = this.generateExpression(fc.getExpression());
        _builder.append((Object)_generateExpression, "\t\t");
        _builder.append(") &&");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        String _xblockexpression_1 = null;
        this.inEventReception = false;
        _xblockexpression_1 = "";
        _builder.append(_xblockexpression_1, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t  ");
        _builder.append("(");
        CharSequence _generateExpression_1 = this.generateExpression(fc.getExpression());
        _builder.append((Object)_generateExpression_1, "\t\t\t  ");
        _builder.append(")) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t  \t");
        _builder.append("result.states.add(stateOfDecisionClass);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _constraintClassContent(StateBasedFunctionalConstraint fc, Component c) {
        StringConcatenation _xblockexpression = null;
        ArrayList<String> states = this.getStateNames(fc);
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _constraintClassImportPart = this.constraintClassImportPart();
        _builder.append((Object)_constraintClassImportPart);
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("public class ");
        String _constraintClassName = FunctionalConstraintGenerator.constraintClassName(c, (FunctionalConstraint)fc);
        _builder.append(_constraintClassName);
        _builder.append(" extends CFunctionalConstraint {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private ");
        String _utilityClassName = FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName, "\t");
        _builder.append(" lastReceivedState;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private ");
        String _utilityClassName_1 = FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName_1, "\t");
        _builder.append(" stateOfDecisionClass;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        String _constraintClassName_1 = FunctionalConstraintGenerator.constraintClassName(c, (FunctionalConstraint)fc);
        _builder.append(_constraintClassName_1, "\t");
        _builder.append("(String name, String componentInstanceName) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("super(name, componentInstanceName);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("stateOfDecisionClass = new ");
        String _utilityClassName_2 = FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName_2, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setState(CFunctionalConstraintState state) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("lastReceivedState = (");
        String _utilityClassName_3 = FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName_3, "\t\t");
        _builder.append(") state;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public CFunctionalConstraintState getInitialState() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return stateOfDecisionClass;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public CFunctionalConstraintResult consume(CObservedMessage message) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("switch(lastReceivedState.getState()) {");
        _builder.newLine();
        for (String s : states) {
            _builder.append("\t\t");
            _builder.append("case \"");
            _builder.append(s, "\t\t");
            _builder.append("\" : return state");
            _builder.append(s, "\t\t");
            _builder.append("(message);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("default: return null;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        EList _states = fc.getStates();
        for (State s_1 : _states) {
            _builder.append("\t");
            CharSequence _generateStateMethod = this.generateStateMethod((ConstraintState)s_1, FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc));
            _builder.append((Object)_generateStateMethod, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _generateFragmentMethods = this.generateFragmentMethods((ConstraintState)s_1);
            _builder.append((Object)_generateFragmentMethods, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence bindParameters(EventPattern ev) {
        StringConcatenation _xblockexpression = null;
        CommandEvent _xifexpression = null;
        _xifexpression = ev instanceof CommandReply ? ((CommandReply)ev).getCommand() : null;
        CommandEvent command = _xifexpression;
        List parameters = ComponentUtilities.getParameters((EventPattern)ev);
        StringConcatenation _builder = new StringConcatenation();
        int _size = parameters.size();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
        for (Integer i : _doubleDotLessThan) {
            Expression p = (Expression)parameters.get(i);
            _builder.newLineIfNotEmpty();
            if (!(p instanceof ExpressionVariable)) continue;
            _builder.append("stateOfDecisionClass.set_");
            _builder.append("commaVar_");
            String _name = ((ExpressionVariable)p).getVariable().getName();
            _builder.append(_name);
            _builder.append("(message.getParameters().get(");
            _builder.append((Object)i);
            _builder.append("));");
            _builder.newLineIfNotEmpty();
        }
        if (command != null) {
            List commandParams = ComponentUtilities.getParameters((EventPattern)command);
            _builder.newLineIfNotEmpty();
            int _size_1 = commandParams.size();
            ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, _size_1, true);
            for (Integer i_1 : _doubleDotLessThan_1) {
                Expression p_1 = (Expression)commandParams.get(i_1);
                _builder.newLineIfNotEmpty();
                if (!(p_1 instanceof ExpressionVariable)) continue;
                _builder.append("stateOfDecisionClass.set_");
                _builder.append("commaVar_");
                String _name_1 = ((ExpressionVariable)p_1).getVariable().getName();
                _builder.append(_name_1);
                _builder.append("(((CObservedReply)message).getCommand().getParameters().get(");
                _builder.append((Object)i_1);
                _builder.append("));");
                _builder.newLineIfNotEmpty();
            }
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public String determineContextPort(PortAwareEvent ev) {
        boolean _tripleNotEquals;
        String _xifexpression = null;
        ComponentPart _part = ev.getPart();
        boolean bl = _tripleNotEquals = _part != null;
        if (_tripleNotEquals) {
            String _name = ev.getPart().getName();
            String _plus = String.valueOf(_name) + ".";
            String _name_1 = ev.getPort().getName();
            _xifexpression = String.valueOf(_plus) + _name_1;
        } else {
            _xifexpression = ev.getPort().getName();
        }
        return _xifexpression;
    }

    public CharSequence determineContextConnection(PortAwareEvent ev) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        ComponentPart _part = ev.getPart();
        boolean bl = _tripleNotEquals = _part != null;
        if (_tripleNotEquals) {
            _builder.append("(componentInstanceName + \".\" + \"");
            String _name = ev.getPart().getName();
            _builder.append(_name);
            _builder.append("\")");
        } else {
            _builder.append("componentInstanceName");
        }
        _builder.append(".equals(message.getSource()) ? message.getDestination() : message.getSource()");
        return _builder;
    }

    public CharSequence generateFragmentMethods(ConstraintState s) {
        StringConcatenation _builder = new StringConcatenation();
        EList _traceFragments = s.getTraceFragments();
        for (TraceFragment fragment : _traceFragments) {
            ArrayList<List<Action>> _splitFragmentByAction = this.splitFragmentByAction((List<Action>)fragment.getActions());
            for (List<Action> actionFragment : _splitFragmentByAction) {
                Action _get_3;
                Expression _condition;
                boolean _tripleNotEquals_2;
                boolean _tripleNotEquals;
                _builder.append("private CFunctionalConstraintResult state");
                String _name = s.getName();
                _builder.append(_name);
                _builder.append("_");
                int _indexOf = s.getTraceFragments().indexOf((Object)fragment);
                int _plus = _indexOf + 1;
                _builder.append((Object)_plus);
                _builder.append("_");
                int _indexOf_1 = this.splitFragmentByAction((List<Action>)fragment.getActions()).indexOf(actionFragment);
                int _plus_1 = _indexOf_1 + 1;
                _builder.append((Object)_plus_1);
                _builder.append("(CObservedMessage message) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("CMessagePattern e;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("CFunctionalConstraintResult result = new CFunctionalConstraintResult();");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("stateOfDecisionClass = lastReceivedState;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("e = ");
                Action _get = actionFragment.get(0);
                CharSequence _generateEvent = this.generateEvent(((EventReception)_get).getEvent());
                _builder.append((Object)_generateEvent, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("if(e.match(message)) {");
                _builder.newLine();
                _builder.append("\t    ");
                Action _get_1 = actionFragment.get(0);
                CharSequence _bindParameters = this.bindParameters(((EventReception)_get_1).getEvent());
                _builder.append((Object)_bindParameters, "\t    ");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                Action _get_2 = actionFragment.get(0);
                EventPattern event = ((EventReception)_get_2).getEvent();
                _builder.newLineIfNotEmpty();
                ExpressionVariable _idVar = ((PortAwareEvent)event).getIdVar();
                boolean bl = _tripleNotEquals = _idVar != null;
                if (_tripleNotEquals) {
                    boolean _tripleNotEquals_1;
                    _builder.append("\t\t");
                    _builder.append("stateOfDecisionClass.set_");
                    _builder.append("commaVar_", "\t\t");
                    String _name_1 = ((PortAwareEvent)event).getIdVar().getVariable().getName();
                    _builder.append(_name_1, "\t\t");
                    _builder.append("(message.getDestination().equals(componentInstanceName");
                    ComponentPart _part = ((PortAwareEvent)event).getPart();
                    boolean bl2 = _tripleNotEquals_1 = _part != null;
                    if (_tripleNotEquals_1) {
                        _builder.append(" + \".\" + \"");
                        String _name_2 = ((PortAwareEvent)event).getPart().getName();
                        _builder.append(_name_2, "\t\t");
                        _builder.append("\"");
                    }
                    _builder.append(") ? message.getSource() : message.getDestination());");
                    _builder.newLineIfNotEmpty();
                }
                boolean bl3 = _tripleNotEquals_2 = (_condition = ((EventReception)(_get_3 = actionFragment.get(0))).getCondition()) != null;
                if (_tripleNotEquals_2) {
                    _builder.append("\t\t");
                    String _xblockexpression = null;
                    this.inEventReception = true;
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("\"");
                    Action _get_4 = actionFragment.get(0);
                    EventPattern _event = ((EventReception)_get_4).getEvent();
                    String _determineContextPort = this.determineContextPort((PortAwareEvent)_event);
                    _builder_1.append(_determineContextPort);
                    _builder_1.append("\"");
                    this.eventReceptionPort = _builder_1.toString();
                    StringConcatenation _builder_2 = new StringConcatenation();
                    Action _get_5 = actionFragment.get(0);
                    EventPattern _event_1 = ((EventReception)_get_5).getEvent();
                    CharSequence _determineContextConnection = this.determineContextConnection((PortAwareEvent)_event_1);
                    _builder_2.append((Object)_determineContextConnection);
                    this.eventReceptionConnection = _builder_2.toString();
                    _xblockexpression = "";
                    _builder.append(_xblockexpression, "\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("if(");
                    Action _get_42 = actionFragment.get(0);
                    CharSequence _generateExpression = this.generateExpression(((EventReception)_get_42).getCondition());
                    _builder.append((Object)_generateExpression, "\t\t");
                    _builder.append(") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    String _xblockexpression_1 = null;
                    this.inEventReception = false;
                    _xblockexpression_1 = "";
                    _builder.append(_xblockexpression_1, "\t\t\t");
                    _builder.newLineIfNotEmpty();
                    int _size = actionFragment.size();
                    ExclusiveRange _doubleDotLessThan = new ExclusiveRange(1, _size, true);
                    for (Integer i : _doubleDotLessThan) {
                        _builder.append("\t\t");
                        _builder.append("\t");
                        CharSequence _generateAction = this.generateAction(actionFragment.get(i));
                        _builder.append((Object)_generateAction, "\t\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("stateOfDecisionClass.setState(\"");
                    List _last = (List)IterableExtensions.last(this.splitFragmentByAction((List<Action>)fragment.getActions()));
                    boolean _equals = Objects.equal(actionFragment, (Object)_last);
                    if (_equals) {
                        String _name_3 = fragment.getTarget().getName();
                        _builder.append(_name_3, "\t\t\t");
                    } else {
                        String _name_4 = s.getName();
                        _builder.append(_name_4, "\t\t\t");
                        _builder.append("_");
                        int _indexOf_2 = s.getTraceFragments().indexOf((Object)fragment);
                        int _plus_2 = _indexOf_2 + 1;
                        _builder.append((Object)_plus_2, "\t\t\t");
                        _builder.append("_");
                        int _indexOf_3 = this.splitFragmentByAction((List<Action>)fragment.getActions()).indexOf(actionFragment);
                        int _plus_3 = _indexOf_3 + 2;
                        _builder.append((Object)_plus_3, "\t\t\t");
                    }
                    _builder.append("\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("result.states.add(stateOfDecisionClass);");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("}");
                    _builder.newLine();
                } else {
                    int _size_1 = actionFragment.size();
                    ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(1, _size_1, true);
                    for (Integer i_1 : _doubleDotLessThan_1) {
                        _builder.append("\t\t");
                        CharSequence _generateAction_1 = this.generateAction(actionFragment.get(i_1));
                        _builder.append((Object)_generateAction_1, "\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t\t");
                    _builder.append("stateOfDecisionClass.setState(\"");
                    List _last_1 = (List)IterableExtensions.last(this.splitFragmentByAction((List<Action>)fragment.getActions()));
                    boolean _equals_1 = Objects.equal(actionFragment, (Object)_last_1);
                    if (_equals_1) {
                        String _name_5 = fragment.getTarget().getName();
                        _builder.append(_name_5, "\t\t");
                    } else {
                        String _name_6 = s.getName();
                        _builder.append(_name_6, "\t\t");
                        _builder.append("_");
                        int _indexOf_4 = s.getTraceFragments().indexOf((Object)fragment);
                        int _plus_4 = _indexOf_4 + 1;
                        _builder.append((Object)_plus_4, "\t\t");
                        _builder.append("_");
                        int _indexOf_5 = this.splitFragmentByAction((List<Action>)fragment.getActions()).indexOf(actionFragment);
                        int _plus_5 = _indexOf_5 + 2;
                        _builder.append((Object)_plus_5, "\t\t");
                    }
                    _builder.append("\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("result.states.add(stateOfDecisionClass);");
                    _builder.newLine();
                }
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("return result;");
                _builder.newLine();
                _builder.append("}\t");
                _builder.newLine();
            }
        }
        return _builder;
    }

    public CharSequence generateStateMethod(ConstraintState s, String stateClassName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private CFunctionalConstraintResult state");
        String _name = s.getName();
        _builder.append(_name);
        _builder.append("(CObservedMessage message) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("CMessagePattern e;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("CFunctionalConstraintResult result = new CFunctionalConstraintResult();");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        EList _traceFragments = s.getTraceFragments();
        for (TraceFragment fragment : _traceFragments) {
            Expression _condition;
            boolean _tripleNotEquals_2;
            boolean _tripleNotEquals;
            _builder.append("\t");
            Action _firstAction = fragment.getFirstAction();
            EventReception first = (EventReception)_firstAction;
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("stateOfDecisionClass = (");
            _builder.append(stateClassName, "\t");
            _builder.append(") Utils.deepCopy(lastReceivedState);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("e = ");
            CharSequence _generateEvent = this.generateEvent(first.getEvent());
            _builder.append((Object)_generateEvent, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("if (e.match(message)) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("    ");
            CharSequence _bindParameters = this.bindParameters(first.getEvent());
            _builder.append((Object)_bindParameters, "\t    ");
            _builder.newLineIfNotEmpty();
            EventPattern _event = first.getEvent();
            ExpressionVariable _idVar = ((PortAwareEvent)_event).getIdVar();
            boolean bl = _tripleNotEquals = _idVar != null;
            if (_tripleNotEquals) {
                boolean _tripleNotEquals_1;
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("stateOfDecisionClass.set_");
                _builder.append("commaVar_", "\t\t");
                EventPattern _event_1 = first.getEvent();
                String _name_1 = ((PortAwareEvent)_event_1).getIdVar().getVariable().getName();
                _builder.append(_name_1, "\t\t");
                _builder.append("(message.getDestination().equals(componentInstanceName");
                EventPattern _event_2 = first.getEvent();
                ComponentPart _part = ((PortAwareEvent)_event_2).getPart();
                boolean bl2 = _tripleNotEquals_1 = _part != null;
                if (_tripleNotEquals_1) {
                    _builder.append(" + \".\" + \"");
                    EventPattern _event_3 = first.getEvent();
                    String _name_2 = ((PortAwareEvent)_event_3).getPart().getName();
                    _builder.append(_name_2, "\t\t");
                    _builder.append("\"");
                }
                _builder.append(") ? message.getSource() : message.getDestination());");
                _builder.newLineIfNotEmpty();
            }
            boolean bl3 = _tripleNotEquals_2 = (_condition = first.getCondition()) != null;
            if (_tripleNotEquals_2) {
                int _size;
                boolean _equals;
                _builder.append("\t");
                _builder.append("\t");
                String _xblockexpression = null;
                this.inEventReception = true;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("\"");
                EventPattern _event_4 = first.getEvent();
                String _determineContextPort = this.determineContextPort((PortAwareEvent)_event_4);
                _builder_1.append(_determineContextPort);
                _builder_1.append("\"");
                this.eventReceptionPort = _builder_1.toString();
                StringConcatenation _builder_2 = new StringConcatenation();
                EventPattern _event_5 = first.getEvent();
                CharSequence _determineContextConnection = this.determineContextConnection((PortAwareEvent)_event_5);
                _builder_2.append((Object)_determineContextConnection);
                this.eventReceptionConnection = _builder_2.toString();
                _xblockexpression = "";
                _builder.append(_xblockexpression, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("if(");
                CharSequence _generateExpression = this.generateExpression(first.getCondition());
                _builder.append((Object)_generateExpression, "\t\t");
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                String _xblockexpression_1 = null;
                this.inEventReception = false;
                _xblockexpression_1 = "";
                _builder.append(_xblockexpression_1, "\t\t\t");
                _builder.newLineIfNotEmpty();
                int _actionPrefixLength = this.getActionPrefixLength((List<Action>)fragment.getActions());
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _actionPrefixLength, true);
                for (Integer i : _doubleDotLessThan) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    CharSequence _generateAction = this.generateAction((Action)fragment.getActions().get(i.intValue()));
                    _builder.append((Object)_generateAction, "\t\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
                int _actionPrefixLength_1 = this.getActionPrefixLength((List<Action>)fragment.getActions());
                boolean bl4 = _equals = _actionPrefixLength_1 == (_size = fragment.getActions().size());
                if (_equals) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("stateOfDecisionClass.setState(\"");
                    String _name_3 = fragment.getTarget().getName();
                    _builder.append(_name_3, "\t\t\t");
                    _builder.append("\");");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("stateOfDecisionClass.setState(\"");
                    String _name_4 = s.getName();
                    _builder.append(_name_4, "\t\t\t");
                    _builder.append("_");
                    int _indexOf = s.getTraceFragments().indexOf((Object)fragment);
                    int _plus = _indexOf + 1;
                    _builder.append((Object)_plus, "\t\t\t");
                    _builder.append("_1\");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("result.states.add(stateOfDecisionClass);");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            } else {
                int _size_1;
                boolean _equals_1;
                int _actionPrefixLength_2 = this.getActionPrefixLength((List<Action>)fragment.getActions());
                ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, _actionPrefixLength_2, true);
                for (Integer i_1 : _doubleDotLessThan_1) {
                    _builder.append("\t");
                    _builder.append("\t");
                    CharSequence _generateAction_1 = this.generateAction((Action)fragment.getActions().get(i_1.intValue()));
                    _builder.append((Object)_generateAction_1, "\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
                int _actionPrefixLength_3 = this.getActionPrefixLength((List<Action>)fragment.getActions());
                boolean bl5 = _equals_1 = _actionPrefixLength_3 == (_size_1 = fragment.getActions().size());
                if (_equals_1) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("stateOfDecisionClass.setState(\"");
                    String _name_5 = fragment.getTarget().getName();
                    _builder.append(_name_5, "\t\t");
                    _builder.append("\");");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("stateOfDecisionClass.setState(\"");
                    String _name_6 = s.getName();
                    _builder.append(_name_6, "\t\t");
                    _builder.append("_");
                    int _indexOf_1 = s.getTraceFragments().indexOf((Object)fragment);
                    int _plus_1 = _indexOf_1 + 1;
                    _builder.append((Object)_plus_1, "\t\t");
                    _builder.append("_1\");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("result.states.add(stateOfDecisionClass);");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence utilityClassImportPart() {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.Arrays;");
        _builder.newLine();
        _builder.append("import java.util.HashMap;");
        _builder.newLine();
        _builder.append("import java.util.Map;");
        _builder.newLine();
        _builder.append("import java.util.HashSet;");
        _builder.newLine();
        _builder.append("import java.util.Set;");
        _builder.newLine();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".CFunctionalConstraintState;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".CPathDescription;");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _utilityClassContent(StateBasedFunctionalConstraint fc, Component c) {
        boolean _not;
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _utilityClassImportPart = this.utilityClassImportPart();
        _builder.append((Object)_utilityClassImportPart);
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".values.*;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public class ");
        String _utilityClassName = FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName);
        _builder.append(" extends CFunctionalConstraintState {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("/* current state */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private String state;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* variables */");
        _builder.newLine();
        EList _vars = fc.getVars();
        for (Variable v : _vars) {
            _builder.append("\t");
            _builder.append("private ");
            CharSequence _javaType = this.toJavaType((EObject)v.getType());
            _builder.append((Object)_javaType, "\t");
            _builder.append(" ");
            _builder.append("commaVar_", "\t");
            String _name = v.getName();
            _builder.append(_name, "\t");
            _builder.append(" = ");
            CharSequence _defaultValue = this.defaultValue((EObject)v.getType());
            _builder.append((Object)_defaultValue, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* getter and setter for current state */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public String getState() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return state;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setState(String s) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("state = s;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* getters and setters for global variables */");
        _builder.newLine();
        EList _vars_1 = fc.getVars();
        for (Variable v_1 : _vars_1) {
            _builder.append("\t");
            _builder.append("public ");
            CharSequence _javaType_1 = this.toJavaType((EObject)v_1.getType());
            _builder.append((Object)_javaType_1, "\t");
            _builder.append(" get_");
            _builder.append("commaVar_", "\t");
            String _name_1 = v_1.getName();
            _builder.append(_name_1, "\t");
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return ");
            _builder.append("commaVar_", "\t\t");
            String _name_2 = v_1.getName();
            _builder.append(_name_2, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public void set_");
            _builder.append("commaVar_", "\t");
            String _name_3 = v_1.getName();
            _builder.append(_name_3, "\t");
            _builder.append("(Object i) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("commaVar_", "\t\t");
            String _name_4 = v_1.getName();
            _builder.append(_name_4, "\t\t");
            _builder.append(" = (");
            CharSequence _javaType_2 = this.toJavaType((EObject)v_1.getType());
            _builder.append((Object)_javaType_2, "\t\t");
            _builder.append(") i;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
        }
        int _size = this.quantifiersInMachines.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("\t");
            _builder.append("/* methods that implement quantifiers */");
            _builder.newLine();
            for (ExpressionQuantifier quantifier : this.quantifiersInMachines) {
                _builder.append("\t");
                CharSequence _generateQuantifierMethod = this.generateQuantifierMethod(quantifier, this.quantifiersInMachines.indexOf(quantifier));
                _builder.append((Object)_generateQuantifierMethod, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("public ");
        String _utilityClassName_1 = FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName_1, "\t");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("/* initialization of current state */");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("state = \"");
        String _name_5 = ComponentUtilities.getInitialState((StateBasedFunctionalConstraint)fc).getName();
        _builder.append(_name_5, "\t\t");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = fc.getInitActions().isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            _builder.append("\t\t");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("/* initialization of variables in init section */");
            _builder.newLine();
            EList _initActions = fc.getInitActions();
            for (Action a : _initActions) {
                _builder.append("\t\t");
                CharSequence _generateAction = this.generateAction(a);
                _builder.append((Object)_generateAction, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/* initialization of initial port states */");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("initialPortStates = new HashMap<String, Set<String>>();");
        _builder.newLine();
        EList _ports = c.getPorts();
        for (Port p : _ports) {
            _builder.append("\t\t");
            _builder.append("initialPortStates.put(\"");
            String _name_6 = p.getName();
            _builder.append(_name_6, "\t\t");
            _builder.append("\", new HashSet<>(Arrays.asList(");
            Iterable<State> _initialStatesForPort = this.initialStatesForPort(p);
            boolean _hasElements = false;
            for (State s : _initialStatesForPort) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t\t");
                }
                _builder.append("\"");
                String _name_7 = s.getName();
                _builder.append(_name_7, "\t\t");
                _builder.append("\"");
            }
            _builder.append(")));");
            _builder.newLineIfNotEmpty();
        }
        EList _connections = c.getConnections();
        for (Connection connection : _connections) {
            if (connection.getFirstEnd().getPart() == null || connection.getSecondEnd().getPart() == null) continue;
            _builder.append("\t\t");
            _builder.append("initialPortStates.put(\"");
            String _name_8 = connection.getFirstEnd().getPart().getName();
            _builder.append(_name_8, "\t\t");
            _builder.append(".");
            String _name_9 = connection.getFirstEnd().getPort().getName();
            _builder.append(_name_9, "\t\t");
            _builder.append("\", new HashSet<>(Arrays.asList(");
            Iterable<State> _initialStatesForPort_1 = this.initialStatesForPort(connection.getFirstEnd().getPort());
            boolean _hasElements_1 = false;
            for (State s_1 : _initialStatesForPort_1) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t\t");
                }
                _builder.append("\"");
                String _name_10 = s_1.getName();
                _builder.append(_name_10, "\t\t");
                _builder.append("\"");
            }
            _builder.append(")));");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("initialPortStates.put(\"");
            String _name_11 = connection.getSecondEnd().getPart().getName();
            _builder.append(_name_11, "\t\t");
            _builder.append(".");
            String _name_12 = connection.getSecondEnd().getPort().getName();
            _builder.append(_name_12, "\t\t");
            _builder.append("\", new HashSet<>(Arrays.asList(");
            Iterable<State> _initialStatesForPort_2 = this.initialStatesForPort(connection.getSecondEnd().getPort());
            boolean _hasElements_2 = false;
            for (State s_2 : _initialStatesForPort_2) {
                if (!_hasElements_2) {
                    _hasElements_2 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t\t");
                }
                _builder.append("\"");
                String _name_13 = s_2.getName();
                _builder.append(_name_13, "\t\t");
                _builder.append("\"");
            }
            _builder.append(")));");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _utilityClassContent(PredicateFunctionalConstraint fc, Component c) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _utilityClassImportPart = this.utilityClassImportPart();
        _builder.append((Object)_utilityClassImportPart);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public class ");
        String _utilityClassName = FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName);
        _builder.append(" extends CFunctionalConstraintState {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        int _size = this.quantifiersInMachines.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("\t");
            _builder.append("/* methods that implement quantifiers */");
            _builder.newLine();
            for (ExpressionQuantifier quantifier : this.quantifiersInMachines) {
                _builder.append("\t");
                CharSequence _generateQuantifierMethod = this.generateQuantifierMethod(quantifier, this.quantifiersInMachines.indexOf(quantifier));
                _builder.append((Object)_generateQuantifierMethod, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("public ");
        String _utilityClassName_1 = FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName_1, "\t");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("/* initialization of initial port states */");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("initialPortStates = new HashMap<String, Set<String>>();");
        _builder.newLine();
        EList _ports = c.getPorts();
        for (Port p : _ports) {
            _builder.append("\t\t");
            _builder.append("initialPortStates.put(\"");
            String _name = p.getName();
            _builder.append(_name, "\t\t");
            _builder.append("\", new HashSet<>(Arrays.asList(");
            Iterable<State> _initialStatesForPort = this.initialStatesForPort(p);
            boolean _hasElements = false;
            for (State s : _initialStatesForPort) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t\t");
                }
                _builder.append("\"");
                String _name_1 = s.getName();
                _builder.append(_name_1, "\t\t");
                _builder.append("\"");
            }
            _builder.append(")));");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        HashSet<String> visitedPorts = new HashSet<String>();
        _builder.newLineIfNotEmpty();
        EList _connections = c.getConnections();
        for (Connection connection : _connections) {
            boolean _contains_1;
            boolean _not_1;
            boolean _not;
            if (connection.getFirstEnd().getPart() == null || connection.getSecondEnd().getPart() == null) continue;
            _builder.append("\t\t");
            String _name_2 = connection.getFirstEnd().getPart().getName();
            String _plus = String.valueOf(_name_2) + ".";
            String _name_3 = connection.getFirstEnd().getPort().getName();
            String first = String.valueOf(_plus) + _name_3;
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            String _name_4 = connection.getSecondEnd().getPart().getName();
            String _plus_1 = String.valueOf(_name_4) + ".";
            String _name_5 = connection.getSecondEnd().getPort().getName();
            String second = String.valueOf(_plus_1) + _name_5;
            _builder.newLineIfNotEmpty();
            boolean _contains = visitedPorts.contains(first);
            boolean bl2 = _not = !_contains;
            if (_not) {
                _builder.append("\t\t");
                _builder.append("initialPortStates.put(\"");
                _builder.append(first, "\t\t");
                _builder.append("\", new HashSet<>(Arrays.asList(");
                Iterable<State> _initialStatesForPort_1 = this.initialStatesForPort(connection.getFirstEnd().getPort());
                boolean _hasElements_1 = false;
                for (State s_1 : _initialStatesForPort_1) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t\t");
                    }
                    _builder.append("\"");
                    String _name_6 = s_1.getName();
                    _builder.append(_name_6, "\t\t");
                    _builder.append("\"");
                }
                _builder.append(")));");
                _builder.newLineIfNotEmpty();
            }
            boolean bl3 = _not_1 = !(_contains_1 = visitedPorts.contains(second));
            if (_not_1) {
                _builder.append("\t\t");
                _builder.append("initialPortStates.put(\"");
                _builder.append(second, "\t\t");
                _builder.append("\", new HashSet<>(Arrays.asList(");
                Iterable<State> _initialStatesForPort_2 = this.initialStatesForPort(connection.getSecondEnd().getPort());
                boolean _hasElements_2 = false;
                for (State s_2 : _initialStatesForPort_2) {
                    if (!_hasElements_2) {
                        _hasElements_2 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t\t");
                    }
                    _builder.append("\"");
                    String _name_7 = s_2.getName();
                    _builder.append(_name_7, "\t\t");
                    _builder.append("\"");
                }
                _builder.append(")));");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t\t");
            String _xblockexpression = null;
            visitedPorts.add(first);
            visitedPorts.add(second);
            _xblockexpression = "";
            _builder.append(_xblockexpression, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static String utilityClassName(Component c, FunctionalConstraint fc) {
        String _string = CommaUtilities.getFullyQualifiedName((NamedElement)c).toString("_");
        String _name = fc.getName();
        String _plus = String.valueOf(_string) + _name;
        return String.valueOf(_plus) + "State";
    }

    public static String constraintClassName(Component c, FunctionalConstraint fc) {
        String _string = CommaUtilities.getFullyQualifiedName((NamedElement)c).toString("_");
        String _name = fc.getName();
        String _plus = String.valueOf(_string) + _name;
        return String.valueOf(_plus) + "FunctionalConstraint";
    }

    public Iterable<State> initialStatesForPort(final Port port) {
        Functions.Function1<Interface, Boolean> _function = new Functions.Function1<Interface, Boolean>(){

            public Boolean apply(Interface it) {
                return it.getName().equals(port.getInterface().getName());
            }
        };
        Functions.Function1<StateMachine, Iterable<State>> _function_1 = new Functions.Function1<StateMachine, Iterable<State>>(){

            public Iterable<State> apply(StateMachine it) {
                Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

                    public Boolean apply(State it) {
                        return it.isInitial();
                    }
                };
                return IterableExtensions.filter((Iterable)it.getStates(), (Functions.Function1)_function);
            }
        };
        return Iterables.concat((Iterable)ListExtensions.map((List)((Interface)IterableExtensions.findFirst(this.interfaces, (Functions.Function1)_function)).getMachines(), (Functions.Function1)_function_1));
    }

    public ArrayList<String> getStateNames(StateBasedFunctionalConstraint fc) {
        ArrayList<String> _xblockexpression = null;
        ArrayList<String> result = new ArrayList<String>();
        EList _states = fc.getStates();
        for (State s : _states) {
            EList fragments = ((ConstraintState)s).getTraceFragments();
            result.add(s.getName());
            for (TraceFragment fragment : fragments) {
                Functions.Function1<Action, Boolean> _function = new Functions.Function1<Action, Boolean>(){

                    public Boolean apply(Action it) {
                        return it instanceof EventReception;
                    }
                };
                List eventReceptions = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)fragment.getActions(), (Functions.Function1)_function));
                for (Action event : eventReceptions) {
                    StringConcatenation _builder = new StringConcatenation();
                    String _name = s.getName();
                    _builder.append(_name);
                    _builder.append("_");
                    int _indexOf = fragments.indexOf((Object)fragment);
                    int _plus = _indexOf + 1;
                    _builder.append((Object)_plus);
                    _builder.append("_");
                    int _indexOf_1 = eventReceptions.indexOf(event);
                    int _plus_1 = _indexOf_1 + 1;
                    _builder.append((Object)_plus_1);
                    result.add(_builder.toString());
                }
            }
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public int getActionPrefixLength(List<Action> actions) {
        Functions.Function1<Action, Boolean> _function = new Functions.Function1<Action, Boolean>(){

            public Boolean apply(Action it) {
                return it instanceof EventReception;
            }
        };
        Action reception = (Action)IterableExtensions.findFirst(actions, (Functions.Function1)_function);
        if (reception != null) {
            return actions.indexOf(reception);
        }
        return actions.size();
    }

    public ArrayList<List<Action>> splitFragmentByAction(List<Action> actions) {
        ArrayList<List<Action>> _xblockexpression = null;
        ArrayList<List<Action>> result = new ArrayList<List<Action>>();
        ArrayList<Action> fragment = null;
        boolean skipAction = true;
        for (Action action : actions) {
            if (action instanceof EventReception) {
                ArrayList<Action> _arrayList;
                skipAction = false;
                fragment = _arrayList = new ArrayList<Action>();
                fragment.add(action);
                result.add(fragment);
                continue;
            }
            if (skipAction) continue;
            fragment.add(action);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    @Override
    public boolean isVariableScope(EObject o) {
        return o instanceof ConstraintState || super.isVariableScope(o);
    }

    protected CharSequence _generateExpression(ExpressionInterfaceState expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(portsContext.portInState(\"");
        CharSequence _portName = this.portName((PortSelector)expr);
        _builder.append((Object)_portName);
        _builder.append("\", \"");
        String _name = expr.getState().getName();
        _builder.append(_name);
        _builder.append("\", ");
        if (this.inEventReception) {
            _builder.append(this.eventReceptionPort);
            _builder.append(", ");
            _builder.append(this.eventReceptionConnection);
        } else {
            _builder.append("null, null");
        }
        _builder.append("))");
        return _builder;
    }

    public CharSequence portName(PortSelector s) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        ComponentPart _part = s.getPart();
        boolean bl = _tripleNotEquals = _part != null;
        if (_tripleNotEquals) {
            String _name = s.getPart().getName();
            _builder.append(_name);
            _builder.append(".");
        }
        String _name_1 = s.getPort().getName();
        _builder.append(_name_1);
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionConnectionState expr) {
        boolean _tripleNotEquals;
        StringConcatenation _xifexpression = null;
        ExpressionVariable _idVar = expr.getIdVar();
        boolean bl = _tripleNotEquals = _idVar != null;
        if (_tripleNotEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("(portsContext.connectionAtPortInState(stateOfDecisionClass.get_");
            _builder.append("commaVar_");
            String _name = expr.getIdVar().getVariable().getName();
            _builder.append(_name);
            _builder.append("(), \"");
            CharSequence _portName = this.portName((PortSelector)expr);
            _builder.append((Object)_portName);
            _builder.append("\", new HashSet<>(Arrays.asList(");
            EList _states = expr.getStates();
            boolean _hasElements = false;
            for (State s : _states) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                _builder.append("\"");
                String _name_1 = s.getName();
                _builder.append(_name_1);
                _builder.append("\"");
            }
            _builder.append(")), ");
            if (this.inEventReception) {
                _builder.append(this.eventReceptionPort);
                _builder.append(", ");
                _builder.append(this.eventReceptionConnection);
            } else {
                _builder.append("null, null");
            }
            _builder.append("))");
            _xifexpression = _builder;
        } else {
            boolean _tripleNotEquals_1;
            StringConcatenation _xifexpression_1 = null;
            Multiplicity _multiplicity = expr.getMultiplicity();
            boolean bl2 = _tripleNotEquals_1 = _multiplicity != null;
            if (_tripleNotEquals_1) {
                boolean _tripleNotEquals_2;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("(portsContext.someAtPortInState(\"");
                CharSequence _portName_1 = this.portName((PortSelector)expr);
                _builder_1.append((Object)_portName_1);
                _builder_1.append("\", new HashSet<>(Arrays.asList(");
                EList _states_1 = expr.getStates();
                boolean _hasElements_1 = false;
                for (State s_1 : _states_1) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder_1.appendImmediate((Object)", ", "");
                    }
                    _builder_1.append("\"");
                    String _name_2 = s_1.getName();
                    _builder_1.append(_name_2);
                    _builder_1.append("\"");
                }
                _builder_1.append(")), ");
                if (this.inEventReception) {
                    _builder_1.append(this.eventReceptionPort);
                    _builder_1.append(", ");
                    _builder_1.append(this.eventReceptionConnection);
                } else {
                    _builder_1.append("null, null");
                }
                _builder_1.append(", ");
                long _lower = expr.getMultiplicity().getLower();
                _builder_1.append((Object)_lower);
                _builder_1.append(", ");
                String _upperInf = expr.getMultiplicity().getUpperInf();
                boolean bl3 = _tripleNotEquals_2 = _upperInf != null;
                if (_tripleNotEquals_2) {
                    _builder_1.append("-1");
                } else {
                    long _upper = expr.getMultiplicity().getUpper();
                    _builder_1.append((Object)_upper);
                }
                _builder_1.append("))");
                _xifexpression_1 = _builder_1;
            } else {
                CONNECTION_QUANTIFIER _quantifier_2;
                boolean _equals_2;
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("(portsContext.");
                CONNECTION_QUANTIFIER _quantifier = expr.getQuantifier();
                boolean _equals = Objects.equal((Object)_quantifier, (Object)CONNECTION_QUANTIFIER.ALL);
                if (_equals) {
                    _builder_2.append("allAtPortInState");
                } else {
                    _builder_2.append("someAtPortInState");
                }
                _builder_2.append("(\"");
                CharSequence _portName_2 = this.portName((PortSelector)expr);
                _builder_2.append((Object)_portName_2);
                _builder_2.append("\", new HashSet<>(Arrays.asList(");
                EList _states_2 = expr.getStates();
                boolean _hasElements_2 = false;
                for (State s_2 : _states_2) {
                    if (!_hasElements_2) {
                        _hasElements_2 = true;
                    } else {
                        _builder_2.appendImmediate((Object)", ", "");
                    }
                    _builder_2.append("\"");
                    String _name_3 = s_2.getName();
                    _builder_2.append(_name_3);
                    _builder_2.append("\"");
                }
                _builder_2.append(")), ");
                if (this.inEventReception) {
                    _builder_2.append(this.eventReceptionPort);
                    _builder_2.append(", ");
                    _builder_2.append(this.eventReceptionConnection);
                } else {
                    _builder_2.append("null, null");
                }
                CONNECTION_QUANTIFIER _quantifier_1 = expr.getQuantifier();
                boolean _equals_1 = Objects.equal((Object)_quantifier_1, (Object)CONNECTION_QUANTIFIER.ONE);
                if (_equals_1) {
                    _builder_2.append(", 1, 1");
                }
                if (_equals_2 = Objects.equal((Object)(_quantifier_2 = expr.getQuantifier()), (Object)CONNECTION_QUANTIFIER.SOME)) {
                    _builder_2.append(", 1, -1");
                }
                _builder_2.append("))");
                _xifexpression_1 = _builder_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public CharSequence constraintClassContent(FunctionalConstraint fc, Component c) {
        if (fc instanceof PredicateFunctionalConstraint) {
            return this._constraintClassContent((PredicateFunctionalConstraint)fc, c);
        }
        if (fc instanceof StateBasedFunctionalConstraint) {
            return this._constraintClassContent((StateBasedFunctionalConstraint)fc, c);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(fc, c).toString());
    }

    public CharSequence utilityClassContent(FunctionalConstraint fc, Component c) {
        if (fc instanceof PredicateFunctionalConstraint) {
            return this._utilityClassContent((PredicateFunctionalConstraint)fc, c);
        }
        if (fc instanceof StateBasedFunctionalConstraint) {
            return this._utilityClassContent((StateBasedFunctionalConstraint)fc, c);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(fc, c).toString());
    }

    @Override
    public CharSequence generateExpression(Expression expr) {
        if (expr instanceof ExpressionAddition) {
            return this._generateExpression((ExpressionAddition)expr);
        }
        if (expr instanceof ExpressionAnd) {
            return this._generateExpression((ExpressionAnd)expr);
        }
        if (expr instanceof ExpressionBracket) {
            return this._generateExpression((ExpressionBracket)expr);
        }
        if (expr instanceof ExpressionDivision) {
            return this._generateExpression((ExpressionDivision)expr);
        }
        if (expr instanceof ExpressionEqual) {
            return this._generateExpression((ExpressionEqual)expr);
        }
        if (expr instanceof ExpressionGeq) {
            return this._generateExpression((ExpressionGeq)expr);
        }
        if (expr instanceof ExpressionGreater) {
            return this._generateExpression((ExpressionGreater)expr);
        }
        if (expr instanceof ExpressionLeq) {
            return this._generateExpression((ExpressionLeq)expr);
        }
        if (expr instanceof ExpressionLess) {
            return this._generateExpression((ExpressionLess)expr);
        }
        if (expr instanceof ExpressionMaximum) {
            return this._generateExpression((ExpressionMaximum)expr);
        }
        if (expr instanceof ExpressionMinimum) {
            return this._generateExpression((ExpressionMinimum)expr);
        }
        if (expr instanceof ExpressionMinus) {
            return this._generateExpression((ExpressionMinus)expr);
        }
        if (expr instanceof ExpressionModulo) {
            return this._generateExpression((ExpressionModulo)expr);
        }
        if (expr instanceof ExpressionMultiply) {
            return this._generateExpression((ExpressionMultiply)expr);
        }
        if (expr instanceof ExpressionNEqual) {
            return this._generateExpression((ExpressionNEqual)expr);
        }
        if (expr instanceof ExpressionNot) {
            return this._generateExpression((ExpressionNot)expr);
        }
        if (expr instanceof ExpressionOr) {
            return this._generateExpression((ExpressionOr)expr);
        }
        if (expr instanceof ExpressionPlus) {
            return this._generateExpression((ExpressionPlus)expr);
        }
        if (expr instanceof ExpressionPower) {
            return this._generateExpression((ExpressionPower)expr);
        }
        if (expr instanceof ExpressionSubtraction) {
            return this._generateExpression((ExpressionSubtraction)expr);
        }
        if (expr instanceof ExpressionConnectionState) {
            return this._generateExpression((ExpressionConnectionState)expr);
        }
        if (expr instanceof ExpressionInterfaceState) {
            return this._generateExpression((ExpressionInterfaceState)expr);
        }
        if (expr instanceof ExpressionAny) {
            return this._generateExpression((ExpressionAny)expr);
        }
        if (expr instanceof ExpressionBulkData) {
            return this._generateExpression((ExpressionBulkData)expr);
        }
        if (expr instanceof ExpressionConstantBool) {
            return this._generateExpression((ExpressionConstantBool)expr);
        }
        if (expr instanceof ExpressionConstantInt) {
            return this._generateExpression((ExpressionConstantInt)expr);
        }
        if (expr instanceof ExpressionConstantReal) {
            return this._generateExpression((ExpressionConstantReal)expr);
        }
        if (expr instanceof ExpressionConstantString) {
            return this._generateExpression((ExpressionConstantString)expr);
        }
        if (expr instanceof ExpressionEnumLiteral) {
            return this._generateExpression((ExpressionEnumLiteral)expr);
        }
        if (expr instanceof ExpressionFunctionCall) {
            return this._generateExpression((ExpressionFunctionCall)expr);
        }
        if (expr instanceof ExpressionMap) {
            return this._generateExpression((ExpressionMap)expr);
        }
        if (expr instanceof ExpressionMapRW) {
            return this._generateExpression((ExpressionMapRW)expr);
        }
        if (expr instanceof ExpressionQuantifier) {
            return this._generateExpression((ExpressionQuantifier)expr);
        }
        if (expr instanceof ExpressionRecord) {
            return this._generateExpression((ExpressionRecord)expr);
        }
        if (expr instanceof ExpressionRecordAccess) {
            return this._generateExpression((ExpressionRecordAccess)expr);
        }
        if (expr instanceof ExpressionVariable) {
            return this._generateExpression((ExpressionVariable)expr);
        }
        if (expr instanceof ExpressionVector) {
            return this._generateExpression((ExpressionVector)expr);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expr).toString());
    }
}

