/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.syntaxcoloring;

import com.google.inject.Singleton;
import java.util.regex.Pattern;
import org.eclipse.xtext.ide.editor.syntaxcoloring.AbstractAntlrTokenToAttributeIdMapper;

@Singleton
public class DefaultAntlrTokenToAttributeIdMapper
extends AbstractAntlrTokenToAttributeIdMapper {
    private static final Pattern QUOTED = Pattern.compile("(?:^'([^']*)'$)|(?:^\"([^\"]*)\")$", 8);
    private static final Pattern PUNCTUATION = Pattern.compile("\\p{Punct}*");

    @Override
    protected String calculateId(String tokenName, int tokenType) {
        if (tokenName == null) {
            return "default";
        }
        if (PUNCTUATION.matcher(tokenName).matches()) {
            return "punctuation";
        }
        if (QUOTED.matcher(tokenName).matches()) {
            return "keyword";
        }
        switch (tokenName) {
            case "RULE_STRING": {
                return "string";
            }
            case "RULE_INT": {
                return "number";
            }
            case "RULE_ML_COMMENT": 
            case "RULE_SL_COMMENT": {
                return "comment";
            }
        }
        return "default";
    }
}

