/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.persistence;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.naming.QualifiedName;

public class SerializationExtensions {
    public static <T extends ENamedElement> T readEcoreElement(ObjectInput in) throws IOException {
        URI uri = SerializationExtensions.readURI(in);
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(uri.trimFragment().toString());
        if (ePackage == null) {
            return null;
        }
        Resource eResource = ePackage.eResource();
        if (eResource == null) {
            return null;
        }
        return (T)((ENamedElement)eResource.getEObject(uri.fragment()));
    }

    public static void writeEcoreElement(ObjectOutput out, ENamedElement namedElement) throws IOException {
        SerializationExtensions.writeURI(out, EcoreUtil.getURI((EObject)namedElement));
    }

    public static <T> T readCastedObject(ObjectInput in) throws IOException {
        try {
            return (T)in.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static URI readURI(ObjectInput in) throws IOException {
        String stringRep = in.readUTF();
        if ("NULL".equals(stringRep)) {
            return null;
        }
        return URI.createURI((String)stringRep);
    }

    public static void writeURI(ObjectOutput out, URI uri) throws IOException {
        if (uri == null) {
            out.writeUTF("NULL");
        } else {
            out.writeUTF(uri.toString());
        }
    }

    public static QualifiedName readQualifiedName(ObjectInput in) throws IOException {
        try {
            return QualifiedName.create((List)in.readObject());
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeQualifiedName(ObjectOutput out, QualifiedName name) throws IOException {
        out.writeObject(new ArrayList<String>(name.getSegments()));
    }
}

