/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.generator;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.comma.actions.actions.AnyEvent;
import org.eclipse.comma.actions.actions.CommandEvent;
import org.eclipse.comma.actions.actions.CommandReply;
import org.eclipse.comma.actions.actions.EVENT_KIND;
import org.eclipse.comma.actions.actions.EventPattern;
import org.eclipse.comma.actions.actions.NotificationEvent;
import org.eclipse.comma.actions.actions.ParameterizedEvent;
import org.eclipse.comma.actions.actions.SignalEvent;
import org.eclipse.comma.behavior.behavior.AbstractBehavior;
import org.eclipse.comma.behavior.behavior.BracketFormula;
import org.eclipse.comma.behavior.behavior.ConditionalFollow;
import org.eclipse.comma.behavior.behavior.ConditionedAbsenceOfEvent;
import org.eclipse.comma.behavior.behavior.ConditionedEvent;
import org.eclipse.comma.behavior.behavior.Conjunction;
import org.eclipse.comma.behavior.behavior.Connector;
import org.eclipse.comma.behavior.behavior.ConnectorOperator;
import org.eclipse.comma.behavior.behavior.ConstraintSequence;
import org.eclipse.comma.behavior.behavior.DataConstraint;
import org.eclipse.comma.behavior.behavior.DataConstraintEvent;
import org.eclipse.comma.behavior.behavior.DataConstraintStep;
import org.eclipse.comma.behavior.behavior.DataConstraintUntilOperator;
import org.eclipse.comma.behavior.behavior.DataConstraintsBlock;
import org.eclipse.comma.behavior.behavior.Disjunction;
import org.eclipse.comma.behavior.behavior.ESDisjunction;
import org.eclipse.comma.behavior.behavior.EventInState;
import org.eclipse.comma.behavior.behavior.EventInterval;
import org.eclipse.comma.behavior.behavior.EventSelector;
import org.eclipse.comma.behavior.behavior.FollowUpEvent;
import org.eclipse.comma.behavior.behavior.Formula;
import org.eclipse.comma.behavior.behavior.GenericConstraint;
import org.eclipse.comma.behavior.behavior.GenericConstraintsBlock;
import org.eclipse.comma.behavior.behavior.GroupTimeConstraint;
import org.eclipse.comma.behavior.behavior.Implication;
import org.eclipse.comma.behavior.behavior.NegationFormula;
import org.eclipse.comma.behavior.behavior.ObservedValue;
import org.eclipse.comma.behavior.behavior.PeriodicEvent;
import org.eclipse.comma.behavior.behavior.Sequence;
import org.eclipse.comma.behavior.behavior.SequenceElement;
import org.eclipse.comma.behavior.behavior.SingleTimeConstraint;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.TimeConstraint;
import org.eclipse.comma.behavior.behavior.TimeConstraintExpression;
import org.eclipse.comma.behavior.behavior.TimeConstraintsBlock;
import org.eclipse.comma.behavior.behavior.TimeInterval;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionQuantifier;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.monitoring.generator.AbstractBehaviorGenerator;
import org.eclipse.comma.monitoring.generator.TypesJavaGenerator;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.types.NamedElement;
import org.eclipse.comma.types.utilities.CommaUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public abstract class ConstraintsRulesGenerator
extends AbstractBehaviorGenerator {
    public static final String OBSERVED_VAR_PREFIX = "observed_";
    protected final AbstractBehavior behavior;
    protected final NamedElement rulesContainer;
    protected List<Expression> genericRulesConditions;
    protected final IFileSystemAccess fsa;

    public ConstraintsRulesGenerator(AbstractBehavior behavior, IFileSystemAccess fsa) {
        this.behavior = behavior;
        this.rulesContainer = (NamedElement)behavior;
        this.fsa = fsa;
    }

    public static CharSequence rulesClassName(NamedElement rulesContainer) {
        StringConcatenation _builder = new StringConcatenation();
        String _string = CommaUtilities.getFullyQualifiedName((NamedElement)rulesContainer).toString("_");
        _builder.append(_string);
        _builder.append("Rules");
        return _builder;
    }

    public CharSequence ruleClassName(NamedElement rulesContainer, NamedElement rule) {
        StringConcatenation _xblockexpression = null;
        String _switchResult = null;
        boolean _matched = false;
        if (rule instanceof TimeConstraint) {
            _matched = true;
            _switchResult = "TimeRule";
        }
        if (!_matched && rule instanceof DataConstraint) {
            _matched = true;
            _switchResult = "DataRule";
        }
        if (!_matched && rule instanceof GenericConstraint) {
            _matched = true;
            _switchResult = "Formula";
        }
        if (!_matched) {
            _switchResult = "TimeRule";
        }
        String ruleNameSuffix = _switchResult;
        StringConcatenation _builder = new StringConcatenation();
        String _string = CommaUtilities.getFullyQualifiedName((NamedElement)rulesContainer).toString("_");
        _builder.append(_string);
        String _name = rule.getName();
        _builder.append(_name);
        _builder.append(ruleNameSuffix);
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence constraintsClassProviderContent(AbstractBehavior intdef) {
        boolean _tripleNotEquals_3;
        GenericConstraintsBlock _genericConstraintsBlock;
        boolean _tripleNotEquals_2;
        DataConstraintsBlock _dataConstraintsBlock;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.ArrayList;");
        _builder.newLine();
        _builder.append("import java.util.List;\t\t");
        _builder.newLine();
        boolean _containsPrecondition = this.containsPrecondition(intdef);
        if (_containsPrecondition) {
            _builder.append("import java.util.function.Function;");
            _builder.newLine();
            _builder.append("import java.io.Serializable;");
            _builder.newLine();
            _builder.append("import ");
            _builder.append(TypesJavaGenerator.rootPackage);
            _builder.append(".CState;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".constraints.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".messages.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".values.*;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public class ");
        CharSequence _rulesClassName = ConstraintsRulesGenerator.rulesClassName((NamedElement)intdef);
        _builder.append((Object)_rulesClassName);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private List<CRule> rules;");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _constraintsClassVariables = this.constraintsClassVariables();
        _builder.append((Object)_constraintsClassVariables, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public ");
        CharSequence _rulesClassName_1 = ConstraintsRulesGenerator.rulesClassName((NamedElement)intdef);
        _builder.append((Object)_rulesClassName_1, "\t");
        _builder.append("(");
        CharSequence _constraintsClassConstructorParams = this.constraintsClassConstructorParams();
        _builder.append((Object)_constraintsClassConstructorParams, "\t");
        _builder.append("){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t    ");
        CharSequence _constraintsClassVariablesInit = this.constraintsClassVariablesInit();
        _builder.append((Object)_constraintsClassVariablesInit, "\t    ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("rules = new ArrayList<CRule>();");
        _builder.newLine();
        TimeConstraintsBlock _timeConstraintsBlock = intdef.getTimeConstraintsBlock();
        boolean bl = _tripleNotEquals = _timeConstraintsBlock != null;
        if (_tripleNotEquals) {
            EList _timeConstraints = intdef.getTimeConstraintsBlock().getTimeConstraints();
            for (TimeConstraint r : _timeConstraints) {
                if (r instanceof SingleTimeConstraint) {
                    _builder.append("\t\t");
                    _builder.append("rules.add(getTimeRule_");
                    String _name = ((SingleTimeConstraint)r).getName();
                    _builder.append(_name, "\t\t");
                    _builder.append("());");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("\t\t");
                _builder.append("rules.add(new ");
                CharSequence _ruleClassName = this.ruleClassName((NamedElement)intdef, (NamedElement)r);
                _builder.append((Object)_ruleClassName, "\t\t");
                _builder.append("(");
                CharSequence _constraintsClassConstructorCallParams = this.constraintsClassConstructorCallParams();
                _builder.append((Object)_constraintsClassConstructorCallParams, "\t\t");
                _builder.append("));");
                _builder.newLineIfNotEmpty();
            }
        }
        boolean bl2 = _tripleNotEquals_1 = (_dataConstraintsBlock = intdef.getDataConstraintsBlock()) != null;
        if (_tripleNotEquals_1) {
            EList _dataConstraints = intdef.getDataConstraintsBlock().getDataConstraints();
            for (DataConstraint r_1 : _dataConstraints) {
                _builder.append("\t\t");
                _builder.append("rules.add(new ");
                CharSequence _ruleClassName_1 = this.ruleClassName((NamedElement)intdef, (NamedElement)r_1);
                _builder.append((Object)_ruleClassName_1, "\t\t");
                _builder.append("(");
                CharSequence _constraintsClassConstructorCallParams_1 = this.constraintsClassConstructorCallParams();
                _builder.append((Object)_constraintsClassConstructorCallParams_1, "\t\t");
                _builder.append("));");
                _builder.newLineIfNotEmpty();
            }
        }
        boolean bl3 = _tripleNotEquals_2 = (_genericConstraintsBlock = intdef.getGenericConstraintsBlock()) != null;
        if (_tripleNotEquals_2) {
            EList _genericConstraints = intdef.getGenericConstraintsBlock().getGenericConstraints();
            for (GenericConstraint r_2 : _genericConstraints) {
                _builder.append("\t\t");
                _builder.append("rules.add(new ");
                CharSequence _ruleClassName_2 = this.ruleClassName((NamedElement)intdef, (NamedElement)r_2);
                _builder.append((Object)_ruleClassName_2, "\t\t");
                _builder.append("(");
                CharSequence _constraintsClassConstructorCallParams_2 = this.constraintsClassConstructorCallParams();
                _builder.append((Object)_constraintsClassConstructorCallParams_2, "\t\t");
                _builder.append("));");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public List<CRule> getRules(){");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return rules;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        TimeConstraintsBlock _timeConstraintsBlock_1 = intdef.getTimeConstraintsBlock();
        boolean bl4 = _tripleNotEquals_3 = _timeConstraintsBlock_1 != null;
        if (_tripleNotEquals_3) {
            EList _timeConstraints_1 = intdef.getTimeConstraintsBlock().getTimeConstraints();
            for (TimeConstraint r_3 : _timeConstraints_1) {
                if (!(r_3 instanceof SingleTimeConstraint)) continue;
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                CharSequence _singleTimeConstraintToJavaMethod = this.singleTimeConstraintToJavaMethod(((SingleTimeConstraint)r_3).getConstraint(), r_3);
                _builder.append((Object)_singleTimeConstraintToJavaMethod, "\t");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence constraintsClassVariables() {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    public CharSequence constraintsClassVariablesInit() {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    public CharSequence constraintsClassConstructorParams() {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    public CharSequence constraintsClassConstructorCallParams() {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    public CharSequence preconditionLambda(EventInState pattern) {
        StringConcatenation _builder = new StringConcatenation();
        Interface interface_ = (Interface)EcoreUtil2.getContainerOfType((EObject)pattern, Interface.class);
        _builder.newLineIfNotEmpty();
        _builder.append("(Function<CState, Boolean> & Serializable) (env) -> {");
        CharSequence _utilityClassName = ConstraintsRulesGenerator.utilityClassName(interface_);
        _builder.append((Object)_utilityClassName);
        _builder.append(" stateOfDecisionClass = (");
        CharSequence _utilityClassName_1 = ConstraintsRulesGenerator.utilityClassName(interface_);
        _builder.append((Object)_utilityClassName_1);
        _builder.append(") env; return ");
        CharSequence _generateExpression = this.generateExpression(pattern.getPreCondition());
        _builder.append((Object)_generateExpression);
        _builder.append("; }");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence messagePattern(EventInState pattern, String patternVarName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("CMessagePattern ");
        _builder.append(patternVarName);
        _builder.append(" = ");
        CharSequence _generateEvent = this.generateEvent(pattern.getEvent());
        _builder.append((Object)_generateEvent);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _singleTimeConstraintToJavaMethod(EventInterval r, TimeConstraint rule) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private CRule getTimeRule_");
        String _name = rule.getName();
        _builder.append(_name);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        CharSequence _messagePattern = this.messagePattern(r.getCondition(), "firstEvent");
        _builder.append((Object)_messagePattern, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        CharSequence _messagePattern_1 = this.messagePattern(r.getEvent(), "secondEvent");
        _builder.append((Object)_messagePattern_1, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("CEventIntervalTimeRule rule = new CEventIntervalTimeRule(firstEvent, secondEvent);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("rule.setName(\"");
        String _name_1 = rule.getName();
        _builder.append(_name_1, "\t");
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("rule.getEnvironment().setInterval(");
        CharSequence _interval = this.interval(r.getInterval());
        _builder.append((Object)_interval, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return rule;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _singleTimeConstraintToJavaMethod(ConditionedAbsenceOfEvent r, TimeConstraint rule) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private CRule getTimeRule_");
        String _name = rule.getName();
        _builder.append(_name);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        CharSequence _messagePattern = this.messagePattern(r.getCondition(), "triggeringEvent");
        _builder.append((Object)_messagePattern, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        CharSequence _messagePattern_1 = this.messagePattern(r.getEvent(), "missingEvent");
        _builder.append((Object)_messagePattern_1, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("CConditionedAbsenceOfEventTimeRule rule = new CConditionedAbsenceOfEventTimeRule(triggeringEvent, missingEvent);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("rule.setName(\"");
        String _name_1 = rule.getName();
        _builder.append(_name_1, "\t");
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("rule.getEnvironment().setInterval(");
        CharSequence _interval = this.interval(r.getInterval());
        _builder.append((Object)_interval, "\t");
        _builder.append(").setIntervalEnd(");
        Expression _end = r.getInterval().getEnd();
        boolean bl = _tripleNotEquals = _end != null;
        if (_tripleNotEquals) {
            CharSequence _generateExpression = this.generateExpression(r.getInterval().getEnd());
            _builder.append((Object)_generateExpression, "\t");
        } else {
            _builder.append("-1");
        }
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return rule;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _singleTimeConstraintToJavaMethod(ConditionedEvent r, TimeConstraint rule) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private CRule getTimeRule_");
        String _name = rule.getName();
        _builder.append(_name);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        CharSequence _messagePattern = this.messagePattern(r.getCondition(), "trigger");
        _builder.append((Object)_messagePattern, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        CharSequence _messagePattern_1 = this.messagePattern(r.getEvent(), "expected");
        _builder.append((Object)_messagePattern_1, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("CConditionedEventTimeRule rule = new CConditionedEventTimeRule(trigger, expected);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("rule.setName(\"");
        String _name_1 = rule.getName();
        _builder.append(_name_1, "\t");
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("rule.getEnvironment().setInterval(");
        CharSequence _interval = this.interval(r.getInterval());
        _builder.append((Object)_interval, "\t");
        _builder.append(").setIntervalEnd(");
        Expression _end = r.getInterval().getEnd();
        boolean bl = _tripleNotEquals = _end != null;
        if (_tripleNotEquals) {
            CharSequence _generateExpression = this.generateExpression(r.getInterval().getEnd());
            _builder.append((Object)_generateExpression, "\t");
        } else {
            _builder.append("-1");
        }
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return rule;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _singleTimeConstraintToJavaMethod(PeriodicEvent r, TimeConstraint rule) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private CRule getTimeRule_");
        String _name = rule.getName();
        _builder.append(_name);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        CharSequence _messagePattern = this.messagePattern(r.getCondition(), "trigger");
        _builder.append((Object)_messagePattern, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("CMessagePattern periodic = ");
        CharSequence _generateEvent = this.generateEvent(r.getEvent());
        _builder.append((Object)_generateEvent, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        EventInState _stopEvent = r.getStopEvent();
        boolean bl = _tripleNotEquals = _stopEvent != null;
        if (_tripleNotEquals) {
            _builder.append("\t\t\t    ");
            CharSequence _messagePattern_1 = this.messagePattern(r.getStopEvent(), "stopPattern");
            _builder.append((Object)_messagePattern_1, "\t\t\t    ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("CEventSelector stop = new CEventSelector().setEvent(stopPattern);");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("CEventSelector stop = new CEventSelector().setEvent(new CMessagePattern()).setNegated();");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("CPeriodicTimeRule rule = new CPeriodicTimeRule(trigger, periodic, stop);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("rule.setName(\"");
        String _name_1 = rule.getName();
        _builder.append(_name_1, "\t");
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("rule.getEnvironment().setVariableValue(\"period\", ");
        CharSequence _generateExpression = this.generateExpression(r.getPeriod());
        _builder.append((Object)_generateExpression, "\t");
        _builder.append(").setVariableValue(\"jitter\", ");
        CharSequence _generateExpression_1 = this.generateExpression(r.getJitter());
        _builder.append((Object)_generateExpression_1, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return rule;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence dataRulesEnvironmentClassContent() {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".messages.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".values.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import java.util.HashMap;");
        _builder.newLine();
        _builder.append("import java.util.Map;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public class ");
        String _string = CommaUtilities.getFullyQualifiedName((NamedElement)this.rulesContainer).toString("_");
        _builder.append(_string);
        _builder.append("DataRulesEnvironment extends CEnvironment {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private double t;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private Map<String, Boolean> conditionsCheck = new HashMap<String, Boolean>();");
        _builder.newLine();
        EList _vars = this.behavior.getDataConstraintsBlock().getVars();
        for (Variable v : _vars) {
            _builder.append("\t");
            _builder.append("private ");
            CharSequence _javaType = this.toJavaType((EObject)v.getType());
            _builder.append((Object)_javaType, "\t");
            _builder.append(" ");
            _builder.append("commaVar_", "\t");
            String _name = v.getName();
            _builder.append(_name, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public CEnvironment setVariableValue(String name, Object value) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (name.equals(\"t\")){t = (double) value;}");
        _builder.newLine();
        EList _vars_1 = this.behavior.getDataConstraintsBlock().getVars();
        for (Variable v_1 : _vars_1) {
            _builder.append("\t\t");
            _builder.append("if(name.equals(\"");
            String _name_1 = v_1.getName();
            _builder.append(_name_1, "\t\t");
            _builder.append("\")) {");
            _builder.append("commaVar_", "\t\t");
            String _name_2 = v_1.getName();
            _builder.append(_name_2, "\t\t");
            _builder.append(" = (");
            CharSequence _javaType_1 = this.toJavaType((EObject)v_1.getType());
            _builder.append((Object)_javaType_1, "\t\t");
            _builder.append(") value;}");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("return this;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        int _size = this.quantifiersInMachines.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            for (ExpressionQuantifier quantifier : this.quantifiersInMachines) {
                _builder.append("\t");
                CharSequence _generateQuantifierMethod = this.generateQuantifierMethod(quantifier, this.quantifiersInMachines.indexOf(quantifier));
                _builder.append((Object)_generateQuantifierMethod, "\t");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public boolean checkCondition(int index, CObservedMessage message) {");
        _builder.newLine();
        int _size_1 = this.behavior.getDataConstraintsBlock().getDataConstraints().size();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size_1, true);
        for (Integer i : _doubleDotLessThan) {
            _builder.append("\t\t");
            _builder.append("if(index == ");
            _builder.append((Object)(i + 1), "\t\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("    ");
            _builder.append("conditionsCheck.put(\"");
            String _name_3 = ((DataConstraint)this.behavior.getDataConstraintsBlock().getDataConstraints().get(i.intValue())).getName();
            _builder.append(_name_3, "\t\t    ");
            _builder.append("\", true);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("    ");
            _builder.append("return ");
            CharSequence _generateExpression = this.generateExpression(((DataConstraint)this.behavior.getDataConstraintsBlock().getDataConstraints().get(i.intValue())).getCondition());
            _builder.append((Object)_generateExpression, "\t\t    ");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        EList _dataConstraints = this.behavior.getDataConstraintsBlock().getDataConstraints();
        for (DataConstraint rule : _dataConstraints) {
            boolean _not;
            boolean _isEmpty = rule.getObservedValues().isEmpty();
            boolean bl2 = _not = !_isEmpty;
            if (!_not) continue;
            _builder.append("\t");
            _builder.append("public Map<String, Object> observedValuesFor");
            String _name_4 = rule.getName();
            _builder.append(_name_4, "\t");
            _builder.append("(){");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("Map<String, Object> map = new HashMap<String, Object>();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if(!conditionsCheck.containsKey(\"");
            String _name_5 = rule.getName();
            _builder.append(_name_5, "\t\t");
            _builder.append("\")){return map;}");
            _builder.newLineIfNotEmpty();
            EList _observedValues = rule.getObservedValues();
            for (ObservedValue observedValue : _observedValues) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("map.put(\"");
                String _name_6 = rule.getName();
                _builder.append(_name_6, "\t\t");
                _builder.append("_");
                String _name_7 = observedValue.getName();
                _builder.append(_name_7, "\t\t");
                _builder.append("\", ");
                CharSequence _generateExpression_1 = this.generateExpression(observedValue.getValue());
                _builder.append((Object)_generateExpression_1, "\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return map;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence dataRuleClassContent(DataConstraint dr) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.Map;");
        _builder.newLine();
        boolean _containsPrecondition = this.containsPrecondition((EObject)dr);
        if (_containsPrecondition) {
            _builder.append("import java.util.function.Function;");
            _builder.newLine();
            _builder.append("import java.io.Serializable;");
            _builder.newLine();
            _builder.append("import ");
            _builder.append(TypesJavaGenerator.rootPackage);
            _builder.append(".CState;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".constraints.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".messages.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".values.*;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public class ");
        CharSequence _ruleClassName = this.ruleClassName(this.rulesContainer, (NamedElement)dr);
        _builder.append((Object)_ruleClassName);
        _builder.append(" extends CDataRule {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private ");
        String _string = CommaUtilities.getFullyQualifiedName((NamedElement)this.rulesContainer).toString("_");
        _builder.append(_string, "\t");
        _builder.append("DataRulesEnvironment env;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _constraintsClassVariables = this.constraintsClassVariables();
        _builder.append((Object)_constraintsClassVariables, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        CharSequence _ruleClassName_1 = this.ruleClassName(this.rulesContainer, (NamedElement)dr);
        _builder.append((Object)_ruleClassName_1, "\t");
        _builder.append("(");
        CharSequence _constraintsClassConstructorParams = this.constraintsClassConstructorParams();
        _builder.append((Object)_constraintsClassConstructorParams, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("name = \"");
        String _name = dr.getName();
        _builder.append(_name, "\t\t");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("errorMessage = \"Data constraint is violated.\"; ");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("env = new ");
        String _string_1 = CommaUtilities.getFullyQualifiedName((NamedElement)this.rulesContainer).toString("_");
        _builder.append(_string_1, "\t\t");
        _builder.append("DataRulesEnvironment();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _constraintsClassVariablesInit = this.constraintsClassVariablesInit();
        _builder.append((Object)_constraintsClassVariablesInit, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("formula = ");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("new CConstraintSequence().");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("setConditionIndex(");
        int _indexOf = this.behavior.getDataConstraintsBlock().getDataConstraints().indexOf((Object)dr);
        int _plus = _indexOf + 1;
        _builder.append((Object)_plus, "\t\t\t\t");
        _builder.append(").");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("setSequence(");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("new CSequence()");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        CharSequence _dataConstraintToJava = this.dataConstraintToJava(dr);
        _builder.append((Object)_dataConstraintToJava, "\t\t\t\t\t");
        _builder.append(".setEnvironment(env));");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public Map<String, Object> observedValues(){");
        _builder.newLine();
        boolean _isEmpty = dr.getObservedValues().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("\t\t");
            _builder.append("return env.observedValuesFor");
            String _name_1 = dr.getName();
            _builder.append(_name_1, "\t\t");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t\t");
            _builder.append("return null;");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence genericRulesEnvironmentClassContent() {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".messages.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".values.*;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append("public class ");
        String _string = CommaUtilities.getFullyQualifiedName((NamedElement)this.rulesContainer).toString("_");
        _builder.append(_string);
        _builder.append("GenericRulesEnvironment extends CEnvironment {");
        _builder.newLineIfNotEmpty();
        EList _vars = this.behavior.getGenericConstraintsBlock().getVars();
        for (Variable v : _vars) {
            _builder.append("\t");
            _builder.append("private ");
            CharSequence _javaType = this.toJavaType((EObject)v.getType());
            _builder.append((Object)_javaType, "\t");
            _builder.append(" ");
            _builder.append("commaVar_", "\t");
            String _name = v.getName();
            _builder.append(_name, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public CEnvironment setVariableValue(String name, Object value) {");
        _builder.newLine();
        EList _vars_1 = this.behavior.getGenericConstraintsBlock().getVars();
        for (Variable v_1 : _vars_1) {
            _builder.append("\t\t");
            _builder.append("if(name.equals(\"");
            String _name_1 = v_1.getName();
            _builder.append(_name_1, "\t\t");
            _builder.append("\")) {");
            _builder.append("commaVar_", "\t\t");
            String _name_2 = v_1.getName();
            _builder.append(_name_2, "\t\t");
            _builder.append(" = (");
            CharSequence _javaType_1 = this.toJavaType((EObject)v_1.getType());
            _builder.append((Object)_javaType_1, "\t\t");
            _builder.append(") value;}");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("return this;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        int _size = this.quantifiersInMachines.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            for (ExpressionQuantifier quantifier : this.quantifiersInMachines) {
                _builder.append("\t");
                CharSequence _generateQuantifierMethod = this.generateQuantifierMethod(quantifier, this.quantifiersInMachines.indexOf(quantifier));
                _builder.append((Object)_generateQuantifierMethod, "\t");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public boolean checkCondition(int index, CObservedMessage message) {");
        _builder.newLine();
        for (Expression condition : this.genericRulesConditions) {
            _builder.append("\t");
            _builder.append("if(index == ");
            int _indexOf = this.genericRulesConditions.indexOf(condition);
            int _plus = _indexOf + 1;
            _builder.append((Object)_plus, "\t");
            _builder.append(") {return ");
            CharSequence _generateExpression = this.generateExpression(condition);
            _builder.append((Object)_generateExpression, "\t");
            _builder.append(";}");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence genericRuleClassContent(GenericConstraint c) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _containsPrecondition = this.containsPrecondition((EObject)c);
        if (_containsPrecondition) {
            _builder.append("import java.util.function.Function;");
            _builder.newLine();
            _builder.append("import java.io.Serializable;");
            _builder.newLine();
            _builder.append("import ");
            _builder.append(TypesJavaGenerator.rootPackage);
            _builder.append(".CState;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".constraints.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".messages.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".values.*;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append("public class ");
        CharSequence _ruleClassName = this.ruleClassName(this.rulesContainer, (NamedElement)c);
        _builder.append((Object)_ruleClassName);
        _builder.append(" extends CGenericRule {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private ");
        String _string = CommaUtilities.getFullyQualifiedName((NamedElement)this.rulesContainer).toString("_");
        _builder.append(_string, "\t");
        _builder.append("GenericRulesEnvironment env;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _constraintsClassVariables = this.constraintsClassVariables();
        _builder.append((Object)_constraintsClassVariables, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        CharSequence _ruleClassName_1 = this.ruleClassName(this.rulesContainer, (NamedElement)c);
        _builder.append((Object)_ruleClassName_1, "\t");
        _builder.append("(");
        CharSequence _constraintsClassConstructorParams = this.constraintsClassConstructorParams();
        _builder.append((Object)_constraintsClassConstructorParams, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("name = \"");
        String _name = c.getName();
        _builder.append(_name, "\t\t");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("errorMessage = \"Generic constraint is violated.\"; ");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("env = new ");
        String _string_1 = CommaUtilities.getFullyQualifiedName((NamedElement)this.rulesContainer).toString("_");
        _builder.append(_string_1, "\t\t");
        _builder.append("GenericRulesEnvironment();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _constraintsClassVariablesInit = this.constraintsClassVariablesInit();
        _builder.append((Object)_constraintsClassVariablesInit, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("formula = ");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        CharSequence _formulaToJava = this.formulaToJava(c.getFormula(), this.genericRulesConditions);
        _builder.append((Object)_formulaToJava, "\t\t\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _groupTimeConstraintEnvironmentClassContent(ConditionedEvent first, GroupTimeConstraint tc) {
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".messages.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".values.*;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public class ");
        String _string = CommaUtilities.getFullyQualifiedName((NamedElement)this.rulesContainer).toString("_");
        _builder.append(_string);
        String _name = tc.getName();
        _builder.append(_name);
        _builder.append("TimeRuleEnvironment extends CEnvironment {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private double t, t1, t2, ");
        int _length = ((Object[])Conversions.unwrapArray((Object)tc.getFollowups(), Object.class)).length;
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _length, true);
        boolean _hasElements = false;
        for (Integer i : _doubleDotLessThan) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            _builder.append("t");
            _builder.append((Object)(3 + i), "\t");
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private CInterval i1, ");
        int _length_1 = ((Object[])Conversions.unwrapArray((Object)tc.getFollowups(), Object.class)).length;
        ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, _length_1, true);
        boolean _hasElements_1 = false;
        for (Integer i_1 : _doubleDotLessThan_1) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            _builder.append("i");
            _builder.append((Object)(2 + i_1), "\t");
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        String _string_1 = CommaUtilities.getFullyQualifiedName((NamedElement)this.rulesContainer).toString("_");
        _builder.append(_string_1, "\t");
        String _name_1 = tc.getName();
        _builder.append(_name_1, "\t");
        _builder.append("TimeRuleEnvironment() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("i1 = ");
        CharSequence _interval = this.interval(first.getInterval());
        _builder.append((Object)_interval, "\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        int _length_2 = ((Object[])Conversions.unwrapArray((Object)tc.getFollowups(), Object.class)).length;
        ExclusiveRange _doubleDotLessThan_2 = new ExclusiveRange(0, _length_2, true);
        for (Integer i_2 : _doubleDotLessThan_2) {
            _builder.append("\t\t");
            _builder.append("i");
            _builder.append((Object)(2 + i_2), "\t\t");
            _builder.append(" = ");
            CharSequence _interval_1 = this.interval(((FollowUpEvent)tc.getFollowups().get(i_2.intValue())).getInterval());
            _builder.append((Object)_interval_1, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public CEnvironment\tsetVariableValue(String name, Object value) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(name.equals(\"t\")) {t = (double) value;}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(name.equals(\"t1\")) {t1 = (double) value;}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(name.equals(\"t2\")) {t2 = (double) value;}");
        _builder.newLine();
        int _length_3 = ((Object[])Conversions.unwrapArray((Object)tc.getFollowups(), Object.class)).length;
        ExclusiveRange _doubleDotLessThan_3 = new ExclusiveRange(0, _length_3, true);
        for (Integer i_3 : _doubleDotLessThan_3) {
            _builder.append("\t\t");
            _builder.append("if(name.equals(\"t");
            _builder.append((Object)(3 + i_3), "\t\t");
            _builder.append("\")) {t");
            _builder.append((Object)(3 + i_3), "\t\t");
            _builder.append(" = (double) value;}");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return this;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public boolean checkCondition(int index, CObservedMessage message) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(index == 1) {return ");
        Expression _end = first.getInterval().getEnd();
        boolean bl = _tripleEquals = _end == null;
        if (_tripleEquals) {
            _builder.append("true");
        } else {
            _builder.append("(t - t1) <= (");
            CharSequence _generateExpression = this.generateExpression(first.getInterval().getEnd());
            _builder.append((Object)_generateExpression, "\t\t");
            _builder.append(")");
        }
        _builder.append(";}");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("if(index == 2) {return i1.isIn(t2 - t1);}");
        _builder.newLine();
        int _length_4 = ((Object[])Conversions.unwrapArray((Object)tc.getFollowups(), Object.class)).length;
        ExclusiveRange _doubleDotLessThan_4 = new ExclusiveRange(0, _length_4, true);
        for (Integer i_4 : _doubleDotLessThan_4) {
            boolean _tripleEquals_1;
            _builder.append("\t\t");
            _builder.append("if(index == ");
            _builder.append((Object)(4 + (2 * i_4 - 1)), "\t\t");
            _builder.append(") {return ");
            Expression _end_1 = ((FollowUpEvent)tc.getFollowups().get(i_4.intValue())).getInterval().getEnd();
            boolean bl2 = _tripleEquals_1 = _end_1 == null;
            if (_tripleEquals_1) {
                _builder.append("true");
            } else {
                _builder.append("(t - t");
                _builder.append((Object)(3 + (i_4 - 1)), "\t\t");
                _builder.append(") <= (");
                CharSequence _generateExpression_1 = this.generateExpression(((FollowUpEvent)tc.getFollowups().get(i_4.intValue())).getInterval().getEnd());
                _builder.append((Object)_generateExpression_1, "\t\t");
                _builder.append(")");
            }
            _builder.append(";}");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("if(index == ");
            _builder.append((Object)(4 + 2 * i_4), "\t\t");
            _builder.append(") {return i");
            _builder.append((Object)(2 + i_4), "\t\t");
            _builder.append(".isIn (t");
            _builder.append((Object)(3 + i_4), "\t\t");
            _builder.append(" - t");
            _builder.append((Object)(3 + (i_4 - 1)), "\t\t");
            _builder.append(");}");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _groupTimeConstraintEnvironmentClassContent(EventInterval first, GroupTimeConstraint tc) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".messages.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".values.*;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public class ");
        String _string = CommaUtilities.getFullyQualifiedName((NamedElement)this.rulesContainer).toString("_");
        _builder.append(_string);
        String _name = tc.getName();
        _builder.append(_name);
        _builder.append("TimeRuleEnvironment extends CEnvironment {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private double t, t1, t2, ");
        int _length = ((Object[])Conversions.unwrapArray((Object)tc.getFollowups(), Object.class)).length;
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _length, true);
        boolean _hasElements = false;
        for (Integer i : _doubleDotLessThan) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            _builder.append("t");
            _builder.append((Object)(3 + i), "\t");
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private CInterval i1, ");
        int _length_1 = ((Object[])Conversions.unwrapArray((Object)tc.getFollowups(), Object.class)).length;
        ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, _length_1, true);
        boolean _hasElements_1 = false;
        for (Integer i_1 : _doubleDotLessThan_1) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            _builder.append("i");
            _builder.append((Object)(2 + i_1), "\t");
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        String _string_1 = CommaUtilities.getFullyQualifiedName((NamedElement)this.rulesContainer).toString("_");
        _builder.append(_string_1, "\t");
        String _name_1 = tc.getName();
        _builder.append(_name_1, "\t");
        _builder.append("TimeRuleEnvironment() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("i1 = ");
        CharSequence _interval = this.interval(first.getInterval());
        _builder.append((Object)_interval, "\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        int _length_2 = ((Object[])Conversions.unwrapArray((Object)tc.getFollowups(), Object.class)).length;
        ExclusiveRange _doubleDotLessThan_2 = new ExclusiveRange(0, _length_2, true);
        for (Integer i_2 : _doubleDotLessThan_2) {
            _builder.append("\t\t");
            _builder.append("i");
            _builder.append((Object)(2 + i_2), "\t\t");
            _builder.append(" = ");
            CharSequence _interval_1 = this.interval(((FollowUpEvent)tc.getFollowups().get(i_2.intValue())).getInterval());
            _builder.append((Object)_interval_1, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public CEnvironment setVariableValue(String name, Object value) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(name.equals(\"t\")) {t = (double)value;}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(name.equals(\"t1\")) {t1 = (double)value;}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(name.equals(\"t2\")) {t2 = (double)value;}");
        _builder.newLine();
        int _length_3 = ((Object[])Conversions.unwrapArray((Object)tc.getFollowups(), Object.class)).length;
        ExclusiveRange _doubleDotLessThan_3 = new ExclusiveRange(0, _length_3, true);
        for (Integer i_3 : _doubleDotLessThan_3) {
            _builder.append("\t\t");
            _builder.append("if(name.equals(\"t");
            _builder.append((Object)(3 + i_3), "\t\t");
            _builder.append("\")) {t");
            _builder.append((Object)(3 + i_3), "\t\t");
            _builder.append(" = (double)value;}");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return this;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public boolean checkCondition(int index, CObservedMessage message) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(index == 2){return i1.isIn(t2 - t1);}");
        _builder.newLine();
        int _length_4 = ((Object[])Conversions.unwrapArray((Object)tc.getFollowups(), Object.class)).length;
        ExclusiveRange _doubleDotLessThan_4 = new ExclusiveRange(0, _length_4, true);
        for (Integer i_4 : _doubleDotLessThan_4) {
            boolean _tripleEquals;
            _builder.append("\t\t");
            _builder.append("if(index == ");
            _builder.append((Object)(4 + (2 * i_4 - 1)), "\t\t");
            _builder.append("){return ");
            Expression _end = ((FollowUpEvent)tc.getFollowups().get(i_4.intValue())).getInterval().getEnd();
            boolean bl = _tripleEquals = _end == null;
            if (_tripleEquals) {
                _builder.append("true");
            } else {
                _builder.append("(t - t");
                _builder.append((Object)(3 + (i_4 - 1)), "\t\t");
                _builder.append(") <= (");
                CharSequence _generateExpression = this.generateExpression(((FollowUpEvent)tc.getFollowups().get(i_4.intValue())).getInterval().getEnd());
                _builder.append((Object)_generateExpression, "\t\t");
                _builder.append(")");
            }
            _builder.append(";}");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("if(index == ");
            _builder.append((Object)(4 + 2 * i_4), "\t\t");
            _builder.append("){return i");
            _builder.append((Object)(2 + i_4), "\t\t");
            _builder.append(".isIn(t");
            _builder.append((Object)(3 + i_4), "\t\t");
            _builder.append(" - t");
            _builder.append((Object)(3 + (i_4 - 1)), "\t\t");
            _builder.append(");}");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _groupTimeConstraintEnvironmentClassContent(ConditionedAbsenceOfEvent first, GroupTimeConstraint tc) {
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".messages.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".values.*;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public class ");
        String _string = CommaUtilities.getFullyQualifiedName((NamedElement)this.rulesContainer).toString("_");
        _builder.append(_string);
        String _name = tc.getName();
        _builder.append(_name);
        _builder.append("TimeRuleEnvironment extends CEnvironment {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private double t1, t2, t3, t, ");
        int _length = ((Object[])Conversions.unwrapArray((Object)tc.getFollowups(), Object.class)).length;
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _length, true);
        boolean _hasElements = false;
        for (Integer i : _doubleDotLessThan) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            _builder.append("t");
            _builder.append((Object)(4 + i), "\t");
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private CInterval i1, ");
        int _length_1 = ((Object[])Conversions.unwrapArray((Object)tc.getFollowups(), Object.class)).length;
        ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, _length_1, true);
        boolean _hasElements_1 = false;
        for (Integer i_1 : _doubleDotLessThan_1) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            _builder.append("i");
            _builder.append((Object)(2 + i_1), "\t");
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        String _string_1 = CommaUtilities.getFullyQualifiedName((NamedElement)this.rulesContainer).toString("_");
        _builder.append(_string_1, "\t");
        String _name_1 = tc.getName();
        _builder.append(_name_1, "\t");
        _builder.append("TimeRuleEnvironment() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("i1 = ");
        CharSequence _interval = this.interval(first.getInterval());
        _builder.append((Object)_interval, "\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        int _length_2 = ((Object[])Conversions.unwrapArray((Object)tc.getFollowups(), Object.class)).length;
        ExclusiveRange _doubleDotLessThan_2 = new ExclusiveRange(0, _length_2, true);
        for (Integer i_2 : _doubleDotLessThan_2) {
            _builder.append("\t\t");
            _builder.append("i");
            _builder.append((Object)(2 + i_2), "\t\t");
            _builder.append(" = ");
            CharSequence _interval_1 = this.interval(((FollowUpEvent)tc.getFollowups().get(i_2.intValue())).getInterval());
            _builder.append((Object)_interval_1, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public CEnvironment setVariableValue(String name, Object value) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(name.equals(\"t1\")){t1 = (double) value;}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(name.equals(\"t2\")){t2 = (double) value;}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(name.equals(\"t3\")){t3 = (double) value;}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(name.equals(\"t\")){t = (double) value;}");
        _builder.newLine();
        int _length_3 = ((Object[])Conversions.unwrapArray((Object)tc.getFollowups(), Object.class)).length;
        ExclusiveRange _doubleDotLessThan_3 = new ExclusiveRange(0, _length_3, true);
        for (Integer i_3 : _doubleDotLessThan_3) {
            _builder.append("\t\t");
            _builder.append("if(name.equals(\"t");
            _builder.append((Object)(4 + i_3), "\t\t");
            _builder.append("\")){t");
            _builder.append((Object)(4 + i_3), "\t\t");
            _builder.append(" = (double)value;}");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return this;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public boolean checkCondition(int index, CObservedMessage message) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(index == 1) {return ");
        Expression _end = first.getInterval().getEnd();
        boolean bl = _tripleEquals = _end == null;
        if (_tripleEquals) {
            _builder.append("true");
        } else {
            _builder.append("(t2 - t1) <= (");
            CharSequence _generateExpression = this.generateExpression(first.getInterval().getEnd());
            _builder.append((Object)_generateExpression, "\t\t");
            _builder.append(")");
        }
        _builder.append(";}");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("if(index == 2) {return i1.isIn(t3 - t1);}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(index == 3) {return ");
        Expression _end_1 = ((FollowUpEvent)tc.getFollowups().get(0)).getInterval().getEnd();
        boolean bl2 = _tripleEquals_1 = _end_1 == null;
        if (_tripleEquals_1) {
            _builder.append("true");
        } else {
            _builder.append("(t - t1  - ");
            CharSequence _generateExpression_1 = this.generateExpression(first.getInterval().getEnd());
            _builder.append((Object)_generateExpression_1, "\t\t");
            _builder.append(") <= (");
            CharSequence _generateExpression_2 = this.generateExpression(((FollowUpEvent)tc.getFollowups().get(0)).getInterval().getEnd());
            _builder.append((Object)_generateExpression_2, "\t\t");
            _builder.append(")");
        }
        _builder.append(";}");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("if(index == 4) {return i2.isIn(t4 - t1 - ");
        CharSequence _generateExpression_3 = this.generateExpression(first.getInterval().getEnd());
        _builder.append((Object)_generateExpression_3, "\t\t");
        _builder.append(");}");
        _builder.newLineIfNotEmpty();
        int _length_4 = ((Object[])Conversions.unwrapArray((Object)tc.getFollowups(), Object.class)).length;
        ExclusiveRange _doubleDotLessThan_4 = new ExclusiveRange(1, _length_4, true);
        for (Integer i_4 : _doubleDotLessThan_4) {
            boolean _tripleEquals_2;
            _builder.append("\t\t");
            _builder.append("if(index == ");
            _builder.append((Object)(4 + (2 * i_4 - 1)), "\t\t");
            _builder.append(") {return ");
            Expression _end_2 = ((FollowUpEvent)tc.getFollowups().get(i_4.intValue())).getInterval().getEnd();
            boolean bl3 = _tripleEquals_2 = _end_2 == null;
            if (_tripleEquals_2) {
                _builder.append("true");
            } else {
                _builder.append("(t - t");
                _builder.append((Object)(4 + (i_4 - 1)), "\t\t");
                _builder.append(") <= (");
                CharSequence _generateExpression_4 = this.generateExpression(((FollowUpEvent)tc.getFollowups().get(i_4.intValue())).getInterval().getEnd());
                _builder.append((Object)_generateExpression_4, "\t\t");
                _builder.append(")");
            }
            _builder.append(";}");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("if(index == ");
            _builder.append((Object)(4 + 2 * i_4), "\t\t");
            _builder.append(") {return i");
            _builder.append((Object)(2 + i_4), "\t\t");
            _builder.append(".isIn(t");
            _builder.append((Object)(4 + i_4), "\t\t");
            _builder.append(" - t");
            _builder.append((Object)(4 + (i_4 - 1)), "\t\t");
            _builder.append(");}");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _groupTimeConstraintClassContent(ConditionedEvent first, GroupTimeConstraint tc) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _containsPrecondition = this.containsPrecondition((EObject)tc);
        if (_containsPrecondition) {
            _builder.append("import java.util.function.Function;");
            _builder.newLine();
            _builder.append("import java.io.Serializable;");
            _builder.newLine();
            _builder.append("import ");
            _builder.append(TypesJavaGenerator.rootPackage);
            _builder.append(".CState;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".messages.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".values.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".constraints.*;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public class ");
        CharSequence _ruleClassName = this.ruleClassName(this.rulesContainer, (NamedElement)tc);
        _builder.append((Object)_ruleClassName);
        _builder.append(" extends CTimeRule {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        CharSequence _constraintsClassVariables = this.constraintsClassVariables();
        _builder.append((Object)_constraintsClassVariables, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        CharSequence _ruleClassName_1 = this.ruleClassName(this.rulesContainer, (NamedElement)tc);
        _builder.append((Object)_ruleClassName_1, "\t");
        _builder.append("(");
        CharSequence _constraintsClassConstructorParams = this.constraintsClassConstructorParams();
        _builder.append((Object)_constraintsClassConstructorParams, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        String _string = CommaUtilities.getFullyQualifiedName((NamedElement)this.rulesContainer).toString("_");
        _builder.append(_string, "\t\t");
        String _name = tc.getName();
        _builder.append(_name, "\t\t");
        _builder.append("TimeRuleEnvironment env;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("CSequence s;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("CUntil u;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("CEventSelector es;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("CFormula post;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _constraintsClassVariablesInit = this.constraintsClassVariablesInit();
        _builder.append((Object)_constraintsClassVariablesInit, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("name = \"");
        String _name_1 = tc.getName();
        _builder.append(_name_1, "\t\t");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("errorMessage = \"Event is not received in the expected interval.\";");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("env = new ");
        String _string_1 = CommaUtilities.getFullyQualifiedName((NamedElement)this.rulesContainer).toString("_");
        _builder.append(_string_1, "\t\t");
        String _name_2 = tc.getName();
        _builder.append(_name_2, "\t\t");
        _builder.append("TimeRuleEnvironment();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _messagePattern = this.messagePattern(first.getCondition(), "e1");
        _builder.append((Object)_messagePattern, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("es = (CEventSelector)new CEventSelector().setEvent(e1).setTimeVariable(\"t1\").setEnvironment(env);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("s = new CSequence().addElement(es).setEnvironment(env);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("formula = new CConditionalFollow().setLeft(s);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//Consequence");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _messagePattern_1 = this.messagePattern(first.getEvent(), "e2");
        _builder.append((Object)_messagePattern_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("es = (CEventSelector)new CEventSelector().setTimeVariable(\"t\").setEvent(e2).setNegated().setConditionIndex(1).setEnvironment(env);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("u = (CUntil)new CUntil().setBody(es).setEnvironment(env);");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _messagePattern_2 = this.messagePattern(first.getEvent(), "e3");
        _builder.append((Object)_messagePattern_2, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("es = (CEventSelector)new CEventSelector().setTimeVariable(\"t2\").setEvent(e3).setConditionIndex(2).setEnvironment(env);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("u.setStop(es);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("s = new CSequence().addElement(u).setEnvironment(env);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//Followups");
        _builder.newLine();
        int _length = ((Object[])Conversions.unwrapArray((Object)tc.getFollowups(), Object.class)).length;
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _length, true);
        for (Integer i : _doubleDotLessThan) {
            _builder.append("\t\t");
            CharSequence _messagePattern_3 = this.messagePattern(((FollowUpEvent)tc.getFollowups().get(i.intValue())).getEvent(), "e" + Integer.valueOf(4 + i));
            _builder.append((Object)_messagePattern_3, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("es = (CEventSelector)new CEventSelector().setTimeVariable(\"t\").setEvent(e");
            _builder.append((Object)(4 + i), "\t\t");
            _builder.append(").setNegated().setConditionIndex(");
            _builder.append((Object)(3 + 2 * i), "\t\t");
            _builder.append(").setEnvironment(env);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("u = (CUntil) new CUntil().setBody(es).setEnvironment(env);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("es = (CEventSelector)new CEventSelector().setTimeVariable(\"t");
            _builder.append((Object)(3 + i), "\t\t");
            _builder.append("\").setEvent(e");
            _builder.append((Object)(4 + i), "\t\t");
            _builder.append(").setConditionIndex(");
            _builder.append((Object)(4 + 2 * i), "\t\t");
            _builder.append(").setEnvironment(env);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("u.setStop(es);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("s.addElement(u);");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.append("((CConditionalFollow)formula).setRight(s);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _groupTimeConstraintClassContent(EventInterval first, GroupTimeConstraint tc) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _containsPrecondition = this.containsPrecondition((EObject)tc);
        if (_containsPrecondition) {
            _builder.append("import java.util.function.Function;");
            _builder.newLine();
            _builder.append("import java.io.Serializable;");
            _builder.newLine();
            _builder.append("import ");
            _builder.append(TypesJavaGenerator.rootPackage);
            _builder.append(".CState;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".messages.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".values.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".constraints.*;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append("public class ");
        CharSequence _ruleClassName = this.ruleClassName(this.rulesContainer, (NamedElement)tc);
        _builder.append((Object)_ruleClassName);
        _builder.append(" extends CTimeRule {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        CharSequence _constraintsClassVariables = this.constraintsClassVariables();
        _builder.append((Object)_constraintsClassVariables, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        CharSequence _ruleClassName_1 = this.ruleClassName(this.rulesContainer, (NamedElement)tc);
        _builder.append((Object)_ruleClassName_1, "\t");
        _builder.append("(");
        CharSequence _constraintsClassConstructorParams = this.constraintsClassConstructorParams();
        _builder.append((Object)_constraintsClassConstructorParams, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        String _string = CommaUtilities.getFullyQualifiedName((NamedElement)this.rulesContainer).toString("_");
        _builder.append(_string, "\t\t");
        String _name = tc.getName();
        _builder.append(_name, "\t\t");
        _builder.append("TimeRuleEnvironment env;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("CSequence s;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("CUntil u;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("CEventSelector es;");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _constraintsClassVariablesInit = this.constraintsClassVariablesInit();
        _builder.append((Object)_constraintsClassVariablesInit, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("name = \"");
        String _name_1 = tc.getName();
        _builder.append(_name_1, "\t\t");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("errorMessage = \"Event is not received in the expected interval.\";");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("env = new ");
        String _string_1 = CommaUtilities.getFullyQualifiedName((NamedElement)this.rulesContainer).toString("_");
        _builder.append(_string_1, "\t\t");
        String _name_2 = tc.getName();
        _builder.append(_name_2, "\t\t");
        _builder.append("TimeRuleEnvironment();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _messagePattern = this.messagePattern(first.getCondition(), "e1");
        _builder.append((Object)_messagePattern, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("es = (CEventSelector)new CEventSelector().setTimeVariable(\"t1\").setEvent(e1).setEnvironment(env);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("s = new CSequence().addElement(es).setEnvironment(env);");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _messagePattern_1 = this.messagePattern(first.getEvent(), "e2");
        _builder.append((Object)_messagePattern_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("es = (CEventSelector)new CEventSelector().setTimeVariable(\"t\").setEvent(e2).setNegated().setEnvironment(env);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("u = (CUntil)new CUntil().setBody(es).setEnvironment(env);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("es = (CEventSelector)new CEventSelector().setTimeVariable(\"t2\").setEvent(e2).setConditionIndex(2).setEnvironment(env);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("u.setStop(es);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("s.addElement(u);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("formula = new CConditionalFollow().setLeft(s);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("s = new CSequence().setEnvironment(env);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//Followups");
        _builder.newLine();
        int _length = ((Object[])Conversions.unwrapArray((Object)tc.getFollowups(), Object.class)).length;
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _length, true);
        for (Integer i : _doubleDotLessThan) {
            _builder.append("\t\t");
            CharSequence _messagePattern_2 = this.messagePattern(((FollowUpEvent)tc.getFollowups().get(i.intValue())).getEvent(), "e" + Integer.valueOf(3 + i));
            _builder.append((Object)_messagePattern_2, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("es = (CEventSelector)new CEventSelector().setTimeVariable(\"t\").setEvent(e");
            _builder.append((Object)(3 + i), "\t\t");
            _builder.append(").setNegated().setConditionIndex(");
            _builder.append((Object)(3 + 2 * i), "\t\t");
            _builder.append(").setEnvironment(env);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("u = (CUntil)new CUntil().setBody(es).setEnvironment(env);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("es = (CEventSelector)new CEventSelector().setTimeVariable(\"t");
            _builder.append((Object)(3 + i), "\t\t");
            _builder.append("\").setEvent(e");
            _builder.append((Object)(3 + i), "\t\t");
            _builder.append(").setConditionIndex(");
            _builder.append((Object)(4 + 2 * i), "\t\t");
            _builder.append(").setEnvironment(env);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("u.setStop(es);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("s.addElement(u);");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.append("((CConditionalFollow)formula).setRight(s);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _groupTimeConstraintClassContent(ConditionedAbsenceOfEvent first, GroupTimeConstraint tc) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _containsPrecondition = this.containsPrecondition((EObject)tc);
        if (_containsPrecondition) {
            _builder.append("import java.util.function.Function;");
            _builder.newLine();
            _builder.append("import java.io.Serializable;");
            _builder.newLine();
            _builder.append("import ");
            _builder.append(TypesJavaGenerator.rootPackage);
            _builder.append(".CState;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".messages.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".values.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".constraints.*;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public class ");
        CharSequence _ruleClassName = this.ruleClassName(this.rulesContainer, (NamedElement)tc);
        _builder.append((Object)_ruleClassName);
        _builder.append(" extends CTimeRule {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        CharSequence _constraintsClassVariables = this.constraintsClassVariables();
        _builder.append((Object)_constraintsClassVariables, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        CharSequence _ruleClassName_1 = this.ruleClassName(this.rulesContainer, (NamedElement)tc);
        _builder.append((Object)_ruleClassName_1, "\t");
        _builder.append("(");
        CharSequence _constraintsClassConstructorParams = this.constraintsClassConstructorParams();
        _builder.append((Object)_constraintsClassConstructorParams, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        String _string = CommaUtilities.getFullyQualifiedName((NamedElement)this.rulesContainer).toString("_");
        _builder.append(_string, "\t\t");
        String _name = tc.getName();
        _builder.append(_name, "\t\t");
        _builder.append("TimeRuleEnvironment env = new ");
        String _string_1 = CommaUtilities.getFullyQualifiedName((NamedElement)this.rulesContainer).toString("_");
        _builder.append(_string_1, "\t\t");
        String _name_1 = tc.getName();
        _builder.append(_name_1, "\t\t");
        _builder.append("TimeRuleEnvironment();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("name = \"");
        String _name_2 = tc.getName();
        _builder.append(_name_2, "\t\t");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("errorMessage = \"Event is not received in the expected interval.\";");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _constraintsClassVariablesInit = this.constraintsClassVariablesInit();
        _builder.append((Object)_constraintsClassVariablesInit, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("formula = new CImplication(). ");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("setLeft(new CNegation().");
        _builder.newLine();
        _builder.append("\t\t\t\t\t            ");
        _builder.append("setFormula(new CConditionalFollow(). ");
        _builder.newLine();
        _builder.append("\t\t\t\t\t                           ");
        _builder.append("setLeft(new CSequence(). ");
        _builder.newLine();
        _builder.append("\t\t\t\t\t                                      ");
        _builder.append("addElement((CEventSelector)new CEventSelector().setTimeVariable(\"t1\").");
        _builder.newLine();
        _builder.append("\t\t\t\t\t                                                 ");
        _builder.append("setEvent(");
        CharSequence _generateEvent = this.generateEvent(first.getCondition().getEvent());
        _builder.append((Object)_generateEvent, "\t\t\t\t\t                                                 ");
        _builder.append(").");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t                                                 ");
        _builder.append("setEnvironment(env)).");
        _builder.newLine();
        _builder.append("\t\t\t\t\t                                      ");
        _builder.append("setEnvironment(env)).");
        _builder.newLine();
        _builder.append("\t\t\t\t\t                           ");
        _builder.append("setRight(new CSequence().");
        _builder.newLine();
        _builder.append("\t\t\t\t\t                                       ");
        _builder.append("addElement((CUntil)new CUntil().");
        _builder.newLine();
        _builder.append("\t\t\t\t\t                                                  ");
        _builder.append("setBody((CEventSelector)new CEventSelector().setTimeVariable(\"t2\").setEvent(");
        CharSequence _generateEvent_1 = this.generateEvent(first.getEvent().getEvent());
        _builder.append((Object)_generateEvent_1, "\t\t\t\t\t                                                  ");
        _builder.append(").setNegated().setConditionIndex(1).setEnvironment(env)).");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t                                                  ");
        _builder.append("setStop((CEventSelector)new CEventSelector().setTimeVariable(\"t3\").setEvent(");
        CharSequence _generateEvent_2 = this.generateEvent(first.getEvent().getEvent());
        _builder.append((Object)_generateEvent_2, "\t\t\t\t\t                                                  ");
        _builder.append(").setConditionIndex(2).setEnvironment(env)).");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t                                                  ");
        _builder.append("setEnvironment(env)).");
        _builder.newLine();
        _builder.append("\t\t\t\t\t                                       ");
        _builder.append("setEnvironment(env)))).");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("setRight(new CConditionalFollow(). ");
        _builder.newLine();
        _builder.append("\t\t\t\t\t         ");
        _builder.append("setLeft(new CSequence().");
        _builder.newLine();
        _builder.append("\t\t\t\t\t                 ");
        _builder.append("addElement((CEventSelector)new CEventSelector().setTimeVariable(\"t1\").setEvent(");
        CharSequence _generateEvent_3 = this.generateEvent(first.getCondition().getEvent());
        _builder.append((Object)_generateEvent_3, "\t\t\t\t\t                 ");
        _builder.append(").setEnvironment(env)).");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t                 ");
        _builder.append("setEnvironment(env)).");
        _builder.newLine();
        _builder.append("\t\t\t\t\t         ");
        _builder.append("setRight(new CSequence(). ");
        _builder.newLine();
        _builder.append("\t\t\t\t\t                  ");
        _builder.append("addElement((CUntil)new CUntil(). ");
        _builder.newLine();
        _builder.append("\t\t\t\t\t                              ");
        _builder.append("setBody((CEventSelector)new CEventSelector().setTimeVariable(\"t\").setEvent(");
        CharSequence _generateEvent_4 = this.generateEvent(((FollowUpEvent)tc.getFollowups().get(0)).getEvent().getEvent());
        _builder.append((Object)_generateEvent_4, "\t\t\t\t\t                              ");
        _builder.append(").setNegated().setConditionIndex(3).setEnvironment(env)).");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t                              ");
        _builder.append("setStop((CEventSelector)new CEventSelector().setTimeVariable(\"t4\").setEvent(");
        CharSequence _generateEvent_5 = this.generateEvent(((FollowUpEvent)tc.getFollowups().get(0)).getEvent().getEvent());
        _builder.append((Object)_generateEvent_5, "\t\t\t\t\t                              ");
        _builder.append(").setConditionIndex(4).setEnvironment(env)).");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t                              ");
        _builder.append("setEnvironment(env)).");
        _builder.newLine();
        _builder.append("\t\t\t\t\t                  ");
        _builder.append("//More followups if any");
        _builder.newLine();
        int _length = ((Object[])Conversions.unwrapArray((Object)tc.getFollowups(), Object.class)).length;
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(1, _length, true);
        for (Integer i : _doubleDotLessThan) {
            _builder.append("\t\t\t\t\t                  ");
            _builder.append("addElement((CUntil)new CUntil(). ");
            _builder.newLine();
            _builder.append("\t\t\t\t\t                  ");
            _builder.append("            ");
            _builder.append("setBody((CEventSelector)new CEventSelector().setTimeVariable(\"t\").setEvent(");
            CharSequence _generateEvent_6 = this.generateEvent(((FollowUpEvent)tc.getFollowups().get(i.intValue())).getEvent().getEvent());
            _builder.append((Object)_generateEvent_6, "\t\t\t\t\t                              ");
            _builder.append(").setNegated().setConditionIndex(");
            _builder.append((Object)(4 + (2 * i - 1)), "\t\t\t\t\t                              ");
            _builder.append(").setEnvironment(env)).");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t\t\t                  ");
            _builder.append("            ");
            _builder.append("setStop((CEventSelector)new CEventSelector().setTimeVariable(\"t");
            _builder.append((Object)(4 + i), "\t\t\t\t\t                              ");
            _builder.append("\").setEvent(");
            CharSequence _generateEvent_7 = this.generateEvent(((FollowUpEvent)tc.getFollowups().get(i.intValue())).getEvent().getEvent());
            _builder.append((Object)_generateEvent_7, "\t\t\t\t\t                              ");
            _builder.append(").setConditionIndex(");
            _builder.append((Object)(4 + 2 * i), "\t\t\t\t\t                              ");
            _builder.append(").setEnvironment(env)).");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t\t\t                  ");
            _builder.append("            ");
            _builder.append("setEnvironment(env).");
            _builder.newLine();
        }
        _builder.append("\t\t\t\t\t                  ");
        _builder.append("setEnvironment(env)));");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _stepToJava(EventSelector s, List<Expression> conditions) {
        boolean _tripleNotEquals_3;
        Expression _condition;
        boolean _tripleNotEquals_2;
        String _negated;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new CEventSelector().setEvent(");
        CharSequence _generateEvent = this.generateEvent(s.getEvent().getEvent());
        _builder.append((Object)_generateEvent);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        ExpressionVariable _counter = s.getCounter();
        boolean bl = _tripleNotEquals = _counter != null;
        if (_tripleNotEquals) {
            _builder.append(".setOccurenceVariable(\"");
            String _name = s.getCounter().getVariable().getName();
            _builder.append(_name, "\t");
            _builder.append("\")");
        }
        boolean bl2 = _tripleNotEquals_1 = (_negated = s.getNegated()) != null;
        if (_tripleNotEquals_1) {
            _builder.append(".setNegated()");
        }
        boolean bl3 = _tripleNotEquals_2 = (_condition = s.getCondition()) != null;
        if (_tripleNotEquals_2) {
            _builder.append(".setConditionIndex(");
            int _indexOf = conditions.indexOf(s.getCondition());
            int _plus = _indexOf + 1;
            _builder.append((Object)_plus, "\t");
            _builder.append(")");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(".setTimeVariable(\"");
        String _name_1 = s.getTimestamp().getVariable().getName();
        _builder.append(_name_1, "\t");
        _builder.append("\").setEnvironment(env");
        ExpressionVariable _counter_1 = s.getCounter();
        boolean bl4 = _tripleNotEquals_3 = _counter_1 != null;
        if (_tripleNotEquals_3) {
            _builder.append(".setVariableValue(\"");
            String _name_2 = s.getCounter().getVariable().getName();
            _builder.append(_name_2, "\t");
            _builder.append("\", 0L)");
        }
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _stepToJava(Connector c, List<Expression> conditions) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new CUntil()");
        ConnectorOperator _conOperator = c.getConOperator();
        boolean _equals = Objects.equal((Object)_conOperator, (Object)ConnectorOperator.WU);
        if (_equals) {
            _builder.append(".setWeak()");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(".setBody((CStep) ");
        CharSequence _stepToJava = this.stepToJava((SequenceElement)c.getLeft(), conditions);
        _builder.append((Object)_stepToJava, "\t");
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(".setStop((CStep) ");
        CharSequence _stepToJava_1 = this.stepToJava((SequenceElement)c.getRight(), conditions);
        _builder.append((Object)_stepToJava_1, "\t");
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(".setEnvironment(env)");
        return _builder;
    }

    protected CharSequence _stepToJava(ESDisjunction s, List<Expression> conditions) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new CORStep()");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(".addSelector((CStep)");
        CharSequence _stepToJava = this.stepToJava((SequenceElement)s.getLeft(), conditions);
        _builder.append((Object)_stepToJava, "\t");
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(".addSelector((CStep)");
        CharSequence _stepToJava_1 = this.stepToJava((SequenceElement)s.getRight(), conditions);
        _builder.append((Object)_stepToJava_1, "\t");
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _formulaToJava(NegationFormula f, List<Expression> conditions) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new CNegation().setFormula(");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _formulaToJava = this.formulaToJava(f.getSub(), conditions);
        _builder.append((Object)_formulaToJava, "\t");
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _formulaToJava(BracketFormula f, List<Expression> conditions) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _formulaToJava = this.formulaToJava(f.getSub(), conditions);
        _builder.append((Object)_formulaToJava);
        return _builder;
    }

    protected CharSequence _formulaToJava(Sequence f, List<Expression> conditions) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new CSequence()");
        _builder.newLine();
        EList _steps = f.getSteps();
        for (SequenceElement step : _steps) {
            _builder.append(".addElement(");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _stepToJava = this.stepToJava(step, conditions);
            _builder.append((Object)_stepToJava, "\t");
            _builder.append(")");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append(".setEnvironment(env)");
        Expression _condition = f.getCondition();
        boolean bl = _tripleNotEquals = _condition != null;
        if (_tripleNotEquals) {
            _builder.append(".setConditionIndex(");
            int _indexOf = conditions.indexOf(f.getCondition());
            int _plus = _indexOf + 1;
            _builder.append((Object)_plus, "\t");
            _builder.append(")");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _formulaToJava(Conjunction f, List<Expression> conditions) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new CConjunction()");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(".setLeft(");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _formulaToJava = this.formulaToJava(f.getLeft(), conditions);
        _builder.append((Object)_formulaToJava, "\t\t");
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(".setRight(");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _formulaToJava_1 = this.formulaToJava(f.getRight(), conditions);
        _builder.append((Object)_formulaToJava_1, "\t\t");
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _formulaToJava(Disjunction f, List<Expression> conditions) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new CDisjunction()");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(".setLeft(");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _formulaToJava = this.formulaToJava(f.getLeft(), conditions);
        _builder.append((Object)_formulaToJava, "\t\t");
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(".setRight(");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _formulaToJava_1 = this.formulaToJava(f.getRight(), conditions);
        _builder.append((Object)_formulaToJava_1, "\t\t");
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _formulaToJava(Implication f, List<Expression> conditions) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new CImplication()");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(".setLeft(");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _formulaToJava = this.formulaToJava(f.getLeft(), conditions);
        _builder.append((Object)_formulaToJava, "\t\t");
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(".setRight(");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _formulaToJava_1 = this.formulaToJava(f.getRight(), conditions);
        _builder.append((Object)_formulaToJava_1, "\t\t");
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _formulaToJava(ConditionalFollow f, List<Expression> conditions) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new CConditionalFollow()");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(".setLeft(");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _formulaToJava = this.formulaToJava(f.getLeft(), conditions);
        _builder.append((Object)_formulaToJava, "\t\t");
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(".setRight(");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _formulaToJava_1 = this.formulaToJava(f.getRight(), conditions);
        _builder.append((Object)_formulaToJava_1, "\t\t");
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _formulaToJava(ConstraintSequence f, List<Expression> conditions) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new CConstraintSequence().setConditionIndex(");
        int _indexOf = conditions.indexOf(f.getCond());
        int _plus = _indexOf + 1;
        _builder.append((Object)_plus);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(".setSequence(");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _formulaToJava = this.formulaToJava(f.getLeft(), conditions);
        _builder.append((Object)_formulaToJava, "\t\t");
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _generateEvent(AnyEvent e) {
        StringConcatenation _xblockexpression = null;
        String _switchResult = null;
        EVENT_KIND _kind = e.getKind();
        if (_kind != null) {
            switch (_kind) {
                case EVENT: {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("new CMessagePattern()");
                    _switchResult = _builder.toString();
                    break;
                }
                case CALL: {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("new CCommandPattern(\"*\")");
                    _switchResult = _builder_1.toString();
                    break;
                }
                case SIGNAL: {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("new CSignalPattern(\"*\")");
                    _switchResult = _builder_2.toString();
                    break;
                }
                case NOTIFICATION: {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("new CNotificationPattern(\"*\")");
                    _switchResult = _builder_3.toString();
                    break;
                }
            }
        }
        String messagePattern = _switchResult;
        StringConcatenation _builder_4 = new StringConcatenation();
        _builder_4.append("(CMessagePattern)");
        _builder_4.append(messagePattern);
        String _generatePreconditionFragment = this.generatePreconditionFragment((EventPattern)e);
        _builder_4.append(_generatePreconditionFragment);
        String _generateStatesFragment = this.generateStatesFragment((EventPattern)e);
        _builder_4.append(_generateStatesFragment);
        _xblockexpression = _builder_4;
        return _xblockexpression;
    }

    public CharSequence generateParametersFragment(ParameterizedEvent e) {
        StringConcatenation _builder = new StringConcatenation();
        EList _parameters = e.getParameters();
        for (Expression p : _parameters) {
            _builder.append(".addParameter(");
            if (p instanceof ExpressionVariable) {
                _builder.append("new CVariable(\"");
                String _name = ((ExpressionVariable)p).getVariable().getName();
                _builder.append(_name);
                _builder.append("\", ");
                CharSequence _javaReferenceType = this.toJavaReferenceType((EObject)((ExpressionVariable)p).getVariable().getType());
                _builder.append((Object)_javaReferenceType);
                _builder.append(".class)");
            } else {
                CharSequence _generateExpression = this.generateExpression(p);
                _builder.append((Object)_generateExpression);
            }
            _builder.append(")");
        }
        return _builder;
    }

    public String generateStatesFragment(EventPattern e) {
        EObject _eContainer = e.eContainer();
        if (_eContainer instanceof EventInState) {
            EObject _eContainer_1 = e.eContainer();
            EventInState parent = (EventInState)_eContainer_1;
            StringConcatenation _builder = new StringConcatenation();
            EList _state = parent.getState();
            for (State s : _state) {
                _builder.append(".addState(\"");
                String _name = s.getName();
                _builder.append(_name);
                _builder.append("\")");
            }
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        return _builder_1.toString();
    }

    public String generatePreconditionFragment(EventPattern e) {
        EObject _eContainer = e.eContainer();
        if (_eContainer instanceof EventInState) {
            boolean _tripleNotEquals;
            EObject _eContainer_1 = e.eContainer();
            EventInState parent = (EventInState)_eContainer_1;
            Expression _preCondition = parent.getPreCondition();
            boolean bl = _tripleNotEquals = _preCondition != null;
            if (_tripleNotEquals) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(".setPrecondition(");
                CharSequence _preconditionLambda = this.preconditionLambda(parent);
                _builder.append((Object)_preconditionLambda);
                _builder.append(")");
                return _builder.toString();
            }
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        return _builder_1.toString();
    }

    public CharSequence generateEventCommonPart(EventPattern e) {
        StringConcatenation _builder = new StringConcatenation();
        String _generatePreconditionFragment = this.generatePreconditionFragment(e);
        _builder.append(_generatePreconditionFragment);
        CharSequence _generateParametersFragment = this.generateParametersFragment((ParameterizedEvent)e);
        _builder.append((Object)_generateParametersFragment);
        String _generateStatesFragment = this.generateStatesFragment(e);
        _builder.append(_generateStatesFragment);
        return _builder;
    }

    protected CharSequence _generateEvent(CommandEvent e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(CCommandPattern)new CCommandPattern(\"");
        String _name = e.getEvent().getName();
        _builder.append(_name);
        _builder.append("\")");
        CharSequence _generateEventCommonPart = this.generateEventCommonPart((EventPattern)e);
        _builder.append((Object)_generateEventCommonPart);
        return _builder;
    }

    protected CharSequence _generateEvent(CommandReply e) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(CReplyPattern)new CReplyPattern()");
        CommandEvent _command = e.getCommand();
        boolean bl = _tripleNotEquals = _command != null;
        if (_tripleNotEquals) {
            _builder.append(".setCommand(");
            CharSequence _generateEvent = this.generateEvent((EventPattern)e.getCommand());
            _builder.append((Object)_generateEvent);
            _builder.append(")");
        }
        CharSequence _generateEventCommonPart = this.generateEventCommonPart((EventPattern)e);
        _builder.append((Object)_generateEventCommonPart);
        return _builder;
    }

    protected CharSequence _generateEvent(NotificationEvent e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(CNotificationPattern)new CNotificationPattern(\"");
        String _name = e.getEvent().getName();
        _builder.append(_name);
        _builder.append("\")");
        CharSequence _generateEventCommonPart = this.generateEventCommonPart((EventPattern)e);
        _builder.append((Object)_generateEventCommonPart);
        return _builder;
    }

    protected CharSequence _generateEvent(SignalEvent e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(CSignalPattern)new CSignalPattern(\"");
        String _name = e.getEvent().getName();
        _builder.append(_name);
        _builder.append("\")");
        CharSequence _generateEventCommonPart = this.generateEventCommonPart((EventPattern)e);
        _builder.append((Object)_generateEventCommonPart);
        return _builder;
    }

    public CharSequence dataConstraintToJava(DataConstraint dc) {
        StringConcatenation _builder = new StringConcatenation();
        EList _steps = dc.getSteps();
        for (DataConstraintStep step : _steps) {
            CharSequence _dataSequenceStepToJava = this.dataSequenceStepToJava(step);
            _builder.append((Object)_dataSequenceStepToJava);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _dataSequenceStepToJava(DataConstraintEvent s) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(".addElement(");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("new CEventSelector().");
        _builder.newLine();
        _builder.append("\t    ");
        _builder.append("setEvent(");
        CharSequence _generateEvent = this.generateEvent(s.getEvent().getEvent());
        _builder.append((Object)_generateEvent, "\t    ");
        _builder.append(").");
        _builder.newLineIfNotEmpty();
        _builder.append("\t    ");
        _builder.append("setTimeVariable(\"t\")");
        String _negated = s.getNegated();
        boolean bl = _tripleNotEquals = _negated != null;
        if (_tripleNotEquals) {
            _builder.append(".setNegated()");
        }
        _builder.append(".setEnvironment(env)");
        _builder.newLineIfNotEmpty();
        _builder.append(")");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _dataSequenceStepToJava(DataConstraintUntilOperator s) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(".addElement(");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("new CUntil().");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("setBody(");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("(CStep)new CEventSelector().setEvent(");
        CharSequence _generateEvent = this.generateEvent(s.getBody().getEvent().getEvent());
        _builder.append((Object)_generateEvent, "\t\t");
        _builder.append(").");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("setTimeVariable(\"t\")");
        String _negated = s.getBody().getNegated();
        boolean bl = _tripleNotEquals = _negated != null;
        if (_tripleNotEquals) {
            _builder.append(".setNegated()");
        }
        _builder.append(".setEnvironment(env)).");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("setStop(");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("(CStep)new CEventSelector().setEvent(");
        CharSequence _generateEvent_1 = this.generateEvent(s.getStop().getEvent().getEvent());
        _builder.append((Object)_generateEvent_1, "\t\t");
        _builder.append(").");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("setTimeVariable(\"t\")");
        String _negated_1 = s.getStop().getNegated();
        boolean bl2 = _tripleNotEquals_1 = _negated_1 != null;
        if (_tripleNotEquals_1) {
            _builder.append(".setNegated()");
        }
        _builder.append(".setEnvironment(env)");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append(").setEnvironment(env))");
        _builder.newLine();
        return _builder;
    }

    public CharSequence interval(TimeInterval i) {
        Expression _end;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new CInterval()");
        Expression _begin = i.getBegin();
        boolean bl = _tripleNotEquals = _begin != null;
        if (_tripleNotEquals) {
            _builder.append(".setBegin(");
            CharSequence _generateExpression = this.generateExpression(i.getBegin());
            _builder.append((Object)_generateExpression);
            _builder.append(")");
        }
        boolean bl2 = _tripleNotEquals_1 = (_end = i.getEnd()) != null;
        if (_tripleNotEquals_1) {
            _builder.append(".setEnd(");
            CharSequence _generateExpression_1 = this.generateExpression(i.getEnd());
            _builder.append((Object)_generateExpression_1);
            _builder.append(")");
        }
        return _builder;
    }

    public List<Expression> collectConditions(GenericConstraintsBlock block) {
        ArrayList<Expression> result = new ArrayList<Expression>();
        TreeIterator iter = null;
        EObject o = null;
        iter = block.eAllContents();
        while (iter.hasNext()) {
            boolean _tripleNotEquals_1;
            o = (EObject)iter.next();
            if (o instanceof ConstraintSequence) {
                result.add(((ConstraintSequence)o).getCond());
            }
            if (o instanceof Sequence) {
                boolean _tripleNotEquals;
                Expression _condition = ((Sequence)o).getCondition();
                boolean bl = _tripleNotEquals = _condition != null;
                if (_tripleNotEquals) {
                    result.add(((Sequence)o).getCondition());
                }
            }
            if (!(o instanceof EventSelector)) continue;
            Expression _condition_1 = ((EventSelector)o).getCondition();
            boolean bl = _tripleNotEquals_1 = _condition_1 != null;
            if (!_tripleNotEquals_1) continue;
            result.add(((EventSelector)o).getCondition());
        }
        return result;
    }

    public boolean containsPrecondition(EObject constraint) {
        Functions.Function1<EventInState, Boolean> _function = new Functions.Function1<EventInState, Boolean>(){

            public Boolean apply(EventInState it) {
                Expression _preCondition = it.getPreCondition();
                return _preCondition != null;
            }
        };
        return IterableExtensions.exists((Iterable)EcoreUtil2.getAllContentsOfType((EObject)constraint, EventInState.class), (Functions.Function1)_function);
    }

    public boolean containsPrecondition(AbstractBehavior behavior) {
        boolean _tripleEquals;
        boolean _xblockexpression = false;
        TimeConstraintsBlock _timeConstraintsBlock = behavior.getTimeConstraintsBlock();
        boolean bl = _tripleEquals = _timeConstraintsBlock == null;
        if (_tripleEquals) {
            return false;
        }
        Functions.Function1<TimeConstraint, Boolean> _function = new Functions.Function1<TimeConstraint, Boolean>(){

            public Boolean apply(TimeConstraint it) {
                return it instanceof SingleTimeConstraint && ConstraintsRulesGenerator.this.containsPrecondition((EObject)it);
            }
        };
        _xblockexpression = IterableExtensions.exists((Iterable)behavior.getTimeConstraintsBlock().getTimeConstraints(), (Functions.Function1)_function);
        return _xblockexpression;
    }

    public void generateConstraintClasses() {
        GenericConstraintsBlock _genericConstraintsBlock;
        boolean _tripleNotEquals_2;
        DataConstraintsBlock _dataConstraintsBlock;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        TimeConstraintsBlock _timeConstraintsBlock = this.behavior.getTimeConstraintsBlock();
        boolean bl = _tripleNotEquals = _timeConstraintsBlock != null;
        if (_tripleNotEquals) {
            EList _timeConstraints = this.behavior.getTimeConstraintsBlock().getTimeConstraints();
            for (TimeConstraint tr : _timeConstraints) {
                if (!(tr instanceof GroupTimeConstraint)) continue;
                String _string = CommaUtilities.getFullyQualifiedName((NamedElement)this.rulesContainer).toString("_");
                String _name = ((GroupTimeConstraint)tr).getName();
                String _plus = String.valueOf(_string) + _name;
                String _plus_1 = String.valueOf(_plus) + "TimeRuleEnvironment";
                this.fsa.generateFile(TypesJavaGenerator.generatedFileName(_plus_1), this.groupTimeConstraintEnvironmentClassContent(((GroupTimeConstraint)tr).getFirst(), (GroupTimeConstraint)tr));
                this.fsa.generateFile(TypesJavaGenerator.generatedFileName(this.ruleClassName(this.rulesContainer, (NamedElement)tr).toString()), this.groupTimeConstraintClassContent(((GroupTimeConstraint)tr).getFirst(), (GroupTimeConstraint)tr));
            }
        }
        boolean bl2 = _tripleNotEquals_1 = (_dataConstraintsBlock = this.behavior.getDataConstraintsBlock()) != null;
        if (_tripleNotEquals_1) {
            this.quantifiersInMachines = this.getQuantifiersInContainer((EObject)this.behavior.getDataConstraintsBlock());
            String _string_1 = CommaUtilities.getFullyQualifiedName((NamedElement)this.rulesContainer).toString("_");
            String _plus_2 = String.valueOf(_string_1) + "DataRulesEnvironment";
            this.fsa.generateFile(TypesJavaGenerator.generatedFileName(_plus_2), this.dataRulesEnvironmentClassContent());
            EList _dataConstraints = this.behavior.getDataConstraintsBlock().getDataConstraints();
            for (DataConstraint dr : _dataConstraints) {
                this.fsa.generateFile(TypesJavaGenerator.generatedFileName(this.ruleClassName(this.rulesContainer, (NamedElement)dr).toString()), this.dataRuleClassContent(dr));
            }
        }
        boolean bl3 = _tripleNotEquals_2 = (_genericConstraintsBlock = this.behavior.getGenericConstraintsBlock()) != null;
        if (_tripleNotEquals_2) {
            this.genericRulesConditions = this.collectConditions(this.behavior.getGenericConstraintsBlock());
            this.quantifiersInMachines = this.getQuantifiersInContainer((EObject)this.behavior.getGenericConstraintsBlock());
            String _string_2 = CommaUtilities.getFullyQualifiedName((NamedElement)this.rulesContainer).toString("_");
            String _plus_3 = String.valueOf(_string_2) + "GenericRulesEnvironment";
            this.fsa.generateFile(TypesJavaGenerator.generatedFileName(_plus_3), this.genericRulesEnvironmentClassContent());
            EList _genericConstraints = this.behavior.getGenericConstraintsBlock().getGenericConstraints();
            for (GenericConstraint gc : _genericConstraints) {
                this.fsa.generateFile(TypesJavaGenerator.generatedFileName(this.ruleClassName(this.rulesContainer, (NamedElement)gc).toString()), this.genericRuleClassContent(gc));
            }
        }
        this.fsa.generateFile(TypesJavaGenerator.generatedFileName(ConstraintsRulesGenerator.rulesClassName(this.rulesContainer).toString()), this.constraintsClassProviderContent(this.behavior));
    }

    public static CharSequence utilityClassName(Signature s) {
        StringConcatenation _builder = new StringConcatenation();
        String _string = CommaUtilities.getFullyQualifiedName((NamedElement)s).toString("_");
        _builder.append(_string);
        _builder.append("State");
        return _builder;
    }

    public static CharSequence utilityClassName(Interface s) {
        StringConcatenation _builder = new StringConcatenation();
        String _string = CommaUtilities.getFullyQualifiedName((NamedElement)s).toString("_");
        _builder.append(_string);
        _builder.append("State");
        return _builder;
    }

    public CharSequence singleTimeConstraintToJavaMethod(TimeConstraintExpression r, TimeConstraint rule) {
        if (r instanceof ConditionedAbsenceOfEvent) {
            return this._singleTimeConstraintToJavaMethod((ConditionedAbsenceOfEvent)r, rule);
        }
        if (r instanceof ConditionedEvent) {
            return this._singleTimeConstraintToJavaMethod((ConditionedEvent)r, rule);
        }
        if (r instanceof EventInterval) {
            return this._singleTimeConstraintToJavaMethod((EventInterval)r, rule);
        }
        if (r instanceof PeriodicEvent) {
            return this._singleTimeConstraintToJavaMethod((PeriodicEvent)r, rule);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(r, rule).toString());
    }

    public CharSequence groupTimeConstraintEnvironmentClassContent(TimeConstraintExpression first, GroupTimeConstraint tc) {
        if (first instanceof ConditionedAbsenceOfEvent) {
            return this._groupTimeConstraintEnvironmentClassContent((ConditionedAbsenceOfEvent)first, tc);
        }
        if (first instanceof ConditionedEvent) {
            return this._groupTimeConstraintEnvironmentClassContent((ConditionedEvent)first, tc);
        }
        if (first instanceof EventInterval) {
            return this._groupTimeConstraintEnvironmentClassContent((EventInterval)first, tc);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(first, tc).toString());
    }

    public CharSequence groupTimeConstraintClassContent(TimeConstraintExpression first, GroupTimeConstraint tc) {
        if (first instanceof ConditionedAbsenceOfEvent) {
            return this._groupTimeConstraintClassContent((ConditionedAbsenceOfEvent)first, tc);
        }
        if (first instanceof ConditionedEvent) {
            return this._groupTimeConstraintClassContent((ConditionedEvent)first, tc);
        }
        if (first instanceof EventInterval) {
            return this._groupTimeConstraintClassContent((EventInterval)first, tc);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(first, tc).toString());
    }

    public CharSequence stepToJava(SequenceElement s, List<Expression> conditions) {
        if (s instanceof ESDisjunction) {
            return this._stepToJava((ESDisjunction)s, conditions);
        }
        if (s instanceof EventSelector) {
            return this._stepToJava((EventSelector)s, conditions);
        }
        if (s instanceof Connector) {
            return this._stepToJava((Connector)s, conditions);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(s, conditions).toString());
    }

    public CharSequence formulaToJava(Formula f, List<Expression> conditions) {
        if (f instanceof BracketFormula) {
            return this._formulaToJava((BracketFormula)f, conditions);
        }
        if (f instanceof ConditionalFollow) {
            return this._formulaToJava((ConditionalFollow)f, conditions);
        }
        if (f instanceof Conjunction) {
            return this._formulaToJava((Conjunction)f, conditions);
        }
        if (f instanceof ConstraintSequence) {
            return this._formulaToJava((ConstraintSequence)f, conditions);
        }
        if (f instanceof Disjunction) {
            return this._formulaToJava((Disjunction)f, conditions);
        }
        if (f instanceof Implication) {
            return this._formulaToJava((Implication)f, conditions);
        }
        if (f instanceof NegationFormula) {
            return this._formulaToJava((NegationFormula)f, conditions);
        }
        if (f instanceof Sequence) {
            return this._formulaToJava((Sequence)f, conditions);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(f, conditions).toString());
    }

    public CharSequence generateEvent(EventPattern e) {
        if (e instanceof CommandEvent) {
            return this._generateEvent((CommandEvent)e);
        }
        if (e instanceof NotificationEvent) {
            return this._generateEvent((NotificationEvent)e);
        }
        if (e instanceof SignalEvent) {
            return this._generateEvent((SignalEvent)e);
        }
        if (e instanceof AnyEvent) {
            return this._generateEvent((AnyEvent)e);
        }
        if (e instanceof CommandReply) {
            return this._generateEvent((CommandReply)e);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e).toString());
    }

    public CharSequence dataSequenceStepToJava(DataConstraintStep s) {
        if (s instanceof DataConstraintEvent) {
            return this._dataSequenceStepToJava((DataConstraintEvent)s);
        }
        if (s instanceof DataConstraintUntilOperator) {
            return this._dataSequenceStepToJava((DataConstraintUntilOperator)s);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(s).toString());
    }
}

