/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClasspathElement;
import io.github.classgraph.Resource;
import io.github.classgraph.Scanner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandlerRegistry;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.concurrency.WorkQueue;
import nonapi.io.github.classgraph.fastzipfilereader.NestedJarHandler;
import nonapi.io.github.classgraph.fileslice.FileSlice;
import nonapi.io.github.classgraph.fileslice.reader.ClassfileReader;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.FastPathResolver;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.LogNode;
import nonapi.io.github.classgraph.utils.VersionFinder;

class ClasspathElementFileDir
extends ClasspathElement {
    private final File classpathEltDir;
    private final File packageRootDir;
    private final Set<String> scannedCanonicalPaths = new HashSet<String>();
    private final NestedJarHandler nestedJarHandler;

    ClasspathElementFileDir(File classpathEltDir, String packageRootPrefix, ClassLoader classLoader, NestedJarHandler nestedJarHandler, ScanSpec scanSpec) {
        super(classLoader, scanSpec);
        this.classpathEltDir = classpathEltDir;
        this.packageRootDir = new File(classpathEltDir, packageRootPrefix);
        this.nestedJarHandler = nestedJarHandler;
    }

    @Override
    void open(WorkQueue<Scanner.ClasspathEntryWorkUnit> workQueue, LogNode log) {
        if (!this.scanSpec.scanDirs) {
            if (log != null) {
                this.log(this.classpathElementIdx, "Skipping classpath element, since dir scanning is disabled: " + this.classpathEltDir, log);
            }
            this.skipClasspathElement = true;
            return;
        }
        try {
            int childClasspathEntryIdx = 0;
            for (String libDirPrefix : ClassLoaderHandlerRegistry.AUTOMATIC_LIB_DIR_PREFIXES) {
                Object[] listFiles;
                File libDir = new File(this.classpathEltDir, libDirPrefix);
                if (!FileUtils.canReadAndIsDir(libDir) || (listFiles = libDir.listFiles()) == null) continue;
                Arrays.sort(listFiles);
                for (Object file : listFiles) {
                    if (!((File)file).isFile() || !((File)file).getName().endsWith(".jar")) continue;
                    if (log != null) {
                        this.log(this.classpathElementIdx, "Found lib jar: " + file, log);
                    }
                    workQueue.addWorkUnit(new Scanner.ClasspathEntryWorkUnit(new ClasspathOrder.ClasspathElementAndClassLoader(((File)file).getPath(), this.classLoader), this, childClasspathEntryIdx++));
                }
            }
            if (this.packageRootDir.equals(this.classpathEltDir)) {
                for (String packageRootPrefix : ClassLoaderHandlerRegistry.AUTOMATIC_PACKAGE_ROOT_PREFIXES) {
                    File packageRoot = new File(this.classpathEltDir, packageRootPrefix);
                    if (!FileUtils.canReadAndIsDir(packageRoot)) continue;
                    if (log != null) {
                        this.log(this.classpathElementIdx, "Found package root: " + packageRoot, log);
                    }
                    workQueue.addWorkUnit(new Scanner.ClasspathEntryWorkUnit(new ClasspathOrder.ClasspathElementAndClassLoader(this.classpathEltDir, packageRootPrefix, this.classLoader), this, childClasspathEntryIdx++));
                }
            }
        }
        catch (SecurityException e) {
            if (log != null) {
                this.log(this.classpathElementIdx, "Skipping classpath element, since dir cannot be accessed: " + this.classpathEltDir, log);
            }
            this.skipClasspathElement = true;
            return;
        }
    }

    private Resource newResource(final String pathRelativeToPackageRoot, final File resourceFile, final NestedJarHandler nestedJarHandler) {
        return new Resource(this, resourceFile.length()){
            private FileSlice fileSlice;
            protected AtomicBoolean isOpen;
            {
                super(classpathElement, length);
                this.isOpen = new AtomicBoolean();
            }

            @Override
            public String getPath() {
                String path = FastPathResolver.resolve(pathRelativeToPackageRoot);
                while (path.startsWith("/")) {
                    path = path.substring(1);
                }
                return path;
            }

            @Override
            public String getPathRelativeToClasspathElement() {
                File resourceFile2 = new File(ClasspathElementFileDir.this.packageRootDir, pathRelativeToPackageRoot);
                String pathRelativeToClasspathElt = FastPathResolver.resolve(resourceFile2.getPath().substring(ClasspathElementFileDir.this.classpathEltDir.getPath().length()));
                while (pathRelativeToClasspathElt.startsWith("/")) {
                    pathRelativeToClasspathElt = pathRelativeToClasspathElt.substring(1);
                }
                return pathRelativeToClasspathElt;
            }

            @Override
            public long getLastModified() {
                return resourceFile.lastModified();
            }

            @Override
            public Set<PosixFilePermission> getPosixFilePermissions() {
                Set<PosixFilePermission> posixFilePermissions = null;
                try {
                    posixFilePermissions = Files.readAttributes(resourceFile.toPath(), PosixFileAttributes.class, new LinkOption[0]).permissions();
                }
                catch (IOException | SecurityException | UnsupportedOperationException exception) {
                    // empty catch block
                }
                return posixFilePermissions;
            }

            @Override
            public ByteBuffer read() throws IOException {
                if (ClasspathElementFileDir.this.skipClasspathElement) {
                    throw new IOException("Parent directory could not be opened");
                }
                if (this.isOpen.getAndSet(true)) {
                    throw new IOException("Resource is already open -- cannot open it again without first calling close()");
                }
                this.fileSlice = new FileSlice(resourceFile, nestedJarHandler, null);
                this.length = this.fileSlice.sliceLength;
                this.byteBuffer = this.fileSlice.read();
                return this.byteBuffer;
            }

            @Override
            ClassfileReader openClassfile() throws IOException {
                if (ClasspathElementFileDir.this.skipClasspathElement) {
                    throw new IOException("Parent directory could not be opened");
                }
                if (this.isOpen.getAndSet(true)) {
                    throw new IOException("Resource is already open -- cannot open it again without first calling close()");
                }
                this.fileSlice = new FileSlice(resourceFile, nestedJarHandler, null);
                this.length = this.fileSlice.sliceLength;
                return new ClassfileReader(this.fileSlice);
            }

            @Override
            public InputStream open() throws IOException {
                if (ClasspathElementFileDir.this.skipClasspathElement) {
                    throw new IOException("Parent directory could not be opened");
                }
                if (this.isOpen.getAndSet(true)) {
                    throw new IOException("Resource is already open -- cannot open it again without first calling close()");
                }
                this.fileSlice = new FileSlice(resourceFile, nestedJarHandler, null);
                this.inputStream = this.fileSlice.open(new Runnable(){

                    @Override
                    public void run() {
                        if (isOpen.getAndSet(false)) {
                            this.close();
                        }
                    }
                });
                this.length = this.fileSlice.sliceLength;
                return this.inputStream;
            }

            @Override
            public byte[] load() throws IOException {
                this.read();
                try (1 res = this;){
                    this.fileSlice = new FileSlice(resourceFile, nestedJarHandler, null);
                    byte[] bytes = this.fileSlice.load();
                    this.length = bytes.length;
                    byte[] byArray = bytes;
                    return byArray;
                }
            }

            @Override
            public void close() {
                super.close();
                if (this.isOpen.getAndSet(false)) {
                    if (this.byteBuffer != null) {
                        this.byteBuffer = null;
                    }
                    if (this.fileSlice != null) {
                        this.fileSlice.close();
                        nestedJarHandler.markSliceAsClosed(this.fileSlice);
                        this.fileSlice = null;
                    }
                }
            }
        };
    }

    @Override
    Resource getResource(String pathRelativeToPackageRoot) {
        File resourceFile = new File(this.packageRootDir, pathRelativeToPackageRoot);
        return FileUtils.canReadAndIsFile(resourceFile) ? this.newResource(pathRelativeToPackageRoot, resourceFile, this.nestedJarHandler) : null;
    }

    private void scanDirRecursively(File dir, LogNode log) {
        boolean isModularJar;
        String canonicalPath;
        if (this.skipClasspathElement) {
            return;
        }
        try {
            canonicalPath = dir.getCanonicalPath();
            if (!this.scannedCanonicalPaths.add(canonicalPath)) {
                if (log != null) {
                    log.log("Reached symlink cycle, stopping recursion: " + dir);
                }
                return;
            }
        }
        catch (IOException | SecurityException e) {
            if (log != null) {
                log.log("Could not canonicalize path: " + dir, e);
            }
            return;
        }
        String dirPath = dir.getPath();
        int ignorePrefixLen = this.packageRootDir.getPath().length() + 1;
        String dirRelativePath = ignorePrefixLen > dirPath.length() ? "/" : dirPath.substring(ignorePrefixLen).replace(File.separatorChar, '/') + "/";
        boolean isDefaultPackage = "/".equals(dirRelativePath);
        if (this.nestedClasspathRootPrefixes != null && this.nestedClasspathRootPrefixes.contains(dirRelativePath)) {
            if (log != null) {
                log.log("Reached nested classpath root, stopping recursion to avoid duplicate scanning: " + dirRelativePath);
            }
            return;
        }
        if (dirRelativePath.startsWith("META-INF/versions/")) {
            if (log != null) {
                log.log("Found unexpected nested versioned entry in directory classpath element -- skipping: " + dirRelativePath);
            }
            return;
        }
        this.checkResourcePathAcceptReject(dirRelativePath, log);
        if (this.skipClasspathElement) {
            return;
        }
        ScanSpec.ScanSpecPathMatch parentMatchStatus = this.scanSpec.dirAcceptMatchStatus(dirRelativePath);
        if (parentMatchStatus == ScanSpec.ScanSpecPathMatch.HAS_REJECTED_PATH_PREFIX) {
            if (log != null) {
                log.log("Reached rejected directory, stopping recursive scan: " + dirRelativePath);
            }
            return;
        }
        if (parentMatchStatus == ScanSpec.ScanSpecPathMatch.NOT_WITHIN_ACCEPTED_PATH) {
            return;
        }
        LogNode subLog = log == null ? null : log.log("1:" + canonicalPath, "Scanning directory: " + dir + (dir.getPath().equals(canonicalPath) ? "" : " ; canonical path: " + canonicalPath));
        Object[] filesInDir = dir.listFiles();
        if (filesInDir == null) {
            if (log != null) {
                log.log("Invalid directory " + dir);
            }
            return;
        }
        Arrays.sort(filesInDir);
        boolean bl = isModularJar = VersionFinder.JAVA_MAJOR_VERSION >= 9 && this.getModuleName() != null;
        if (parentMatchStatus != ScanSpec.ScanSpecPathMatch.ANCESTOR_OF_ACCEPTED_PATH) {
            for (Object fileInDir : filesInDir) {
                String fileInDirRelativePath;
                if (!((File)fileInDir).isFile()) continue;
                String string = fileInDirRelativePath = dirRelativePath.isEmpty() || isDefaultPackage ? ((File)fileInDir).getName() : dirRelativePath + ((File)fileInDir).getName();
                if (isModularJar && isDefaultPackage && fileInDirRelativePath.endsWith(".class") && !fileInDirRelativePath.equals("module-info.class")) continue;
                this.checkResourcePathAcceptReject(fileInDirRelativePath, subLog);
                if (this.skipClasspathElement) {
                    return;
                }
                if (parentMatchStatus == ScanSpec.ScanSpecPathMatch.HAS_ACCEPTED_PATH_PREFIX || parentMatchStatus == ScanSpec.ScanSpecPathMatch.AT_ACCEPTED_PATH || parentMatchStatus == ScanSpec.ScanSpecPathMatch.AT_ACCEPTED_CLASS_PACKAGE && this.scanSpec.classfileIsSpecificallyAccepted(fileInDirRelativePath)) {
                    Resource resource = this.newResource(fileInDirRelativePath, (File)fileInDir, this.nestedJarHandler);
                    this.addAcceptedResource(resource, parentMatchStatus, false, subLog);
                    this.fileToLastModified.put(fileInDir, ((File)fileInDir).lastModified());
                    continue;
                }
                if (subLog == null) continue;
                subLog.log("Skipping non-accepted file: " + fileInDirRelativePath);
            }
        } else if (this.scanSpec.enableClassInfo && dirRelativePath.equals("/")) {
            for (Object fileInDir : filesInDir) {
                if (!((File)fileInDir).getName().equals("module-info.class") || !((File)fileInDir).isFile()) continue;
                Resource resource = this.newResource("module-info.class", (File)fileInDir, this.nestedJarHandler);
                this.addAcceptedResource(resource, parentMatchStatus, true, subLog);
                this.fileToLastModified.put(fileInDir, ((File)fileInDir).lastModified());
                break;
            }
        }
        for (Object fileInDir : filesInDir) {
            if (!((File)fileInDir).isDirectory()) continue;
            this.scanDirRecursively((File)fileInDir, subLog);
            if (!this.skipClasspathElement) continue;
            if (subLog != null) {
                subLog.addElapsedTime();
            }
            return;
        }
        if (subLog != null) {
            subLog.addElapsedTime();
        }
        this.fileToLastModified.put(dir, dir.lastModified());
    }

    @Override
    void scanPaths(LogNode log) {
        if (this.skipClasspathElement) {
            return;
        }
        if (this.scanned.getAndSet(true)) {
            throw new IllegalArgumentException("Already scanned classpath element " + this);
        }
        LogNode subLog = log == null ? null : this.log(this.classpathElementIdx, "Scanning directory classpath element " + this.packageRootDir, log);
        this.scanDirRecursively(this.packageRootDir, subLog);
        this.finishScanPaths(subLog);
    }

    @Override
    public String getModuleName() {
        return this.moduleNameFromModuleDescriptor == null || this.moduleNameFromModuleDescriptor.isEmpty() ? null : this.moduleNameFromModuleDescriptor;
    }

    @Override
    public File getFile() {
        return this.classpathEltDir;
    }

    @Override
    URI getURI() {
        return this.packageRootDir.toURI();
    }

    @Override
    List<URI> getAllURIs() {
        return Collections.singletonList(this.getURI());
    }

    public String toString() {
        return this.packageRootDir.toString();
    }

    public int hashCode() {
        return Objects.hash(this.classpathEltDir, this.packageRootDir);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ClasspathElementFileDir)) {
            return false;
        }
        ClasspathElementFileDir other = (ClasspathElementFileDir)obj;
        return Objects.equals(this.classpathEltDir, other.classpathEltDir) && Objects.equals(this.packageRootDir, other.packageRootDir);
    }
}

