/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.model;

import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;
import org.eclipse.ui.internal.cheatsheets.composite.model.BlockedTaskFinder;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetSaveHelper;
import org.eclipse.ui.internal.cheatsheets.composite.model.EditableTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.TaskDependencies;
import org.eclipse.ui.internal.cheatsheets.composite.model.TaskGroup;
import org.eclipse.ui.internal.cheatsheets.data.ICheatSheet;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetManager;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheet;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheetTask;

public class CompositeCheatSheetModel
extends Observable
implements ICompositeCheatSheet,
ICheatSheet {
    private String name;
    private String description;
    private String explorerId;
    private ICompositeCheatSheetTask rootTask;
    private TaskDependencies dependencies;
    private String id;
    private CompositeCheatSheetSaveHelper saveHelper;
    private URL contentURL;
    private CheatSheetManager manager;
    private Set<ICompositeCheatSheetTask> stateChangedSet = new HashSet<ICompositeCheatSheetTask>();

    public void setRootTask(ICompositeCheatSheetTask task) {
        this.rootTask = task;
    }

    public CompositeCheatSheetModel(String name, String description, String explorerId) {
        this.name = name;
        this.description = description;
        this.explorerId = explorerId;
        this.dependencies = new TaskDependencies();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String getTaskExplorerId() {
        return this.explorerId;
    }

    @Override
    public ICompositeCheatSheetTask getRootTask() {
        return this.rootTask;
    }

    public void setDependencies(TaskDependencies dependencies) {
        this.dependencies = dependencies;
    }

    public TaskDependencies getDependencies() {
        return this.dependencies;
    }

    public URL getContentUrl() {
        return this.contentURL;
    }

    public void setContentUrl(URL newUrl) {
        this.contentURL = newUrl;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setSaveHelper(CompositeCheatSheetSaveHelper saveHelper) {
        this.saveHelper = saveHelper;
    }

    void stateChanged(ICompositeCheatSheetTask task) {
        if (!this.stateChangedSet.contains(task)) {
            this.stateChangedSet.add(task);
        }
    }

    public void sendTaskChangeEvents() {
        Set<ICompositeCheatSheetTask> blockedStateChanged = new BlockedTaskFinder().findBlockedTaskChanges(this.stateChangedSet);
        for (ICompositeCheatSheetTask iCompositeCheatSheetTask : this.stateChangedSet) {
            this.setChanged();
            this.notifyObservers(iCompositeCheatSheetTask);
        }
        for (ICompositeCheatSheetTask iCompositeCheatSheetTask : blockedStateChanged) {
            this.setChanged();
            this.notifyObservers(iCompositeCheatSheetTask);
        }
        this.stateChangedSet.clear();
    }

    public IMemento getTaskMemento(String id) {
        return this.saveHelper.getTaskMemento(id);
    }

    @Override
    public ICheatSheetManager getCheatSheetManager() {
        return this.manager;
    }

    public void setCheatSheetManager(CheatSheetManager manager) {
        this.manager = manager;
    }

    public void loadState(Map<String, String> layoutData) {
        this.saveHelper.loadCompositeState(this, layoutData);
    }

    private void resetTask(ICompositeCheatSheetTask task) {
        if (task instanceof EditableTask) {
            EditableTask editable = (EditableTask)task;
            editable.reset();
            if (this.saveHelper != null) {
                this.saveHelper.clearTaskMemento(task.getId());
            }
        } else if (task instanceof TaskGroup) {
            ICompositeCheatSheetTask[] subtasks;
            TaskGroup group = (TaskGroup)task;
            ICompositeCheatSheetTask[] iCompositeCheatSheetTaskArray = subtasks = group.getSubtasks();
            int n = subtasks.length;
            int n2 = 0;
            while (n2 < n) {
                ICompositeCheatSheetTask subtask = iCompositeCheatSheetTaskArray[n2];
                this.resetTask(subtask);
                ++n2;
            }
            group.setStateNoNotify(0);
        }
    }

    public void resetAllTasks(Map<String, String> cheatSheetData) {
        if (this.manager != null) {
            if (cheatSheetData == null) {
                this.manager.setData((Map<String, String>)new Hashtable<String, String>());
            } else {
                this.manager.setData(cheatSheetData);
            }
        }
        this.saveHelper.clearTaskMementos();
        this.resetTask(this.getRootTask());
        this.sendTaskChangeEvents();
    }

    public void resetTasks(ICompositeCheatSheetTask[] restartTasks) {
        ICompositeCheatSheetTask[] iCompositeCheatSheetTaskArray = restartTasks;
        int n = restartTasks.length;
        int n2 = 0;
        while (n2 < n) {
            ICompositeCheatSheetTask restartTask = iCompositeCheatSheetTaskArray[n2];
            this.resetTask(restartTask);
            ++n2;
        }
        this.sendTaskChangeEvents();
    }
}

