/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.comma.java.JDependencyInfo;
import org.eclipse.comma.java.impl.JDependencyInfoImpl;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class JDependencyInfos {
    public static Set<JDependencyInfo> getDependenciesFromDirectory(String directory) throws IOException {
        return JDependencyInfos.getDependenciesFromDirectory(new File(directory));
    }

    public static Set<JDependencyInfo> getDependenciesFromDirectory(File directory) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Stream<java.nio.file.Path> files = Files.walk(Paths.get(directory.getAbsolutePath(), new String[0]), new FileVisitOption[0]);){
            return files.filter(f -> f.toFile().isFile()).map(p -> new JDependencyInfoImpl(p.toFile())).collect(Collectors.toSet());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static JDependencyInfo getDependencyFromBundleId(String bundleId) throws IOException {
        return JDependencyInfos.create(Platform.getBundle((String)bundleId));
    }

    public static Set<JDependencyInfo> getDependencyFromBundleIdWithTransitiveDependencies(String bundleId) throws IOException {
        Bundle startBundle = Platform.getBundle((String)bundleId);
        HashSet bundles = new HashSet();
        AtomicReference<Consumer<Bundle>> reference = new AtomicReference<Consumer<Bundle>>();
        Consumer<Bundle> walkRecursive = bundle -> {
            if (!bundles.contains(bundle)) {
                bundles.add(bundle);
                BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
                for (BundleWire wire : wiring.getRequiredWires(null)) {
                    ((Consumer)reference.get()).accept(wire.getProviderWiring().getBundle());
                }
            }
        };
        reference.set(walkRecursive);
        walkRecursive.accept(startBundle);
        HashSet<JDependencyInfo> dependencyInfos = new HashSet<JDependencyInfo>();
        for (Bundle bundle2 : bundles) {
            dependencyInfos.add(JDependencyInfos.create(bundle2));
        }
        return dependencyInfos;
    }

    public static JDependencyInfo getDependencyFromBundle(String bundle, String path) throws IOException {
        return JDependencyInfos.getDependencyFromBundle(Platform.getBundle((String)bundle), new Path(path));
    }

    public static JDependencyInfo getDependencyFromBundle(Bundle bundle, Path path) throws IOException {
        URL jarUrl = FileLocator.find((Bundle)bundle, (IPath)path);
        if (jarUrl == null) {
            throw new IOException("No dependency found in bundle '" + bundle + "' at '" + path + "'");
        }
        URL jarFileUrl = FileLocator.toFileURL((URL)jarUrl);
        try {
            return JDependencyInfos.create(URIUtil.toFile((URI)URIUtil.toURI((URL)jarFileUrl)));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public static JDependencyInfo create(File jarFile) {
        return new JDependencyInfoImpl(jarFile);
    }

    public static JDependencyInfo create(Bundle bundle) throws IOException {
        File bundleFile = FileLocator.getBundleFile((Bundle)bundle);
        if (JDependencyInfos.isEclipseProject(bundleFile)) {
            return JDependencyInfos.create(new File(bundleFile, "target/classes"));
        }
        return JDependencyInfos.create(bundleFile);
    }

    public static List<String> toClasspathList(Collection<JDependencyInfo> dependencyInfos) {
        return dependencyInfos.stream().map(d -> d.getLocation().getAbsolutePath()).collect(Collectors.toList());
    }

    public static String toClasspath(Collection<JDependencyInfo> dependencyInfos) {
        return JDependencyInfos.toClasspathList(dependencyInfos).stream().collect(Collectors.joining(JDependencyInfos.getClasspathSeparator()));
    }

    static CharSequence getClasspathSeparator() {
        String val = System.getProperty("path.separator");
        if (val == null) {
            throw new IllegalArgumentException("system property 'path.seaprator' must not be null");
        }
        return val;
    }

    static boolean isEclipseProject(File bundleFile) {
        if (!bundleFile.isDirectory()) {
            return false;
        }
        if (!new File(bundleFile, "target/classes").exists()) {
            return false;
        }
        File pFile = new File(bundleFile, ".project");
        return pFile.exists() && pFile.isFile();
    }

    public static Map<JarEntry, InputStream> toJarEntries(JDependencyInfo dependencyInfo) throws IOException {
        HashMap<JarEntry, InputStream> entries = new HashMap<JarEntry, InputStream>();
        Pattern classesPattern = Pattern.compile("\\/target(\\/xtend)?\\/classes(\\d+)?\\/(.*)");
        Matcher classesMatcher = classesPattern.matcher(dependencyInfo.getLocation().getAbsolutePath().replace('\\', '/'));
        if (dependencyInfo.getLocation().isDirectory()) {
            for (JDependencyInfo dependency : JDependencyInfos.getDependenciesFromDirectory(dependencyInfo.getLocation())) {
                entries.putAll(JDependencyInfos.toJarEntries(dependency));
            }
        } else if (dependencyInfo.getLocation().getName().toLowerCase().endsWith(".jar")) {
            JarFile jar = new JarFile(dependencyInfo.getLocation());
            entries.putAll(JDependencyInfos.entriesFromJarRecursive(jar));
        } else if (classesMatcher.find()) {
            FileInputStream fis = new FileInputStream(dependencyInfo.getLocation());
            entries.put(new JarEntry(classesMatcher.group(3)), fis);
        }
        return entries;
    }

    private static HashMap<JarEntry, InputStream> entriesFromJarRecursive(JarFile jar) throws IOException {
        HashMap<JarEntry, InputStream> entries = new HashMap<JarEntry, InputStream>();
        Enumeration<JarEntry> enumerator = jar.entries();
        while (enumerator.hasMoreElements()) {
            JarEntry entry = enumerator.nextElement();
            if (entry.getName().toLowerCase().endsWith(".jar")) {
                File file = File.createTempFile(entry.getName(), "");
                Files.copy(jar.getInputStream(entry), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                entries.putAll(JDependencyInfos.entriesFromJarRecursive(new JarFile(file)));
                continue;
            }
            entries.put(entry, jar.getInputStream(entry));
        }
        return entries;
    }
}

