/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.generatortasks;

import java.io.InputStream;
import org.eclipse.comma.project.generatortasks.GeneratorTask;
import org.eclipse.comma.project.generatortasks.OutputLocator;
import org.eclipse.comma.project.generatortasks.restadapter.RESTTraceConverter;
import org.eclipse.comma.project.project.RESTTraceTask;
import org.eclipse.comma.types.generator.CommaFileSystemAccess;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class RESTTraceGeneratorTask
extends GeneratorTask {
    protected final RESTTraceTask task;
    protected final CommaFileSystemAccess traceFileSystemAccess;

    public RESTTraceGeneratorTask(RESTTraceTask task, IScopeProvider scopeProvider, OutputLocator outputLocator, IFileSystemAccess2 fsa) {
        super(task, scopeProvider, outputLocator, fsa);
        CommaFileSystemAccess _commaFileSystemAccess;
        this.task = task;
        this.traceFileSystemAccess = _commaFileSystemAccess = new CommaFileSystemAccess("trace/", fsa);
    }

    @Override
    protected void doGenerate() {
        block5: {
            try {
                String path = this.task.getFile();
                URI uri = URI.createURI((String)path).resolve(this.task.eResource().getURI());
                String fileName = uri.trimFileExtension().lastSegment();
                ResourceSet resourceSet = this.task.eResource().getResourceSet();
                InputStream inputStream = resourceSet.getURIConverter().createInputStream(uri);
                try {
                    this.traceFileSystemAccess.generateFile(String.valueOf(fileName) + ".jsonl", RESTTraceConverter.convertTrace(inputStream, this.task.getComponent(), this.task.getPathMappings()));
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception e = (Exception)_t;
                        this.errors.add(e.getMessage());
                        break block5;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }
}

