/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.test.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.test.actions.ActionsMessages;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.action.Action;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.unittest.model.ITestCaseElement;
import org.eclipse.unittest.model.ITestElement;
import org.eclipse.unittest.model.ITestSuiteElement;

public class OpenTestAction
extends Action {
    private static final String SPLITTER = "::";
    private static final String EMPTY_STRING = "";
    private ITestElement fTestElement;
    private Shell fShell;

    public OpenTestAction(Shell shell, ITestSuiteElement testSuite) {
        super(ActionsMessages.OpenEditorAction_action_label);
        this.fShell = shell;
        this.fTestElement = testSuite;
    }

    public OpenTestAction(Shell shell, ITestCaseElement testCase) {
        super(ActionsMessages.OpenEditorAction_action_label);
        this.fShell = shell;
        this.fTestElement = testCase;
    }

    public void run() {
        IProject project = this.getProject(this.fTestElement);
        if (project == null) {
            return;
        }
        List languageServers = LanguageServiceAccessor.getLanguageServers((IProject)project, capabilities -> Boolean.TRUE.equals(capabilities.getWorkspaceSymbolProvider()));
        if (languageServers != null && languageServers.isEmpty()) {
            return;
        }
        SymbolKind kind = this.fTestElement instanceof ITestCaseElement ? SymbolKind.Function : SymbolKind.Module;
        List<SymbolInformation> result = this.getQualifiedSymbols(languageServers, this.fTestElement.getTestName(), kind);
        if (result.isEmpty()) {
            return;
        }
        SymbolInformation symbolInformation = result.get(0);
        Location location = symbolInformation.getLocation();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        LSPEclipseUtils.openInEditor((Location)location, (IWorkbenchPage)page);
    }

    private IProject getProject(ITestElement element) {
        ILaunchConfiguration launchConfig;
        ILaunch launch = element.getTestRunSession().getLaunch();
        ILaunchConfiguration iLaunchConfiguration = launchConfig = launch != null ? launch.getLaunchConfiguration() : null;
        if (launchConfig == null) {
            return null;
        }
        try {
            String projectName = launchConfig.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", EMPTY_STRING);
            if (!projectName.isEmpty()) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                return project != null && project.exists() ? project : null;
            }
        }
        catch (CoreException e) {
            CorrosionPlugin.logError(e);
        }
        return null;
    }

    private List<SymbolInformation> getQualifiedSymbols(List<LanguageServer> languageServers, String path, SymbolKind kind) {
        ArrayList<SymbolInformation> result = new ArrayList<SymbolInformation>();
        String[] pathArray = path.split(SPLITTER);
        if (pathArray == null || pathArray.length < 1) {
            return null;
        }
        List<Object> parents = null;
        int i = 0;
        while (i < pathArray.length) {
            String name = pathArray[i];
            String parent = i > 0 ? pathArray[i - 1] : null;
            SymbolKind expectedKind = i < pathArray.length - 1 ? SymbolKind.Module : kind;
            List<SymbolInformation> symbols = this.getSymbols(languageServers, name, parent, expectedKind);
            List<Object> currents = new ArrayList();
            if (parents != null) {
                ArrayList<SymbolInformation> matches = new ArrayList<SymbolInformation>();
                block1: for (SymbolInformation info : symbols) {
                    for (SymbolInformation symbolInformation : parents) {
                        if (!this.isContainerOfSymbol(symbolInformation, info)) continue;
                        matches.add(info);
                        continue block1;
                    }
                }
                currents = matches;
            } else {
                currents = symbols;
            }
            if (currents.isEmpty()) {
                return result;
            }
            parents = currents;
            ++i;
        }
        return parents;
    }

    private List<SymbolInformation> getSymbols(List<LanguageServer> languageServers, String name, String parent, SymbolKind kind) {
        ArrayList<SymbolInformation> result = new ArrayList<SymbolInformation>();
        for (LanguageServer server : languageServers) {
            WorkspaceSymbolParams params = new WorkspaceSymbolParams(name);
            CompletableFuture symbols = server.getWorkspaceService().symbol(params);
            try {
                List items = (List)symbols.get(10L, TimeUnit.SECONDS);
                if (items == null) continue;
                for (Object item : items) {
                    SymbolInformation match = this.getMatchingItem(item, name, parent, kind);
                    if (match == null) continue;
                    result.add(match);
                }
            }
            catch (ExecutionException | TimeoutException e) {
                LanguageServerPlugin.logError((Throwable)e);
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError((Throwable)e);
            }
        }
        return result;
    }

    private SymbolInformation getMatchingItem(Object item, String name, String parent, SymbolKind kind) {
        String container;
        if (!(item instanceof SymbolInformation)) {
            return null;
        }
        SymbolInformation info = (SymbolInformation)item;
        if (info.getKind() != kind) {
            return null;
        }
        parent = parent != null ? parent.toLowerCase() : EMPTY_STRING;
        String string = container = info.getContainerName() != null ? info.getContainerName().toLowerCase() : EMPTY_STRING;
        if (!parent.equals(container)) {
            return null;
        }
        return info.getName().toLowerCase().equals(name.toLowerCase()) ? info : null;
    }

    private boolean isContainerOfSymbol(SymbolInformation container, SymbolInformation symbol) {
        if (container == null || symbol == null) {
            return false;
        }
        if (!container.getLocation().getUri().equals(symbol.getLocation().getUri())) {
            return false;
        }
        Range c = container.getLocation().getRange();
        Range s = symbol.getLocation().getRange();
        Position cp = c.getStart();
        Position sp = s.getStart();
        if (cp.getLine() > sp.getLine()) {
            return false;
        }
        return cp.getLine() != sp.getLine() || cp.getCharacter() <= sp.getCharacter();
    }
}

