/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.dialogs;

import com.ibm.icu.text.Collator;
import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.drivers.DriverMgmtMessages;
import org.eclipse.datatools.connectivity.drivers.DriverValidator;
import org.eclipse.datatools.connectivity.drivers.IDriverMgmtConstants;
import org.eclipse.datatools.connectivity.drivers.IDriverValuesProvider;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.PropertySetImpl;
import org.eclipse.datatools.connectivity.drivers.models.CategoryDescriptor;
import org.eclipse.datatools.connectivity.drivers.models.OverrideTemplateDescriptor;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.DriverPropertySourceProvider;
import org.eclipse.datatools.connectivity.internal.ui.DriverTreeFilter;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.AbstractInvertableTableSorter;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.CategoryDescriptorNameComparator;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.CategoryRoot;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.CategoryUtils;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.DriverTreeTableContentProvider;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.DriverTreeTableLabelProvider;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.TreeSortSelectionListener;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.help.IContext;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class DriverDialog
extends TitleAreaDialog {
    public static final String MEMENTO_ROOT = "Alt Drivers Definitions Driver_Dialog_Root";
    public static final String MEMENTO_DIALOG_SIZE_HEIGHT = "Dialog_Size_Height";
    public static final String MEMENTO_DIALOG_SIZE_WIDTH = "Dialog_Size_Width";
    private Text mDriverNameText;
    private Combo mTypeCombo;
    private Combo mVendorCombo;
    private TreeViewer mTreeViewer;
    private PageBook book = null;
    private List list;
    private Text mDriverTypeText;
    private Button mAddJar;
    private Button mEditJar;
    private Button mRemoveJar;
    private Button mClearAll;
    private Button mOKButton;
    private TemplateDescriptor descriptor = null;
    private IPropertySet mPropertySet = null;
    private IPropertySet mInitialPropertySet = null;
    private boolean hideDriverList = false;
    private DriverPropertySourceProvider mpsp = null;
    private static String ALL_STRING = DriverMgmtMessages.getString((String)"DriverDialog.AllFilter");
    private String mDriverName;
    private String mJarList;
    private boolean mInEdit = false;
    private boolean mIsEditable = true;
    private static String previouslyBrowsedDirectory = "";
    private DriverTreeFilter mViewerFilter;
    private DriverTreeFilter mTypeFilter;
    private DriverTreeFilter mVendorFilter;
    private TabItem generalTab;
    private TabItem jarListTab;
    private TabItem propertiesTab;
    private Composite generalComposite;
    private Composite jarListComposite;
    private Composite propertiesComposite;
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName());
    private ChangeListener psetChangedListener = new ChangeListener(){

        public void stateChanged(ChangeEvent arg0) {
            boolean flag = DriverDialog.this.isValid(true);
            DriverDialog.this.validateName();
            if (DriverDialog.this.mOKButton != null && !DriverDialog.this.mOKButton.isDisposed()) {
                DriverDialog.this.mOKButton.setEnabled(flag);
            }
        }
    };

    public void setIsEditable(boolean flag) {
        this.mIsEditable = flag;
    }

    public void setEditMode(boolean flag) {
        this.mInEdit = flag;
    }

    public DriverDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x860);
    }

    public DriverDialog(Shell parentShell, String category) {
        this(parentShell);
        if (CategoryDescriptor.getCategoryDescriptor((String)category) != null) {
            this.mViewerFilter = new DriverTreeFilter();
            this.mViewerFilter.setCategoryId(category);
        }
    }

    private void handleSelection() {
        if (this.mTreeViewer != null && !this.mTreeViewer.getTree().isDisposed()) {
            this.mTreeViewer.getTree().setRedraw(false);
        }
        if (this.mTypeFilter != null && this.mTreeViewer != null) {
            this.mTreeViewer.removeFilter((ViewerFilter)this.mTypeFilter);
        }
        this.mVendorCombo.removeAll();
        if (this.mTypeCombo.getSelectionIndex() > -1) {
            this.mVendorCombo.setEnabled(true);
            String selectedText = this.mTypeCombo.getText();
            if (selectedText.trim().length() > 0) {
                CategoryDescriptor[] kids = null;
                if (this.mTypeCombo.getData(selectedText) instanceof CategoryDescriptor) {
                    CategoryDescriptor cd = (CategoryDescriptor)this.mTypeCombo.getData(selectedText);
                    kids = CategoryUtils.getOrderedChildCategories(cd.getId());
                    if (cd != null && this.mTreeViewer != null) {
                        this.mTypeFilter = new DriverTreeFilter();
                        this.mTypeFilter.setCategoryId(cd.getId());
                        this.mTreeViewer.addFilter((ViewerFilter)this.mTypeFilter);
                        this.mTreeViewer.refresh();
                        this.mTreeViewer.expandToLevel(2);
                    }
                } else if (this.mTypeCombo.getData(selectedText) instanceof CategoryDescriptor[]) {
                    kids = (CategoryDescriptor[])this.mTypeCombo.getData(selectedText);
                    Arrays.sort(kids, new CategoryDescriptorNameComparator());
                    this.mTreeViewer.expandToLevel(2);
                }
                if (kids != null && !selectedText.equals(ALL_STRING)) {
                    this.mVendorCombo.add(ALL_STRING);
                    int j = 0;
                    while (j < kids.length) {
                        this.mVendorCombo.add(kids[j].getName());
                        this.mVendorCombo.setData(kids[j].getName(), (Object)kids[j]);
                        ++j;
                    }
                    if (this.mVendorCombo.getItemCount() == 0) {
                        this.mVendorCombo.setEnabled(false);
                    }
                } else {
                    this.mVendorCombo.add(ALL_STRING);
                    int j = 0;
                    while (j < kids.length) {
                        CategoryDescriptor[] details = CategoryUtils.getOrderedChildCategories(kids[j].getId());
                        if (details != null && details.length > 0) {
                            int i = 0;
                            while (i < details.length) {
                                this.mVendorCombo.add(details[i].getName());
                                this.mVendorCombo.setData(details[i].getName(), (Object)details[i]);
                                ++i;
                            }
                        }
                        ++j;
                    }
                    if (this.mVendorCombo.getItemCount() == 0) {
                        this.mVendorCombo.setEnabled(false);
                    }
                }
                this.mVendorCombo.select(0);
            }
        } else {
            this.mVendorCombo.setEnabled(false);
        }
        if (this.mTreeViewer != null && !this.mTreeViewer.getTree().isDisposed()) {
            this.mTreeViewer.getTree().setRedraw(true);
        }
    }

    private void handleVendorSelected() {
        String selText;
        CategoryDescriptor cd;
        if (this.mTreeViewer != null && !this.mTreeViewer.getTree().isDisposed()) {
            this.mTreeViewer.getTree().setRedraw(false);
        }
        if (this.mVendorFilter != null && this.mTreeViewer != null) {
            this.mTreeViewer.removeFilter((ViewerFilter)this.mVendorFilter);
        }
        if (this.mTreeViewer != null && this.mVendorCombo != null && this.mVendorCombo.getText().trim().length() > 0 && (cd = (CategoryDescriptor)this.mVendorCombo.getData(selText = this.mVendorCombo.getText().trim())) != null) {
            this.mVendorFilter = new DriverTreeFilter();
            this.mVendorFilter.setCategoryId(cd.getId());
            this.mTreeViewer.addFilter((ViewerFilter)this.mVendorFilter);
            this.mTreeViewer.refresh();
            this.mTreeViewer.expandToLevel(2);
        }
        if (this.mTreeViewer != null && !this.mTreeViewer.getTree().isDisposed()) {
            this.mTreeViewer.getTree().setRedraw(true);
        }
    }

    private void processEnabledStateForComposite(Composite parent, boolean enabled) {
        if (parent != null && parent.equals(this.jarListComposite)) {
            parent.setEnabled(enabled);
            this.mAddJar.setEnabled(enabled);
            this.mEditJar.setEnabled(enabled);
            this.mClearAll.setEnabled(enabled);
            this.mRemoveJar.setEnabled(enabled);
        } else if (parent != null && parent.equals(this.propertiesComposite)) {
            parent.setEnabled(enabled);
            this.book.setEnabled(enabled);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        if (!this.mInEdit) {
            HelpUtil.setHelp((Control)this.getShell(), (String)HelpUtil.getContextId((String)"CONTEXT_ID_NEW_DRIVER_DIALOG", (String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName()));
        } else {
            HelpUtil.setHelp((Control)this.getShell(), (String)HelpUtil.getContextId((String)"CONTEXT_ID_EDIT_DRIVER_DIALOG", (String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName()));
        }
        Composite area = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(area, 0);
        contents.setLayout((Layout)new GridLayout());
        contents.setLayoutData((Object)new GridData(1808));
        contents.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
            }
        });
        TabFolder baseComposite = new TabFolder(contents, 128);
        baseComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.generalTab = new TabItem(baseComposite, 0);
        this.generalTab.setText(DriverMgmtMessages.getString((String)"DriverDialog.Name.Type.Tab"));
        this.jarListTab = new TabItem(baseComposite, 0);
        this.jarListTab.setText(DriverMgmtMessages.getString((String)"DriverDialog.JarList.Tab"));
        this.propertiesTab = new TabItem(baseComposite, 0);
        this.propertiesTab.setText(DriverMgmtMessages.getString((String)"DriverDialog.Properties.Tab"));
        this.generalComposite = new Composite((Composite)baseComposite, 0);
        GridLayout layout = new GridLayout();
        this.generalComposite.setLayout((Layout)layout);
        this.generalTab.setControl((Control)this.generalComposite);
        this.jarListComposite = new Composite((Composite)baseComposite, 0);
        GridLayout jl_layout = new GridLayout();
        this.jarListComposite.setLayout((Layout)jl_layout);
        this.jarListTab.setControl((Control)this.jarListComposite);
        this.propertiesComposite = new Composite((Composite)baseComposite, 0);
        GridLayout p_layout = new GridLayout();
        this.propertiesComposite.setLayout((Layout)p_layout);
        this.propertiesTab.setControl((Control)this.propertiesComposite);
        if (!this.mInEdit && !this.hideDriverList) {
            Composite comboComposite = null;
            CategoryDescriptor[] roots = CategoryUtils.getOrderedRootCategories();
            if (this.mViewerFilter != null) {
                roots = new CategoryDescriptor[]{this.mViewerFilter.getCategoryDescriptor()};
            }
            if (roots != null && roots.length > 1) {
                if (comboComposite == null) {
                    comboComposite = this.createComboComposite(this.generalComposite);
                }
                Label tlabel = new Label(comboComposite, 16384);
                tlabel.setText(DriverMgmtMessages.getString((String)"DriverDialog.DriverTypeFilter"));
                tlabel.setLayoutData((Object)new GridData());
                this.mTypeCombo = new Combo(comboComposite, 2056);
                this.mTypeCombo.setLayoutData((Object)new GridData(4, 0, true, false));
                this.mTypeCombo.add(ALL_STRING);
                this.mTypeCombo.setData(ALL_STRING, (Object)roots);
                int i = 0;
                while (i < roots.length) {
                    this.mTypeCombo.add(roots[i].getName());
                    this.mTypeCombo.setData(roots[i].getName(), (Object)roots[i]);
                    ++i;
                }
                this.mTypeCombo.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                        DriverDialog.this.handleSelection();
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.widgetDefaultSelected(e);
                    }
                });
            }
            if (roots[0] == null || roots[0].getParent() == null || roots[0].getParent().getParent() != null) {
                if (comboComposite == null) {
                    comboComposite = this.createComboComposite(this.generalComposite);
                }
                Label vLabel = new Label(comboComposite, 16384);
                vLabel.setText(DriverMgmtMessages.getString((String)"DriverDialog.VendorFilter"));
                vLabel.setLayoutData((Object)new GridData());
                this.mVendorCombo = new Combo(comboComposite, 2056);
                this.mVendorCombo.setLayoutData((Object)new GridData(4, 0, true, false));
                this.mVendorCombo.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                        DriverDialog.this.handleVendorSelected();
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.widgetDefaultSelected(e);
                    }
                });
                this.mVendorCombo.setEnabled(this.mIsEditable);
                if (roots != null && roots.length == 1 && roots[0] != null) {
                    CategoryDescriptor[] children = CategoryUtils.getOrderedChildCategories(roots[0].getId());
                    if (children != null && children.length > 0) {
                        this.mVendorCombo.add(ALL_STRING);
                        int i = 0;
                        while (i < children.length) {
                            this.mVendorCombo.add(children[i].getName());
                            this.mVendorCombo.setData(children[i].getName(), (Object)children[i]);
                            ++i;
                        }
                    } else if (this.mIsEditable) {
                        this.mVendorCombo.setEnabled(false);
                    }
                }
            }
            Label label = new Label(this.generalComposite, 16384);
            label.setText(DriverMgmtMessages.getString((String)"NewDriverDialog.label.availableTemplates"));
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            data.horizontalSpan = 2;
            label.setLayoutData((Object)data);
            this.mTreeViewer = new TreeViewer(this.generalComposite, 68352);
            this.mTreeViewer.setContentProvider((IContentProvider)new DriverTreeTableContentProvider());
            this.mTreeViewer.setLabelProvider((IBaseLabelProvider)new DriverTreeTableLabelProvider());
            this.mTreeViewer.setSorter(new ViewerSorter());
            GridData tvGD = new GridData(4, 4, true, true);
            this.mTreeViewer.getTree().setLayoutData((Object)tvGD);
            this.mTreeViewer.getTree().setHeaderVisible(true);
            if (this.mViewerFilter != null) {
                this.mTreeViewer.addFilter((ViewerFilter)this.mViewerFilter);
            }
            TreeSortSelectionListener tssl1 = DriverDialog.createTableColumn(this.mTreeViewer, DriverMgmtMessages.getString((String)"DriverDialog.NameColumn"), DriverMgmtMessages.getString((String)"DriverDialog.DriverNameColumn"), new TextSorter(0), 128, false);
            tssl1.getColumn().setWidth(200);
            tssl1.getColumn().setResizable(true);
            tssl1.chooseColumnForSorting();
            TreeSortSelectionListener tssl2 = DriverDialog.createTableColumn(this.mTreeViewer, DriverMgmtMessages.getString((String)"DriverDialog.VendorColumn"), DriverMgmtMessages.getString((String)"DriverDialog.DriverVendorColumn"), new TextSorter(1), 128, true);
            tssl2.getColumn().setWidth(200);
            tssl2.getColumn().setResizable(true);
            TreeSortSelectionListener tssl3 = DriverDialog.createTableColumn(this.mTreeViewer, DriverMgmtMessages.getString((String)"DriverDialog.Version"), DriverMgmtMessages.getString((String)"DriverDialog.DriverVersionColumn"), new TextSorter(2), 128, false);
            tssl3.getColumn().setWidth(100);
            tssl3.getColumn().setResizable(true);
            this.mTreeViewer.setInput((Object)new CategoryRoot());
            this.mTreeViewer.expandToLevel(2);
            this.mTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    DriverDialog.this.setErrorMessage(null);
                    StructuredSelection selection = (StructuredSelection)DriverDialog.this.mTreeViewer.getSelection();
                    if (selection.getFirstElement() instanceof TemplateDescriptor) {
                        TemplateDescriptor descriptor = (TemplateDescriptor)selection.getFirstElement();
                        if (DriverDialog.this.descriptor != null && DriverDialog.this.descriptor.equals((Object)descriptor)) {
                            return;
                        }
                        DriverDialog.this.updateFromDescriptor(descriptor);
                        DriverDialog.this.mDriverNameText.setEnabled(true);
                    } else if (selection.getFirstElement() instanceof CategoryDescriptor) {
                        DriverDialog.this.updateFromDescriptor(null);
                        DriverDialog.this.mDriverNameText.setEnabled(false);
                    }
                }
            });
            this.mTreeViewer.getTree().setEnabled(this.mIsEditable);
        }
        Label label = new Label(this.generalComposite, 0);
        label.setText(DriverMgmtMessages.getString((String)"NewDriverDialog.label.driverNameText"));
        this.mDriverNameText = new Text(this.generalComposite, 2048);
        this.mDriverNameText.setLayoutData((Object)new GridData(768));
        this.mDriverNameText.setEnabled(this.mIsEditable);
        this.mDriverNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DriverDialog.this.mDriverName = DriverDialog.this.mDriverNameText.getText();
                DriverDialog.this.validateName();
            }
        });
        Label label2 = new Label(this.generalComposite, 0);
        label2.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.label.driverTypeText"));
        this.mDriverTypeText = new Text(this.generalComposite, 2056);
        this.mDriverTypeText.setLayoutData((Object)new GridData(768));
        Composite composite_1 = new Composite(this.jarListComposite, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalIndent = -5;
        gridData.horizontalSpan = 2;
        composite_1.setLayoutData((Object)gridData);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 3;
        composite_1.setLayout((Layout)gridLayout_1);
        Label label1 = new Label(composite_1, 0);
        label1.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.label.driverFileList"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label1.setLayoutData((Object)gridData);
        this.list = new List(composite_1, 2816);
        GridData gridData_1 = new GridData(1808);
        gridData_1.verticalSpan = 4;
        gridData_1.horizontalSpan = 2;
        this.list.setLayoutData((Object)gridData_1);
        this.list.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = DriverDialog.this.list.getSelectionCount() > 0;
                DriverDialog.this.mEditJar.setEnabled(enabled);
                DriverDialog.this.mRemoveJar.setEnabled(enabled);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.list.setEnabled(this.mIsEditable);
        this.mAddJar = new Button(composite_1, 0);
        this.mAddJar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverDialog.this.handleLocationBrowseButtonPressed();
                DriverDialog.this.updateJarList();
            }
        });
        this.mAddJar.setLayoutData((Object)new GridData(256));
        this.mAddJar.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.button.addJar"));
        this.mAddJar.setEnabled(this.mIsEditable);
        this.mEditJar = new Button(composite_1, 0);
        this.mEditJar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DriverDialog.this.list.getSelectionCount() > 0) {
                    String selectedItem = DriverDialog.this.list.getItem(DriverDialog.this.list.getSelectionIndex());
                    DriverDialog.this.handleLocationEditButtonPressed(selectedItem);
                    DriverDialog.this.updateJarList();
                }
            }
        });
        this.mEditJar.setLayoutData((Object)new GridData(256));
        this.mEditJar.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.button.editJar"));
        this.mEditJar.setEnabled(this.mIsEditable);
        this.mRemoveJar = new Button(composite_1, 0);
        this.mRemoveJar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DriverDialog.this.list.getSelectionCount() > 0) {
                    String[] selected = DriverDialog.this.list.getSelection();
                    int selIndex = DriverDialog.this.list.getSelectionIndex();
                    int i = 0;
                    while (i < selected.length) {
                        DriverDialog.this.list.remove(selected[i]);
                        ++i;
                    }
                    if (selIndex < DriverDialog.this.list.getItemCount() && selIndex > -1) {
                        DriverDialog.this.list.setSelection(selIndex);
                    } else if (selIndex - 1 > -1) {
                        if (DriverDialog.this.list.getItem(--selIndex) != null) {
                            DriverDialog.this.list.setSelection(selIndex);
                        }
                    } else {
                        DriverDialog.this.mEditJar.setEnabled(false);
                        DriverDialog.this.mRemoveJar.setEnabled(false);
                    }
                    DriverDialog.this.updateJarList();
                }
            }
        });
        this.mRemoveJar.setLayoutData((Object)new GridData(256));
        this.mRemoveJar.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.button.removeJar"));
        this.mRemoveJar.setEnabled(this.mIsEditable);
        this.mClearAll = new Button(composite_1, 0);
        this.mClearAll.setLayoutData((Object)new GridData(258));
        this.mClearAll.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.button.clearAllJars"));
        this.mClearAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverDialog.this.list.removeAll();
                DriverDialog.this.updateJarList();
            }
        });
        this.mClearAll.setEnabled(this.mIsEditable);
        Composite composite_2 = new Composite(this.propertiesComposite, 0);
        gridData = new GridData(1808);
        gridData.horizontalIndent = -5;
        gridData.horizontalSpan = 2;
        composite_2.setLayoutData((Object)gridData);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 1;
        composite_2.setLayout((Layout)gridLayout_2);
        Label label3 = new Label(composite_2, 0);
        label3.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.label.properties"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label3.setLayoutData((Object)gridData);
        this.book = new PageBook(composite_2, 2048);
        this.book.setLayoutData((Object)new GridData(1808));
        PropertySheetPage page = new PropertySheetPage();
        page.createControl((Composite)this.book);
        if (this.mpsp != null) {
            this.mpsp.removeChangeListener(this.psetChangedListener);
        }
        this.mpsp = null;
        this.mpsp = this.mPropertySet != null ? new DriverPropertySourceProvider(this.mPropertySet, this.descriptor) : new DriverPropertySourceProvider();
        this.mpsp.addChangeListener(this.psetChangedListener);
        page.setPropertySourceProvider((IPropertySourceProvider)this.mpsp);
        this.book.showPage(page.getControl());
        if (this.mPropertySet != null) {
            page.selectionChanged(null, (ISelection)new StructuredSelection((Object)this.mPropertySet));
        }
        this.book.setEnabled(this.mIsEditable);
        this.mDriverNameText.setEnabled(false);
        if (this.mTypeCombo != null) {
            if (this.mTypeFilter != null && this.mTreeViewer != null) {
                this.mTreeViewer.addFilter((ViewerFilter)this.mTypeFilter);
                this.mTypeCombo.setText(this.mTypeFilter.getCategoryDescriptor().getName());
            } else {
                this.mTypeCombo.select(0);
            }
            this.handleSelection();
        }
        if (this.mVendorCombo != null && this.mVendorCombo.getItemCount() > 0) {
            if (this.mVendorFilter != null && this.mTreeViewer != null) {
                this.mTreeViewer.addFilter((ViewerFilter)this.mVendorFilter);
                this.mVendorCombo.setText(this.mVendorFilter.getCategoryDescriptor().getName());
            } else {
                this.mVendorCombo.select(0);
            }
            this.handleVendorSelected();
        }
        if (!this.mInEdit) {
            this.setTitle(DriverMgmtMessages.getString((String)"NewDriverDialog.title"));
            this.setMessage(DriverMgmtMessages.getString((String)"DriverDialog.DialogMessage"));
            if (this.descriptor != null) {
                this.mDriverName = this.descriptor.getName();
            }
            String quickName = DriverMgmtMessages.format((String)"DriverDialog.quickdriver.name", (Object[])new String[]{this.mDriverName});
            if (this.descriptor != null && this.mTreeViewer != null) {
                this.mTreeViewer.setSelection((ISelection)new StructuredSelection((Object)this.descriptor), true);
                this.mDriverName = quickName;
                this.mDriverNameText.setText(this.mDriverName);
            } else if (this.descriptor != null) {
                this.updateFromDescriptor(this.descriptor);
                this.mDriverName = quickName;
                this.mDriverNameText.setText(this.mDriverName);
            }
            this.processEnabledStateForComposite(this.jarListComposite, false);
            this.processEnabledStateForComposite(this.propertiesComposite, false);
        } else {
            DriverInstance di = new DriverInstance(this.mInitialPropertySet);
            if (di != null) {
                this.mPropertySet = di.getPropertySet();
                this.descriptor = di.getTemplate();
                this.updateFromPropertySet();
                this.updatePropertyDescriptors();
            }
            this.setTitle(DriverMgmtMessages.getString((String)"EditDriverDialog.title"));
            this.setMessage(DriverMgmtMessages.getString((String)"DriverDialog.EditDriver.message"));
        }
        return area;
    }

    protected Control createContents(Composite parent) {
        Control dialogComposite = super.createContents(parent);
        if (this.mOKButton != null || this.mOKButton != null && !this.mIsEditable) {
            this.mOKButton.setEnabled(false);
        }
        return dialogComposite;
    }

    private Composite createComboComposite(Composite parent) {
        Composite comboComposite = new Composite(parent, 0);
        comboComposite.setLayout((Layout)new GridLayout(2, false));
        GridData CCdata = new GridData();
        CCdata.horizontalAlignment = 4;
        CCdata.horizontalSpan = 2;
        comboComposite.setLayoutData((Object)CCdata);
        return comboComposite;
    }

    public static TreeSortSelectionListener createTableColumn(TreeViewer viewer, String text, String tooltip, AbstractInvertableTableSorter sorter, int initialDirection, boolean keepDirection) {
        TreeColumn column = new TreeColumn(viewer.getTree(), 16384);
        column.setText(text);
        column.setToolTipText(tooltip);
        return new TreeSortSelectionListener(viewer, column, sorter, initialDirection, keepDirection);
    }

    protected IPage createDefaultPage(PageBook book) {
        PropertySheetPage page = new PropertySheetPage();
        page.createControl((Composite)book);
        return page;
    }

    private boolean isValid() {
        return this.isValid(false);
    }

    private boolean isValid(boolean inflag) {
        IPropertySet testSet = null;
        if (inflag && this.mPropertySet != null) {
            testSet = this.mPropertySet;
        } else if (this.descriptor != null) {
            testSet = this.createTestPSet();
        }
        if (testSet != null) {
            boolean flag;
            block13: {
                DriverValidator testValidator = new DriverValidator(this.descriptor, testSet);
                flag = testValidator.isValid(false);
                if (!flag) {
                    try {
                        this.setErrorMessage(testValidator.getMessage());
                        return flag;
                    }
                    catch (SWTException e) {
                        if (e.code != 24) {
                            throw e;
                        }
                        break block13;
                    }
                }
                try {
                    this.setErrorMessage(null);
                    return flag;
                }
                catch (SWTException e) {
                    if (e.code == 24) break block13;
                    throw e;
                }
            }
            if (this.mOKButton != null && !this.mOKButton.isDisposed()) {
                this.mOKButton.setEnabled(flag);
            }
        } else {
            if (this.mOKButton != null && !this.mOKButton.isDisposed()) {
                this.mOKButton.setEnabled(false);
            }
            return false;
        }
        return true;
    }

    private IPropertySet createTestPSet() {
        String propIdPrefix = DriverMgmtMessages.getString((String)"EditDriverDialog.text.id_test_prefix");
        String propId = String.valueOf(propIdPrefix) + this.mDriverName;
        IPropertySet testPropertySet = DriverManager.getInstance().createDefaultInstance(this.descriptor.getId());
        testPropertySet.setID(propId);
        Properties props = testPropertySet.getBaseProperties();
        if (props.getProperty("jarList") != null) {
            String jarlist = props.getProperty("jarList");
            this.mJarList = jarlist.trim();
        }
        testPropertySet.setName(this.mDriverName);
        props = new Properties();
        if (this.mJarList == null) {
            String jarList;
            this.mJarList = jarList = DriverManager.getInstance().updatePluginJarList(this.descriptor);
        }
        props.setProperty("jarList", this.mJarList);
        IConfigurationElement[] templateprops = this.descriptor.getProperties();
        if (templateprops != null && templateprops.length > 0) {
            int i = 0;
            while (i < templateprops.length) {
                String overrideValsPropValue;
                String valsPropValue;
                IConfigurationElement prop = templateprops[i];
                String propid = prop.getAttribute("id");
                String propvalue = prop.getAttribute("value");
                IDriverValuesProvider driverValsProvider = null;
                IDriverValuesProvider overrideDriverValsProvider = null;
                OverrideTemplateDescriptor[] otds = null;
                if (this.descriptor != null) {
                    otds = OverrideTemplateDescriptor.getByDriverTemplate((String)this.descriptor.getId());
                    if (otds != null && otds.length > 0) {
                        overrideDriverValsProvider = otds[0].getValuesProviderClass();
                    }
                    driverValsProvider = this.descriptor.getValuesProviderClass();
                }
                boolean removeIt = false;
                if (driverValsProvider != null && (valsPropValue = driverValsProvider.createDefaultValue(propid)) != null) {
                    propvalue = valsPropValue;
                }
                if (overrideDriverValsProvider != null && (overrideValsPropValue = overrideDriverValsProvider.createDefaultValue(propid)) != null) {
                    propvalue = overrideValsPropValue;
                }
                if (otds != null && otds.length > 0) {
                    String temp = otds[0].getPropertyValueFromId(propid);
                    if (temp != null && temp.length() > 0) {
                        propvalue = temp;
                    }
                    if (otds[0].getPropertyRemoveFlagFromID(propid)) {
                        removeIt = true;
                    }
                }
                if (this.mPropertySet != null && this.mPropertySet.getBaseProperties() != null) {
                    propvalue = this.mPropertySet.getBaseProperties().getProperty(propid);
                }
                if (propvalue == null) {
                    if (!removeIt) {
                        props.setProperty(propid, propvalue == null ? new String() : propvalue);
                    } else {
                        props.remove(propid);
                    }
                }
                if (propvalue == null) {
                    propvalue = "";
                }
                props.setProperty(propid, propvalue);
                ++i;
            }
        }
        props.setProperty("org.eclipse.datatools.connectivity.drivers.defnType", this.descriptor.getId());
        testPropertySet.setBaseProperties(props);
        return testPropertySet;
    }

    public IPropertySet getPropertySet() {
        return this.mPropertySet;
    }

    public IPropertySet getInitialPropertySet() {
        return this.mInitialPropertySet;
    }

    private void validateName() {
        DriverInstance obj;
        boolean isOk = false;
        String testName = "";
        if (this.mDriverName != null) {
            testName = this.mDriverName.trim();
        } else if (this.mDriverName == null) {
            return;
        }
        if (testName.trim().length() == 0 && this.mPropertySet != null) {
            String errorMessage = DriverMgmtMessages.getString((String)"DriverValidator.msg.empty_name");
            this.setErrorMessage(errorMessage);
            return;
        }
        if (this.mPropertySet != null) {
            this.mPropertySet.getID();
        }
        if ((obj = DriverManager.getInstance().getDriverInstanceByName(testName)) != null) {
            if (!this.mInEdit) {
                String errorMessage = DriverMgmtMessages.getString((String)"NewDriverDialog.driverExistsWithName");
                try {
                    this.setErrorMessage(errorMessage);
                }
                catch (SWTException sWTException) {}
                return;
            }
            isOk = true;
        } else if (obj == null) {
            isOk = true;
        }
        if (isOk && this.mTreeViewer != null && this.descriptor == null) {
            StructuredSelection selection = (StructuredSelection)this.mTreeViewer.getSelection();
            if (selection != null && selection.getFirstElement() instanceof TemplateDescriptor) {
                TemplateDescriptor descriptor;
                this.descriptor = descriptor = (TemplateDescriptor)selection.getFirstElement();
            }
            isOk = this.isValid(true);
        } else if (this.descriptor != null) {
            isOk = this.isValid(true);
        }
        if (this.mOKButton != null && !this.mOKButton.isDisposed()) {
            this.mOKButton.setEnabled(isOk);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.mOKButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public void setPropertySet(IPropertySet propset) {
        this.mPropertySet = propset;
        this.mInitialPropertySet = this.DuplicatePropertySet(propset);
    }

    public void setInitialTemplate(String templateID) {
        TemplateDescriptor td = TemplateDescriptor.getDriverTemplateDescriptor((String)templateID);
        if (td != null) {
            this.descriptor = td;
        }
    }

    private IPropertySet DuplicatePropertySet(IPropertySet pset) {
        PropertySetImpl newPset = new PropertySetImpl(pset.getName(), pset.getID());
        if (pset.getBaseProperties().size() > 0) {
            Properties newProps = new Properties();
            newPset.setBaseProperties(newProps);
            newPset.getBaseProperties().putAll((Map<?, ?>)pset.getBaseProperties());
        }
        return newPset;
    }

    private void handleLocationBrowseButtonPressed() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.title.filebrowse"));
        String dirName = previouslyBrowsedDirectory;
        if (dirName.length() == 0) {
            dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            } else {
                dialog.setFilterPath(new Path(System.getProperty("user.home")).toOSString());
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            previouslyBrowsedDirectory = new Path(selectedDirectory).removeLastSegments(1).toOSString();
            this.list.add(selectedDirectory);
        }
    }

    private void updateJarList() {
        this.mJarList = this.createList(this.list.getItems());
        if (this.mPropertySet != null) {
            this.mPropertySet.getBaseProperties().setProperty("jarList", this.mJarList);
        }
        this.validateName();
        this.updatePropertyDescriptors();
        if (this.mJarList.trim().length() > 0) {
            this.mClearAll.setEnabled(true);
        } else {
            this.mClearAll.setEnabled(false);
        }
    }

    private String createList(String[] items) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                buffer.append(items[i]);
                if (i + 1 < items.length) {
                    buffer.append(IDriverMgmtConstants.PATH_DELIMITER);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    private void updatePropertyDescriptors() {
        PropertySheetPage page = new PropertySheetPage();
        page.createControl((Composite)this.book);
        DriverPropertySourceProvider mpsp = null;
        mpsp = this.mPropertySet != null && this.descriptor != null ? new DriverPropertySourceProvider(this.mPropertySet, this.descriptor) : new DriverPropertySourceProvider();
        page.setPropertySourceProvider((IPropertySourceProvider)mpsp);
        this.book.showPage(page.getControl());
        if (this.mPropertySet != null) {
            page.selectionChanged(null, (ISelection)new StructuredSelection((Object)this.mPropertySet));
        }
    }

    private void updateFromDescriptor(TemplateDescriptor descriptor) {
        if (descriptor != null) {
            this.descriptor = descriptor;
            this.processEnabledStateForComposite(this.jarListComposite, true);
            this.processEnabledStateForComposite(this.propertiesComposite, true);
            this.mDriverTypeText.setText(this.descriptor.getName());
            this.mPropertySet = null;
            this.mJarList = null;
            this.list.removeAll();
            if (!this.mInEdit) {
                this.mPropertySet = this.createTestPSet();
                this.mPropertySet.setName(descriptor.getName());
            }
            this.updateFromPropertySet();
            this.updatePropertyDescriptors();
            this.validateName();
            boolean isOk = this.isValid();
            if (this.mOKButton != null) {
                this.mOKButton.setEnabled(isOk);
            }
        } else {
            this.descriptor = null;
            this.mPropertySet = null;
            this.mJarList = null;
            this.mDriverName = "";
            this.mDriverTypeText.setText("");
            this.mDriverNameText.setText("");
            this.list.removeAll();
            this.updateJarList();
            this.updateFromPropertySet();
            this.updatePropertyDescriptors();
            this.validateName();
            boolean isOk = this.isValid();
            if (this.mOKButton != null) {
                this.mOKButton.setEnabled(isOk);
            }
        }
    }

    private void updateFromPropertySet() {
        if (this.descriptor != null) {
            this.mDriverTypeText.setText(this.descriptor.getName());
            if (this.descriptor.getJarList() != null && this.descriptor.getJarList().length() > 0) {
                String[] jarListArray = this.parseString(this.descriptor.getJarList());
                this.list.removeAll();
                int i = 0;
                while (i < jarListArray.length) {
                    this.list.add(jarListArray[i]);
                    ++i;
                }
            }
        }
        if (this.mIsEditable) {
            this.mAddJar.setEnabled(true);
            this.mEditJar.setEnabled(false);
            this.mRemoveJar.setEnabled(false);
            this.mClearAll.setEnabled(false);
        }
        if (this.mPropertySet != null) {
            String jarList;
            this.mDriverNameText.setText(this.mPropertySet.getName());
            this.mDriverName = this.mPropertySet.getName();
            this.mJarList = jarList = this.mPropertySet.getBaseProperties().getProperty("jarList");
            String[] jarListArray = this.parseString(jarList);
            this.list.removeAll();
            int i = 0;
            while (i < jarListArray.length) {
                this.list.add(jarListArray[i]);
                ++i;
            }
            if (jarList != null && jarList.trim().length() > 0 && this.mIsEditable) {
                this.mClearAll.setEnabled(true);
            }
        } else {
            this.mAddJar.setEnabled(false);
        }
        this.isValid(true);
        if (this.mPropertySet != null) {
            this.validateName();
        }
    }

    private String[] parseString(String str_list) {
        StringTokenizer tk = new StringTokenizer(str_list, IDriverMgmtConstants.PATH_DELIMITER);
        String[] pieces = new String[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            pieces[index++] = tk.nextToken();
        }
        return pieces;
    }

    private void handleLocationEditButtonPressed(String editLocation) {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.title.filebrowse"));
        String dirName = editLocation;
        dialog.setFileName(dirName);
        if (dirName.length() == 0) {
            dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            } else {
                dialog.setFilterPath(dirName);
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            previouslyBrowsedDirectory = new Path(selectedDirectory).removeLastSegments(1).toOSString();
            this.list.remove(editLocation);
            this.list.add(selectedDirectory);
            if (this.list.getItemCount() > 1 && MessageDialog.openQuestion((Shell)this.getShell(), (String)DriverMgmtMessages.getString((String)"EditDriverDialog.msg.updateAllJarsToSamePath.title"), (String)DriverMgmtMessages.getString((String)"EditDriverDialog.msg.updateAllJarsToSamePath.message"))) {
                int location;
                String[] items = this.list.getItems();
                String separator = "\\";
                if (selectedDirectory.indexOf("/") > -1) {
                    separator = "/";
                }
                if ((location = selectedDirectory.lastIndexOf(separator)) > -1 && location < selectedDirectory.length() - 1) {
                    String path = selectedDirectory.substring(0, location);
                    int i = 0;
                    while (i < items.length) {
                        String directory = items[i];
                        if (!directory.equals(selectedDirectory)) {
                            int location2 = directory.lastIndexOf(separator);
                            String filename = directory;
                            if (location2 > -1 && location2 < directory.length() - 1) {
                                filename = directory.substring(location2 + 1, directory.length());
                            }
                            String newdirectory = String.valueOf(path) + separator + filename;
                            this.list.remove(directory);
                            this.list.add(newdirectory);
                        }
                        ++i;
                    }
                }
            }
        }
    }

    protected void okPressed() {
        Properties props;
        block9: {
            if (!this.mInEdit && this.descriptor != null) {
                String propId = String.valueOf(DriverMgmtMessages.getString((String)"NewDriverDialog.text.id_prefix")) + this.mDriverName;
                if (this.mPropertySet == null) {
                    DriverInstance newDriver = DriverManager.getInstance().createNewDriverInstance(this.descriptor.getId(), this.mDriverName.trim(), null);
                    this.mPropertySet = newDriver.getPropertySet();
                }
                this.mPropertySet.setID(propId);
            }
            String propIdPrefix = DriverMgmtMessages.getString((String)"EditDriverDialog.text.id_prefix");
            String propId = String.valueOf(propIdPrefix) + this.descriptor.getId() + "." + this.mDriverName;
            if (this.mPropertySet == null) {
                this.mPropertySet = new PropertySetImpl(propId, this.mDriverName);
            } else {
                this.mPropertySet.setID(propId);
            }
            this.mPropertySet.setName(this.mDriverName);
            props = new Properties();
            props.setProperty("jarList", this.mJarList);
            IConfigurationElement[] templateprops = this.descriptor.getProperties();
            if (templateprops == null || templateprops.length <= 0) break block9;
            int i = 0;
            while (i < templateprops.length) {
                block11: {
                    String value;
                    String id;
                    block10: {
                        IConfigurationElement prop = templateprops[i];
                        id = prop.getAttribute("id");
                        value = this.mPropertySet.getBaseProperties().getProperty(id);
                        if (value != null) break block10;
                        value = prop.getAttribute("value");
                        OverrideTemplateDescriptor[] otds = OverrideTemplateDescriptor.getByDriverTemplate((String)this.descriptor.getId());
                        if (otds == null || otds.length <= 0) break block10;
                        boolean removetemp = otds[0].getPropertyRemoveFlagFromID(id);
                        if (removetemp) break block11;
                        String valuetemp = otds[0].getPropertyValueFromId(id);
                        if (valuetemp != null && valuetemp.length() > 0) {
                            value = valuetemp;
                        }
                    }
                    props.setProperty(id, value);
                }
                ++i;
            }
        }
        props.setProperty("org.eclipse.datatools.connectivity.drivers.defnType", this.descriptor.getId());
        this.mPropertySet.setBaseProperties(props);
        this.psetChangedListener = null;
        this.saveState();
        super.okPressed();
    }

    public IPropertySet getSelectedDefinition() {
        return this.mPropertySet;
    }

    public void setHideDriverList(boolean flag) {
        this.hideDriverList = flag;
    }

    public boolean getHideDriverList() {
        return this.hideDriverList;
    }

    protected void configureShell(Shell newShell) {
        IDialogSettings dSection;
        super.configureShell(newShell);
        int width = 600;
        int height = 500;
        if (!this.mInEdit) {
            newShell.setText(DriverMgmtMessages.getString((String)"NewDriverDialog.windowTitle"));
        } else {
            newShell.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.windowTitle"));
        }
        IDialogSettings dset = ConnectivityUIPlugin.getDefault().getDialogSettings();
        if (dset != null && (dSection = dset.getSection(MEMENTO_ROOT)) != null && dSection.get(MEMENTO_DIALOG_SIZE_HEIGHT) != null && dSection.get(MEMENTO_DIALOG_SIZE_HEIGHT).trim().length() > 0) {
            height = dSection.getInt(MEMENTO_DIALOG_SIZE_HEIGHT);
            width = dSection.getInt(MEMENTO_DIALOG_SIZE_WIDTH);
        }
        newShell.setSize(width, height);
        this.centerDialog(newShell);
    }

    private void centerDialog(Shell newShell) {
        Composite parent = newShell.getParent();
        Rectangle parentSize = parent.getBounds();
        Rectangle newShellSize = newShell.getBounds();
        int x = (parentSize.width - newShellSize.width) / 2 + parentSize.x;
        int y = (parentSize.height - newShellSize.height) / 2 + parentSize.y;
        newShell.setLocation(new Point(x, y));
    }

    private void saveState() {
        IDialogSettings dset = ConnectivityUIPlugin.getDefault().getDialogSettings();
        if (dset != null) {
            IDialogSettings dSection = dset.getSection(MEMENTO_ROOT);
            if (dSection == null) {
                dSection = dset.addNewSection(MEMENTO_ROOT);
            }
            if (dSection != null) {
                Point size = this.getShell().getSize();
                dSection.put(MEMENTO_DIALOG_SIZE_HEIGHT, size.y);
                dSection.put(MEMENTO_DIALOG_SIZE_WIDTH, size.x);
            }
        }
    }

    public void setVendorFilter(DriverTreeFilter filter) {
        this.mViewerFilter = filter;
    }

    public void setTypeFilter(DriverTreeFilter filter) {
        this.mTypeFilter = filter;
    }

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Shell shell = this.getShell();
        Rectangle boundsRect = shell.getBounds();
        int dialogWidth = boundsRect.width;
        int preferredMsgAreaWidth = this.getPreferredMessageAreaWidth();
        int preferredDialogWidth = preferredMsgAreaWidth + 20;
        if (dialogWidth < preferredDialogWidth) {
            Rectangle newBoundsRect = new Rectangle(boundsRect.x, boundsRect.y, preferredDialogWidth, boundsRect.height);
            Rectangle constrainedBoundsRect = this.getConstrainedShellBounds(newBoundsRect);
            shell.setBounds(constrainedBoundsRect);
        }
    }

    private int getPreferredMessageAreaWidth() {
        int msgWidth = 0;
        Control dialogArea = this.getDialogArea();
        if (dialogArea != null) {
            GC gc = new GC((Drawable)dialogArea);
            String dialogMessage = DriverMgmtMessages.getString((String)"DriverDialog.DialogMessage");
            Point strExtent = gc.stringExtent(dialogMessage);
            int strWidth = strExtent.x;
            gc.dispose();
            msgWidth = strWidth / 2 + 100;
        }
        return msgWidth;
    }

    private class TextSorter
    extends AbstractInvertableTableSorter {
        private int mColumn = -1;

        public TextSorter(int column) {
            this.mColumn = column;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            String name1;
            TreeViewer tv;
            if (viewer instanceof TreeViewer && (tv = (TreeViewer)viewer).getLabelProvider() instanceof DriverTreeTableLabelProvider) {
                DriverTreeTableLabelProvider dtlp = (DriverTreeTableLabelProvider)tv.getLabelProvider();
                String text1 = dtlp.getColumnText(e1, this.mColumn);
                String text2 = dtlp.getColumnText(e2, this.mColumn);
                return Collator.getInstance().compare(text1, text2);
            }
            if (e1 instanceof CategoryDescriptor && e2 instanceof CategoryDescriptor) {
                name1 = ((CategoryDescriptor)e1).getName();
                String name2 = ((CategoryDescriptor)e2).getName();
                return Collator.getInstance().compare(name1, name2);
            }
            if (e1 instanceof TemplateDescriptor && e2 instanceof TemplateDescriptor) {
                name1 = ((TemplateDescriptor)e1).getName();
                String name2 = ((TemplateDescriptor)e2).getName();
                return Collator.getInstance().compare(name1, name2);
            }
            return Collator.getInstance().compare((String)e1, (String)e2);
        }
    }
}

