/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.ui;

import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.internal.core.IResultManager;
import org.eclipse.datatools.sqltools.result.internal.ui.PreferenceConstants;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultsView;
import org.eclipse.datatools.sqltools.result.internal.utils.ILogger;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.ui.ResultsViewUIPlugin;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class ResultsViewUIAccessor {
    private static ILogger _log = ResultsViewUIPlugin.getLogger(null);
    private IResultManager _manager = ResultsViewUIPlugin.getResultManager();
    private IWorkbenchPage _activePage;
    private ResultsView _resultsView;
    private static ResultsViewUIAccessor _instance;
    private Object _syncMonitor = new Object();
    public static final int STATUS_TAB = 1;
    public static final int PARAM_TAB = 2;
    public static final int MESSAGE_TAB = 3;
    public static final int RESULT_TAB = 4;

    private ResultsViewUIAccessor() {
    }

    public static synchronized ResultsViewUIAccessor getInstance() {
        if (_instance == null) {
            _instance = new ResultsViewUIAccessor();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showTab(OperationCommand cmd, final int tabType) {
        this.checkResultsView();
        Object object = this._syncMonitor;
        synchronized (object) {
            if (this._resultsView == null) {
                return;
            }
            if (cmd == null) {
                return;
            }
            IResultInstance instance = this._manager.getInstance(cmd);
            if (instance != null) {
                if (instance != this._resultsView.getCurrentInstance()) {
                    return;
                }
                final ResultsView view = this._resultsView;
                this._resultsView.getResultSection().getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        view.getResultSection().showTab(tabType);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showTab(OperationCommand cmd, final int tabType, final int tabNum) {
        this.checkResultsView();
        Object object = this._syncMonitor;
        synchronized (object) {
            if (this._resultsView == null) {
                return;
            }
            if (cmd == null) {
                return;
            }
            if (tabType != 4 && tabType != 3) {
                return;
            }
            IResultInstance instance = this._manager.getInstance(cmd);
            if (instance != null) {
                if (instance != this._resultsView.getCurrentInstance()) {
                    return;
                }
                final ResultsView view = this._resultsView;
                this._resultsView.getResultSection().getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        view.getResultSection().showTab(tabType, tabNum);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showTab(OperationCommand cmd, final IResultSetObject result) {
        this.checkResultsView();
        Object object = this._syncMonitor;
        synchronized (object) {
            if (this._resultsView == null) {
                return;
            }
            if (cmd == null || result == null) {
                return;
            }
            IResultInstance instance = this._manager.getInstance(cmd);
            if (instance != null) {
                if (instance != this._resultsView.getCurrentInstance()) {
                    return;
                }
                final ResultsView view = this._resultsView;
                this._resultsView.getResultSection().getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        view.getResultSection().showResultSet(result);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount(OperationCommand cmd) {
        this.checkResultsView();
        Object object = this._syncMonitor;
        synchronized (object) {
            try {
                if (this._resultsView == null) {
                    return -1;
                }
                if (cmd == null) {
                    return -1;
                }
                IResultInstance instance = this._manager.getInstance(cmd);
                if (instance != null) {
                    if (instance != this._resultsView.getCurrentInstance()) {
                        return -1;
                    }
                    return this._resultsView.getResultSection().getRowCount();
                }
            }
            finally {
                Throwable throwable;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkResultsView() {
        Object object = this._syncMonitor;
        synchronized (object) {
            int i;
            this._resultsView = null;
            IWorkbenchWindow activeWindow = ResultsViewUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            if (activeWindow == null) {
                IWorkbenchWindow[] windows = ResultsViewUIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
                i = 0;
                while (i < windows.length) {
                    activeWindow = windows[0];
                    if (activeWindow != null) break;
                    ++i;
                }
                if (activeWindow == null) {
                    return;
                }
            }
            this._activePage = activeWindow.getActivePage();
            if (this._activePage == null) {
                IWorkbenchPage[] pages = activeWindow.getPages();
                i = 0;
                while (i < pages.length) {
                    this._activePage = pages[0];
                    if (this._activePage != null) break;
                    ++i;
                }
                if (this._activePage == null) {
                    return;
                }
            }
            activeWindow.getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    try {
                        IViewPart view = ResultsViewUIAccessor.this._activePage.showView("org.eclipse.datatools.sqltools.result.resultView", null, 2);
                        if (view instanceof ResultsView) {
                            ResultsViewUIAccessor.this._resultsView = (ResultsView)view;
                        }
                    }
                    catch (PartInitException ex) {
                        _log.error("ResultsViewAPI_checkview_error", (Throwable)ex);
                    }
                }
            });
        }
    }

    public int getMaxLengthToShowEllipses() {
        return ResultsViewUIPlugin.getDefault().getPreferenceStore().getInt(PreferenceConstants.ELLIPSIS_ENABLED_VALUE_LENGTH);
    }
}

