/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.actions;

import java.io.File;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileMgmt;
import org.eclipse.datatools.connectivity.internal.security.ICipherProvider;
import org.eclipse.datatools.connectivity.internal.security.SecurityManager;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ExportProfilesDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExportProfileViewAction
extends Action
implements IHandler,
IViewActionDelegate {
    private transient ListenerList listenerList = null;
    protected boolean isCompleted = false;
    private Shell shell;

    public ExportProfileViewAction() {
        this.setText(ConnectivityUIPlugin.getDefault().getResourceString("ServersView.action.exportCPs"));
    }

    public final void addHandlerListener(IHandlerListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new ListenerList(1);
        }
        this.listenerList.add((Object)listener);
    }

    public final void dispose() {
        this.listenerList = null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part == null && this.shell == null) {
            return null;
        }
        if (part instanceof IViewPart) {
            this.init((IViewPart)part);
        }
        this.isCompleted = false;
        ExportProfilesDialog dlg = this.createExportProfilesDialog(this.shell);
        int ret = dlg.open();
        if (ret == 0) {
            BusyIndicator.showWhile((Display)this.shell.getDisplay(), (Runnable)this.createSaveExportedProfilesRunnable(this.shell, dlg));
        }
        this.fireHandlerChanged(new HandlerEvent((IHandler)this, false, false));
        return null;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
        if (this.listenerList != null) {
            this.listenerList.remove((Object)handlerListener);
            if (this.listenerList.isEmpty()) {
                this.listenerList = null;
            }
        }
    }

    public void init(IViewPart view) {
        this.shell = view.getSite().getShell();
    }

    protected void init(Shell parentShell) {
        this.shell = parentShell;
    }

    public void run() {
        try {
            this.execute(new ExecutionEvent());
        }
        catch (ExecutionException executionException) {}
    }

    protected ExportProfilesDialog createExportProfilesDialog(Shell parentShell) {
        return new ExportProfilesDialog(parentShell);
    }

    protected Runnable createSaveExportedProfilesRunnable(final Shell parentShell, final ExportProfilesDialog dlg) {
        return new Runnable(){

            public void run() {
                ExportProfileViewAction.this.isCompleted = false;
                try {
                    ICipherProvider isp = null;
                    if (dlg.needEncryption()) {
                        isp = SecurityManager.getInstance().getDefaultCipherProvider();
                    }
                    ConnectionProfileMgmt.saveCPs((IConnectionProfile[])dlg.getSelectedProfiles(), (File)dlg.getFile(), (ICipherProvider)isp);
                    ExportProfileViewAction.this.isCompleted = true;
                }
                catch (Exception e) {
                    ExceptionHandler.showException(parentShell, ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), e.getMessage(), e);
                }
            }
        };
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected void fireHandlerChanged(HandlerEvent handlerEvent) {
        if (handlerEvent == null) {
            throw new NullPointerException();
        }
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IHandlerListener listener = (IHandlerListener)listeners[i];
            listener.handlerChanged(handlerEvent);
            ++i;
        }
    }
}

