/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.util.Logger;
import org.eclipse.emf.diffmerge.ui.ComparisonContextManager;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.log.DiffMergeLogger;
import org.eclipse.emf.diffmerge.ui.util.DifferenceKind;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class EMFDiffMergeUIPlugin
extends AbstractUIPlugin {
    public static final String UI_DIFF_DATA_FILE_EXTENSION = "diffuidata";
    private static final String ICON_PATH = "icons/full/";
    public static final String LABEL = Messages.EMFDiffMergeUIPlugin_Label;
    private static EMFDiffMergeUIPlugin plugin;
    private final ComparisonContextManager _comparisonContextManager;
    private final DiffMergeLogger _diffMergeLogger = new DiffMergeLogger();
    private final EReference _ownershipFeature;
    private Color _veryDarkGray;

    public EMFDiffMergeUIPlugin() {
        this._comparisonContextManager = new ComparisonContextManager();
        this._ownershipFeature = EcoreFactory.eINSTANCE.createEReference();
        this._ownershipFeature.setName("container");
        this._ownershipFeature.setEType((EClassifier)EcorePackage.eINSTANCE.getEObject());
        this._ownershipFeature.setLowerBound(0);
        this._ownershipFeature.setUpperBound(1);
        this._veryDarkGray = null;
    }

    public ComparisonContextManager getContextManager() {
        return this._comparisonContextManager;
    }

    public static EMFDiffMergeUIPlugin getDefault() {
        return plugin;
    }

    public Color getDifferenceColor(DifferenceColorKind colorKind_p) {
        int colorCode;
        switch (colorKind_p) {
            case LEFT: {
                colorCode = 4;
                break;
            }
            case RIGHT: {
                colorCode = 9;
                break;
            }
            case BOTH: {
                colorCode = 12;
                break;
            }
            case NONE: {
                colorCode = 15;
                break;
            }
            case CONFLICT: {
                colorCode = 3;
                break;
            }
            default: {
                colorCode = 2;
            }
        }
        return UIUtil.getColor(colorCode);
    }

    public DifferenceColorKind getDifferenceColorKind(DifferenceKind originKind_p) {
        DifferenceColorKind result;
        if (originKind_p == null) {
            result = DifferenceColorKind.DEFAULT;
        } else {
            switch (originKind_p) {
                case NONE: {
                    result = DifferenceColorKind.NONE;
                    break;
                }
                case CONFLICT: {
                    result = DifferenceColorKind.CONFLICT;
                    break;
                }
                case FROM_BOTH: 
                case MODIFIED: {
                    result = DifferenceColorKind.BOTH;
                    break;
                }
                case FROM_LEFT: 
                case FROM_LEFT_ADD: 
                case FROM_RIGHT_DEL: {
                    result = DifferenceColorKind.LEFT;
                    break;
                }
                case FROM_LEFT_DEL: 
                case FROM_RIGHT: 
                case FROM_RIGHT_ADD: {
                    result = DifferenceColorKind.RIGHT;
                    break;
                }
                default: {
                    result = DifferenceColorKind.DEFAULT;
                }
            }
        }
        return result;
    }

    public ImageID getDifferenceOverlay(DifferenceKind originKind_p) {
        ImageID result;
        switch (originKind_p) {
            case FROM_LEFT: {
                result = ImageID.OUT_STAT;
                break;
            }
            case FROM_LEFT_ADD: {
                result = ImageID.OUT_ADD_STAT;
                break;
            }
            case FROM_LEFT_DEL: {
                result = ImageID.OUT_REM_STAT;
                break;
            }
            case FROM_RIGHT: {
                result = ImageID.INC_STAT;
                break;
            }
            case FROM_RIGHT_ADD: {
                result = ImageID.INC_ADD_STAT;
                break;
            }
            case FROM_RIGHT_DEL: {
                result = ImageID.INC_REM_STAT;
                break;
            }
            case FROM_BOTH: 
            case MODIFIED: {
                result = ImageID.MODIFIED_STAT;
                break;
            }
            case CONFLICT: {
                result = ImageID.CONFLICT_STAT;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public String getDifferencePrefix(DifferenceKind originKind_p) {
        String result;
        switch (originKind_p) {
            case FROM_LEFT: {
                result = "\ufffd\ufffd ";
                break;
            }
            case FROM_LEFT_ADD: {
                result = "+\ufffd ";
                break;
            }
            case FROM_LEFT_DEL: {
                result = "-\ufffd ";
                break;
            }
            case FROM_RIGHT: {
                result = "\ufffd\ufffd ";
                break;
            }
            case FROM_RIGHT_ADD: {
                result = "\ufffd+ ";
                break;
            }
            case FROM_RIGHT_DEL: {
                result = "\ufffd- ";
                break;
            }
            case CONFLICT: {
                result = "! ";
                break;
            }
            case FROM_BOTH: {
                result = "\ufffd\ufffd ";
                break;
            }
            case MODIFIED: {
                result = "\ufffd\ufffd ";
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    public Logger getDiffMergeLogger() {
        return this._diffMergeLogger;
    }

    public Image getImage(ImageID id_p) {
        Image result = null;
        switch (id_p) {
            case DELETE: {
                result = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
                break;
            }
            case LEFT: {
                result = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_BACK");
                break;
            }
            case REDO: {
                result = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_REDO");
                break;
            }
            case RIGHT: {
                result = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_FORWARD");
                break;
            }
            case SHOW: {
                result = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
                break;
            }
            case UNDO: {
                result = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_UNDO");
                break;
            }
            default: {
                result = this.getImageRegistry().get(id_p.name());
            }
        }
        return result;
    }

    public ImageDescriptor getImageDescriptor(ImageID id_p) {
        ImageDescriptor result = null;
        switch (id_p) {
            case DELETE: {
                result = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE");
                break;
            }
            case LEFT: {
                result = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK");
                break;
            }
            case REDO: {
                result = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_REDO");
                break;
            }
            case RIGHT: {
                result = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD");
                break;
            }
            case SHOW: {
                result = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK");
                break;
            }
            case UNDO: {
                result = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_UNDO");
                break;
            }
            default: {
                result = this.getImageRegistry().getDescriptor(id_p.name());
            }
        }
        return result;
    }

    public EReference getOwnershipFeature() {
        return this._ownershipFeature;
    }

    public String getPluginId() {
        return this.getBundle().getSymbolicName();
    }

    public Color getVeryDarkGray() {
        if (this._veryDarkGray == null) {
            this._veryDarkGray = new Color((Device)Display.getDefault(), 75, 75, 75);
        }
        return this._veryDarkGray;
    }

    private ImageDescriptor registerLocalIcon(ImageID imageID_p) {
        ImageDescriptor result = null;
        String path = ICON_PATH + imageID_p.name().toLowerCase() + ".gif";
        try {
            result = ImageDescriptor.createFromURL((URL)FileLocator.toFileURL((URL)this.getBundle().getEntry(path)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (result != null) {
            this.getImageRegistry().put(imageID_p.name(), result);
        }
        return result;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.getImageRegistry().put(ImageID.UP.name(), CompareUI.DESC_CTOOL_PREV);
        this.getImageRegistry().put(ImageID.DOWN.name(), CompareUI.DESC_CTOOL_NEXT);
        HashSet<ImageID> toRegister = new HashSet<ImageID>(Arrays.asList(ImageID.values()));
        toRegister.removeAll(Arrays.asList(ImageID.DELETE, ImageID.LEFT, ImageID.REDO, ImageID.RIGHT, ImageID.SHOW, ImageID.UNDO, ImageID.DOWN, ImageID.UP));
        for (ImageID imageId : toRegister) {
            this.registerLocalIcon(imageId);
        }
    }

    public void stop(BundleContext context) throws Exception {
        this._diffMergeLogger.close();
        if (this._veryDarkGray != null) {
            this._veryDarkGray.dispose();
        }
        plugin = null;
        super.stop(context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DifferenceColorKind {
        LEFT,
        RIGHT,
        BOTH,
        NONE,
        CONFLICT,
        DEFAULT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageID {
        CHECKIN_ACTION,
        CHECKOUT_ACTION,
        COLLAPSEALL,
        CONFLICT_STAT,
        CONTAINER,
        DELETE,
        DONE,
        DOWN,
        EMPTY,
        EXPANDALL,
        INC_STAT,
        INC_ADD_STAT,
        INC_REM_STAT,
        LEFT,
        LOCK,
        MODIFIED_STAT,
        NEXT_CHANGE_NAV,
        NEXT_DIFF_NAV,
        OUT_STAT,
        OUT_ADD_STAT,
        OUT_REM_STAT,
        PLUS,
        PREV_CHANGE_NAV,
        PREV_DIFF_NAV,
        REDO,
        RIGHT,
        SHOW,
        SORT,
        SWAP,
        SYNCED,
        UNDO,
        UP,
        VIEW_MENU;

    }
}

