/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.util;

import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalCommandStack;

public final class MiscUtil {
    public static String buildString(Object ... objects_p) {
        StringBuilder builder = new StringBuilder();
        Object[] objectArray = objects_p;
        int n = objects_p.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object != null) {
                builder.append(object);
            }
            ++n2;
        }
        return builder.toString();
    }

    public static void executeOnDomain(EditingDomain domain_p, String label_p, final Runnable runnable_p) {
        String commandLabel = label_p != null ? label_p : Messages.MiscUtil_DefaultCommandName;
        ChangeCommand cmd = new ChangeCommand((Notifier)domain_p.getResourceSet(), commandLabel){
            {
                super($anonymous0);
                this.label = string;
            }

            protected void doExecute() {
                runnable_p.run();
            }
        };
        domain_p.getCommandStack().execute((Command)cmd);
    }

    public static void executeAndForget(EditingDomain domain_p, Runnable runnable_p) {
        ForgettingCommand cmd = new ForgettingCommand(runnable_p);
        CommandStack cStack = domain_p.getCommandStack();
        if (cStack instanceof TransactionalCommandStack) {
            try {
                ((TransactionalCommandStack)cStack).execute((Command)cmd, Collections.singletonMap("no_undo", Boolean.TRUE));
            }
            catch (Exception exception) {}
        } else {
            cStack.execute((Command)cmd);
        }
    }

    public static IFile getFileFor(Resource resource_p, boolean allowExternal_p) {
        IFile result = null;
        URI uri = resource_p.getURI();
        IWorkspace wk = ResourcesPlugin.getWorkspace();
        if (wk != null && wk.getRoot() != null) {
            if (uri != null && uri.isPlatformResource()) {
                String platformResourcePath = uri.toPlatformString(true);
                result = wk.getRoot().getFile((IPath)new Path(platformResourcePath));
            } else if (allowExternal_p) {
                IProject project = wk.getRoot().getProject("ExternalFiles");
                try {
                    if (!project.exists()) {
                        project.create(null);
                    }
                    if (!project.isOpen()) {
                        project.open(null);
                    }
                    Path path = new Path(uri.toFileString());
                    result = project.getFile(path.lastSegment());
                    result.createLink((IPath)path, 0, null);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    protected static class ForgettingCommand
    extends AbstractCommand
    implements AbstractCommand.NonDirtying {
        private final Runnable _runnable;

        protected ForgettingCommand(Runnable runnable_p) {
            this._runnable = runnable_p;
        }

        public boolean canUndo() {
            return false;
        }

        protected boolean prepare() {
            return true;
        }

        public void execute() {
            this._runnable.run();
        }

        public void redo() {
        }
    }
}

