/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.util.List;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.util.DelegatingLabelProvider;
import org.eclipse.emf.diffmerge.ui.util.DiffMergeLabelProvider;
import org.eclipse.emf.diffmerge.ui.viewers.ModelComparisonDiffNode;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class ComparisonSideViewer
extends TreeViewer {
    protected Role _sideRole;

    public ComparisonSideViewer(Composite parent_p, Role sideRole_p) {
        this(parent_p, 770, sideRole_p);
    }

    public ComparisonSideViewer(Composite parent_p, int style_p, Role sideRole_p) {
        super(parent_p, style_p);
        this._sideRole = sideRole_p;
        this.setContentProvider((IContentProvider)new ContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    public ITreeContentProvider getContentProvider() {
        return (ITreeContentProvider)super.getContentProvider();
    }

    public ModelComparisonDiffNode getInput() {
        return (ModelComparisonDiffNode)((Object)super.getInput());
    }

    public ITreeSelection getSelection() {
        return (ITreeSelection)super.getSelection();
    }

    public Color getSideColor() {
        return EMFDiffMergeUIPlugin.getDefault().getDifferenceColor(this._sideRole == Role.TARGET ? EMFDiffMergeUIPlugin.DifferenceColorKind.LEFT : EMFDiffMergeUIPlugin.DifferenceColorKind.RIGHT);
    }

    public IModelScope getSideScope() {
        return this.getInput() == null ? null : this.getInput().getActualComparison().getScope(this._sideRole);
    }

    protected class ContentProvider
    implements ITreeContentProvider {
        protected ContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement_p) {
            IMatch match = (IMatch)parentElement_p;
            List result = ComparisonSideViewer.this.getInput().getActualComparison().getContentsOf(match, ComparisonSideViewer.this._sideRole);
            return result.toArray();
        }

        public Object[] getElements(Object inputElement_p) {
            ModelComparisonDiffNode input = (ModelComparisonDiffNode)((Object)inputElement_p);
            List result = input.getActualComparison().getContents(ComparisonSideViewer.this._sideRole);
            return result.toArray();
        }

        public Object getParent(Object element_p) {
            IMatch match = (IMatch)element_p;
            return ComparisonSideViewer.this.getInput().getActualComparison().getContainerOf(match, ComparisonSideViewer.this._sideRole);
        }

        public boolean hasChildren(Object element_p) {
            return this.getChildren(element_p).length > 0;
        }

        public void inputChanged(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
        }
    }

    protected class LabelProvider
    extends DelegatingLabelProvider {
        public LabelProvider() {
            super((ILabelProvider)DiffMergeLabelProvider.getInstance());
        }

        private EObject getElementToRepresent(IMatch match_p) {
            EObject result = match_p.getUncoveredRole() == ComparisonSideViewer.this._sideRole ? match_p.get(ComparisonSideViewer.this._sideRole.opposite()) : match_p.get(ComparisonSideViewer.this._sideRole);
            return result;
        }

        public Color getForeground(Object element_p) {
            EMatch match = (EMatch)element_p;
            Color result = ComparisonSideViewer.this.getInput().getDifferenceNumber((IMatch)match) > 0 ? ComparisonSideViewer.this.getSideColor() : EMFDiffMergeUIPlugin.getDefault().getDifferenceColor(EMFDiffMergeUIPlugin.DifferenceColorKind.NONE);
            return result;
        }

        public Image getImage(Object element_p) {
            IMatch match = (IMatch)element_p;
            Image result = this.getDelegate().getImage((Object)this.getElementToRepresent(match));
            return result;
        }

        public String getText(Object element_p) {
            IMatch match = (IMatch)element_p;
            String result = this.getDelegate().getText((Object)this.getElementToRepresent(match));
            return result;
        }
    }
}

