/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.diffuidata.impl.MatchAndFeatureImpl;
import org.eclipse.emf.diffmerge.ui.util.DelegatingLabelProvider;
import org.eclipse.emf.diffmerge.ui.util.DiffMergeLabelProvider;
import org.eclipse.emf.diffmerge.ui.util.DifferenceKind;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonResourceManager;
import org.eclipse.emf.diffmerge.ui.viewers.ModelComparisonDiffNode;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class FeaturesViewer
extends TableViewer {
    protected Role _drivingRole = Role.TARGET;
    private boolean _showAllFeatures;

    public FeaturesViewer(Composite parent_p) {
        this(parent_p, 770);
    }

    public FeaturesViewer(Composite parent_p, int style_p) {
        super(parent_p, style_p);
        this.setContentProvider((IContentProvider)new ContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this._showAllFeatures = false;
        this.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.setSorter(new ViewerSorter());
    }

    public FeaturesInput getInput() {
        return (FeaturesInput)super.getInput();
    }

    protected ComparisonResourceManager getResourceManager() {
        return this.getInput() == null ? null : this.getInput().getContext().getResourceManager();
    }

    protected boolean isOwnershipFeature(Object object_p) {
        return EMFDiffMergeUIPlugin.getDefault().getOwnershipFeature().equals(object_p);
    }

    public boolean mustShowAllFeatures() {
        return this._showAllFeatures;
    }

    public void setDrivingRole(Role role_p) {
        this._drivingRole = role_p;
    }

    public void setShowAllFeatures(boolean show_p) {
        if (show_p != this.mustShowAllFeatures()) {
            this._showAllFeatures = show_p;
            this.refresh(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ContentProvider
    implements IStructuredContentProvider {
        protected ContentProvider() {
        }

        private List<EStructuralFeature> getAllFeatures(IMatch match_p) {
            EObject element = match_p.get(FeaturesViewer.this._drivingRole);
            if (element == null) {
                element = match_p.get(FeaturesViewer.this._drivingRole.opposite());
            }
            assert (element != null);
            EClass eClass = element.eClass();
            ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
            result.addAll((Collection<EStructuralFeature>)eClass.getEAllAttributes());
            for (EReference ref : eClass.getEAllReferences()) {
                if (!this.qualifies(ref) && match_p.getOrderDifference((EStructuralFeature)ref, FeaturesViewer.this._drivingRole) == null) continue;
                result.add((EStructuralFeature)ref);
            }
            return result;
        }

        public Object[] getElements(Object inputElement_p) {
            List<EStructuralFeature> result;
            IMatch match = ((FeaturesInput)inputElement_p).getMatch();
            if (FeaturesViewer.this.mustShowAllFeatures()) {
                result = this.getAllFeatures(match);
            } else {
                result = new ArrayList<EStructuralFeature>(match.getAttributesWithDifferences());
                for (EReference ref : match.getReferencesWithDifferences()) {
                    if (ref.isContainment() && match.getOrderDifference((EStructuralFeature)ref, FeaturesViewer.this._drivingRole) == null) continue;
                    result.add((EStructuralFeature)ref);
                }
            }
            if (FeaturesViewer.this.getInput().getContext().representAsMove(match)) {
                result.add((EStructuralFeature)EMFDiffMergeUIPlugin.getDefault().getOwnershipFeature());
            }
            return result.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
        }

        private boolean qualifies(EReference reference_p) {
            return FeaturesViewer.this.isOwnershipFeature(reference_p) || !reference_p.isContainment() && !reference_p.isContainer() && reference_p.isChangeable() && !reference_p.isDerived() && !reference_p.isTransient();
        }
    }

    public static class FeaturesInput {
        private final ModelComparisonDiffNode _context;
        private final IMatch _match;

        public FeaturesInput(ModelComparisonDiffNode context_p, IMatch match_p) {
            this._context = context_p;
            this._match = match_p;
        }

        public boolean equals(Object object_p) {
            boolean result = false;
            if (object_p instanceof FeaturesInput) {
                FeaturesInput peer = (FeaturesInput)object_p;
                result = this._context == peer.getContext() && this._match.equals((Object)peer.getMatch());
            }
            return result;
        }

        public ModelComparisonDiffNode getContext() {
            return this._context;
        }

        public IMatch getMatch() {
            return this._match;
        }

        public int hashCode() {
            return this._context.hashCode() + this._match.hashCode();
        }
    }

    protected class LabelProvider
    extends DelegatingLabelProvider {
        private final EcoreItemProviderAdapterFactory _ecoreAdapterFactory;

        public LabelProvider() {
            super((ILabelProvider)DiffMergeLabelProvider.getInstance());
            this._ecoreAdapterFactory = new EcoreItemProviderAdapterFactory();
        }

        public void dispose() {
            super.dispose();
            this._ecoreAdapterFactory.dispose();
        }

        protected DifferenceKind getDifferenceKind(EStructuralFeature feature_p) {
            DifferenceKind result = DifferenceKind.NONE;
            if (FeaturesViewer.this.getInput() != null) {
                EMatch match = (EMatch)FeaturesViewer.this.getInput().getMatch();
                MatchAndFeatureImpl maf = new MatchAndFeatureImpl(match, feature_p);
                result = FeaturesViewer.this.getInput().getContext().getDifferenceKind(maf);
            }
            return result;
        }

        public Font getFont(Object element_p) {
            Font result = FeaturesViewer.this.getControl().getFont();
            EStructuralFeature feature = (EStructuralFeature)element_p;
            DifferenceKind kind = this.getDifferenceKind(feature);
            if (!kind.isNeutral()) {
                result = UIUtil.getBold(result);
            }
            return result;
        }

        public Color getForeground(Object element_p) {
            EStructuralFeature feature = (EStructuralFeature)element_p;
            DifferenceKind kind = this.getDifferenceKind(feature);
            EMFDiffMergeUIPlugin.DifferenceColorKind colorKind = EMFDiffMergeUIPlugin.getDefault().getDifferenceColorKind(kind);
            Color result = EMFDiffMergeUIPlugin.getDefault().getDifferenceColor(colorKind);
            return result;
        }

        public Image getImage(Object element_p) {
            Image result = null;
            if (FeaturesViewer.this.isOwnershipFeature(element_p)) {
                result = EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.CONTAINER);
            } else {
                Object rawImage;
                IItemLabelProvider provider = (IItemLabelProvider)this._ecoreAdapterFactory.adapt(element_p, IItemLabelProvider.class);
                if (provider != null && (rawImage = provider.getImage(element_p)) != null) {
                    result = ExtendedImageRegistry.getInstance().getImage(rawImage);
                }
            }
            if (FeaturesViewer.this.getInput().getContext().usesCustomIcons() && element_p instanceof EStructuralFeature) {
                EStructuralFeature feature = (EStructuralFeature)element_p;
                DifferenceKind kind = this.getDifferenceKind(feature);
                result = FeaturesViewer.this.getResourceManager().adaptImage(result, kind);
            }
            return result;
        }

        public String getText(Object element_p) {
            EStructuralFeature feature = (EStructuralFeature)element_p;
            String result = feature.getName();
            if (FeaturesViewer.this.getInput().getContext().usesCustomLabels()) {
                DifferenceKind kind = this.getDifferenceKind(feature);
                String prefix = EMFDiffMergeUIPlugin.getDefault().getDifferencePrefix(kind);
                result = String.valueOf(prefix) + result;
            }
            return result;
        }
    }
}

