/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.diffmerge.ui.util.DiffMergeLabelProvider;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonSideViewer;
import org.eclipse.emf.diffmerge.ui.viewers.ModelComparisonDiffNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;

public class EnhancedComparisonSideViewer
extends Viewer {
    protected Composite _control;
    protected ComparisonSideViewer _comparisonSideViewer;
    protected Label _image;
    protected Label _text;
    protected ToolBar _toolbar;

    public EnhancedComparisonSideViewer(Composite parent_p, Role sideRole_p) {
        this.createControls(parent_p, sideRole_p);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener_p) {
        this._comparisonSideViewer.addSelectionChangedListener(listener_p);
    }

    protected void createControls(Composite parent_p, Role sideRole_p) {
        this._control = UIUtil.createComposite(parent_p);
        Composite header = new Composite(this._control, 0);
        header.setLayoutData((Object)new GridData(4, 4, true, false));
        this._comparisonSideViewer = new ComparisonSideViewer(this._control, sideRole_p);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        header.setLayout((Layout)layout);
        Composite nameHeader = new Composite(header, 0);
        nameHeader.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout nameHeaderLayout = new GridLayout(3, false);
        nameHeaderLayout.marginTop = nameHeaderLayout.marginHeight;
        nameHeaderLayout.marginHeight = 0;
        nameHeaderLayout.marginWidth = 0;
        nameHeader.setLayout((Layout)nameHeaderLayout);
        this._image = new Label(nameHeader, 0);
        this._image.setBackground(UIUtil.getColor(1));
        this._text = new Label(nameHeader, 0);
        this._text.setForeground(this._comparisonSideViewer.getSideColor());
        Label space = new Label(nameHeader, 64);
        space.setLayoutData((Object)new GridData(4, 4, true, false));
        this._toolbar = UIUtil.createToolBar(header);
    }

    public Control getControl() {
        return this._control;
    }

    public ModelComparisonDiffNode getInput() {
        return this._comparisonSideViewer.getInput();
    }

    public ITreeSelection getSelection() {
        return this._comparisonSideViewer.getSelection();
    }

    public ToolBar getToolbar() {
        return this._toolbar;
    }

    public Tree getTree() {
        return this._comparisonSideViewer.getTree();
    }

    protected void inputChanged(Object input_p, Object oldInput_p) {
        this._comparisonSideViewer.setInput(input_p);
        IModelScope scope = this._comparisonSideViewer.getSideScope();
        String label = DiffMergeLabelProvider.getInstance().getText(scope);
        this._text.setText(label);
        this._text.setToolTipText(label);
        this._image.setImage(DiffMergeLabelProvider.getInstance().getImage(scope));
    }

    public void refresh() {
        this._comparisonSideViewer.refresh();
    }

    public final void setInput(Object input_p) {
        ModelComparisonDiffNode oldInput = this.getInput();
        this.inputChanged(input_p, (Object)oldInput);
    }

    public void setSelection(ISelection selection_p, boolean reveal_p) {
        this._comparisonSideViewer.setSelection(selection_p, reveal_p);
    }
}

