/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.util.structures;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.diffmerge.util.structures.AbstractBinaryRelation;
import org.eclipse.emf.diffmerge.util.structures.FArrayList;
import org.eclipse.emf.diffmerge.util.structures.FHashMap;
import org.eclipse.emf.diffmerge.util.structures.IEqualityTester;
import org.eclipse.emf.diffmerge.util.structures.IModifiableBinaryRelation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashBinaryRelation<T, U>
extends AbstractBinaryRelation<T, U>
implements IModifiableBinaryRelation<T, U> {
    protected final FHashMap<T, List<U>> _contents = new FHashMap(this.getEqualityTester());

    public HashBinaryRelation(IEqualityTester tester_p) {
        super(tester_p);
    }

    public HashBinaryRelation() {
        this(null);
    }

    @Override
    public void add(T source_p, U target_p) {
        assert (source_p != null && target_p != null);
        Object values = (List)this._contents.get(source_p);
        if (values == null) {
            values = new FArrayList(this.getEqualityTester());
            this._contents.put(source_p, values);
        }
        if (!values.contains(target_p)) {
            values.add(target_p);
        }
    }

    @Override
    public void clear() {
        this._contents.clear();
    }

    @Override
    public List<U> get(T element_p) {
        assert (element_p != null);
        List values = (List)this._contents.get(element_p);
        List result = values == null ? Collections.emptyList() : Collections.unmodifiableList(values);
        return result;
    }

    @Override
    public void remove(T source_p, U target_p) {
        assert (source_p != null && target_p != null);
        List values = (List)this._contents.get(source_p);
        if (values != null) {
            values.remove(target_p);
        }
    }
}

