/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.diffdata.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.diffmerge.diffdata.DiffdataPackage;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.diffdata.EMapping;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.diffdata.impl.ElementToMatchEntryImpl;
import org.eclipse.emf.diffmerge.impl.helpers.BidirectionalComparisonCopier;
import org.eclipse.emf.diffmerge.util.structures.FArrayList;
import org.eclipse.emf.diffmerge.util.structures.FHashMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMappingImpl
extends EObjectImpl
implements EMapping {
    protected EList<EMatch> modifiableContents;
    protected EList<IMatch> referenceCompletedMatches;
    protected EList<IMatch> targetCompletedMatches;
    protected EMap<EObject, IMatch> ancestorMatches;
    protected EMap<EObject, IMatch> referenceMatches;
    protected EMap<EObject, IMatch> targetMatches;
    private final BidirectionalComparisonCopier _copier = new BidirectionalComparisonCopier();
    private final ScopeCrossReferencer _targetCrossReferencer = new ScopeCrossReferencer(Role.TARGET);
    private final ScopeCrossReferencer _referenceCrossReferencer = new ScopeCrossReferencer(Role.REFERENCE);

    protected EMappingImpl() {
    }

    protected EClass eStaticClass() {
        return DiffdataPackage.Literals.EMAPPING;
    }

    @Override
    public EComparison getComparison() {
        if (this.eContainerFeatureID() != 0) {
            return null;
        }
        return (EComparison)this.eContainer();
    }

    @Override
    public EList<EMatch> getModifiableContents() {
        if (this.modifiableContents == null) {
            this.modifiableContents = new EObjectContainmentEList(EMatch.class, (InternalEObject)this, 1);
        }
        return this.modifiableContents;
    }

    @Override
    public EList<IMatch> getReferenceCompletedMatches() {
        if (this.referenceCompletedMatches == null) {
            this.referenceCompletedMatches = new EObjectResolvingEList(IMatch.class, (InternalEObject)this, 2);
        }
        return this.referenceCompletedMatches;
    }

    @Override
    public EList<IMatch> getTargetCompletedMatches() {
        if (this.targetCompletedMatches == null) {
            this.targetCompletedMatches = new EObjectResolvingEList(IMatch.class, (InternalEObject)this, 3);
        }
        return this.targetCompletedMatches;
    }

    @Override
    public EMap<EObject, IMatch> getAncestorMatches() {
        if (this.ancestorMatches == null) {
            this.ancestorMatches = new EcoreEMap(DiffdataPackage.Literals.ELEMENT_TO_MATCH_ENTRY, ElementToMatchEntryImpl.class, (InternalEObject)this, 4);
        }
        return this.ancestorMatches;
    }

    @Override
    public EMap<EObject, IMatch> getReferenceMatches() {
        if (this.referenceMatches == null) {
            this.referenceMatches = new EcoreEMap(DiffdataPackage.Literals.ELEMENT_TO_MATCH_ENTRY, ElementToMatchEntryImpl.class, (InternalEObject)this, 5);
        }
        return this.referenceMatches;
    }

    @Override
    public EMap<EObject, IMatch> getTargetMatches() {
        if (this.targetMatches == null) {
            this.targetMatches = new EcoreEMap(DiffdataPackage.Literals.ELEMENT_TO_MATCH_ENTRY, ElementToMatchEntryImpl.class, (InternalEObject)this, 6);
        }
        return this.targetMatches;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs_p) {
        NotificationChain msgs = msgs_p;
        switch (featureID) {
            case 0: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.eBasicSetContainer(otherEnd, 0, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return this.eBasicSetContainer(null, 0, msgs);
            }
            case 1: {
                return ((InternalEList)this.getModifiableContents()).basicRemove((Object)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getAncestorMatches()).basicRemove((Object)otherEnd, msgs);
            }
            case 5: {
                return ((InternalEList)this.getReferenceMatches()).basicRemove((Object)otherEnd, msgs);
            }
            case 6: {
                return ((InternalEList)this.getTargetMatches()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 0: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 6, EComparison.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getComparison();
            }
            case 1: {
                return this.getModifiableContents();
            }
            case 2: {
                return this.getReferenceCompletedMatches();
            }
            case 3: {
                return this.getTargetCompletedMatches();
            }
            case 4: {
                if (coreType) {
                    return this.getAncestorMatches();
                }
                return this.getAncestorMatches().map();
            }
            case 5: {
                if (coreType) {
                    return this.getReferenceMatches();
                }
                return this.getReferenceMatches().map();
            }
            case 6: {
                if (coreType) {
                    return this.getTargetMatches();
                }
                return this.getTargetMatches().map();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.getReferenceCompletedMatches().clear();
                this.getReferenceCompletedMatches().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getTargetCompletedMatches().clear();
                this.getTargetCompletedMatches().addAll((Collection)newValue);
                return;
            }
            case 4: {
                ((EStructuralFeature.Setting)this.getAncestorMatches()).set(newValue);
                return;
            }
            case 5: {
                ((EStructuralFeature.Setting)this.getReferenceMatches()).set(newValue);
                return;
            }
            case 6: {
                ((EStructuralFeature.Setting)this.getTargetMatches()).set(newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.getReferenceCompletedMatches().clear();
                return;
            }
            case 3: {
                this.getTargetCompletedMatches().clear();
                return;
            }
            case 4: {
                this.getAncestorMatches().clear();
                return;
            }
            case 5: {
                this.getReferenceMatches().clear();
                return;
            }
            case 6: {
                this.getTargetMatches().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.getComparison() != null;
            }
            case 1: {
                return this.modifiableContents != null && !this.modifiableContents.isEmpty();
            }
            case 2: {
                return this.referenceCompletedMatches != null && !this.referenceCompletedMatches.isEmpty();
            }
            case 3: {
                return this.targetCompletedMatches != null && !this.targetCompletedMatches.isEmpty();
            }
            case 4: {
                return this.ancestorMatches != null && !this.ancestorMatches.isEmpty();
            }
            case 5: {
                return this.referenceMatches != null && !this.referenceMatches.isEmpty();
            }
            case 6: {
                return this.targetMatches != null && !this.targetMatches.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public void clear() {
        this.getModifiableContents().clear();
        this.getTargetMatches().clear();
        this.getReferenceMatches().clear();
        this.getAncestorMatches().clear();
        this.getTargetCompletedMatches().clear();
        this.getReferenceCompletedMatches().clear();
        this._targetCrossReferencer.clear();
        this._referenceCrossReferencer.clear();
    }

    @Override
    public EObject completeMatch(IMatch partialMatch_p) {
        return this._copier.completeMatch(this, partialMatch_p);
    }

    @Override
    public void completeReferences(Role role_p) {
        this._copier.completeReferences(this, role_p);
    }

    @Override
    public boolean covers(EObject element_p, Role role_p) {
        return this.getMatchFor(element_p, role_p) != null;
    }

    @Override
    public void crossReference(Role role_p) {
        ScopeCrossReferencer referencer = null;
        if (role_p == Role.TARGET) {
            referencer = this._targetCrossReferencer;
        } else if (role_p == Role.REFERENCE) {
            referencer = this._referenceCrossReferencer;
        }
        if (referencer != null) {
            referencer.crossReference();
        }
    }

    @Override
    public Collection<IMatch> getCompletedMatches(Role destinationRole_p) {
        return Collections.unmodifiableCollection(this.getModifiableCompletedMatches(destinationRole_p));
    }

    @Override
    public Collection<IMatch> getContents() {
        return Collections.unmodifiableCollection(this.getModifiableContents());
    }

    @Override
    public IMatch getMatchFor(EObject element_p, Role role_p) {
        if (element_p == null || role_p == null) {
            return null;
        }
        IMatch result = (IMatch)this.getModifiableMatchMap(role_p).get((Object)element_p);
        return result;
    }

    @Override
    public Collection<IMatch> getModifiableCompletedMatches(Role destinationRole_p) {
        return Role.TARGET == destinationRole_p ? this.getTargetCompletedMatches() : this.getReferenceCompletedMatches();
    }

    @Override
    public EMap<EObject, IMatch> getModifiableMatchMap(Role role_p) {
        EMap<EObject, IMatch> result;
        assert (role_p != null);
        switch (role_p) {
            case TARGET: {
                result = this.getTargetMatches();
                break;
            }
            case REFERENCE: {
                result = this.getReferenceMatches();
                break;
            }
            default: {
                result = this.getAncestorMatches();
            }
        }
        return result;
    }

    @Override
    public int getNbFullMatches() {
        int result = 0;
        for (IMatch match : this.getContents()) {
            if (match.isPartial()) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int getNbPartialMatches(Role covered_p) {
        int result = 0;
        for (IMatch match : this.getContents()) {
            if (!match.isPartial() || covered_p != null && !match.coversRole(covered_p)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public Collection<EStructuralFeature.Setting> getCrossReferences(EObject element_p, Role role_p) {
        Collection<Object> result = null;
        ScopeCrossReferencer referencer = null;
        if (role_p == Role.TARGET) {
            referencer = this._targetCrossReferencer;
        } else if (role_p == Role.REFERENCE) {
            referencer = this._referenceCrossReferencer;
        }
        if (referencer != null) {
            result = (Collection)referencer.get(element_p);
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public boolean isCompleteFor(IModelScope scope_p, Role role_p) {
        TreeIterator<EObject> it = scope_p.getAllContents();
        while (it.hasNext()) {
            EObject currentInScope = (EObject)it.next();
            if (this.covers(currentInScope, role_p)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.getModifiableMatchMap(Role.TARGET).isEmpty() && this.getModifiableMatchMap(Role.REFERENCE).isEmpty() && this.getModifiableMatchMap(Role.ANCESTOR).isEmpty();
    }

    @Override
    public IMatch map(EObject element_p, Role role_p) {
        assert (element_p != null && role_p != null);
        EMatch result = (EMatch)this.getComparison().newMatch((EObject)(Role.TARGET == role_p ? element_p : null), (EObject)(Role.REFERENCE == role_p ? element_p : null), (EObject)(Role.ANCESTOR == role_p ? element_p : null));
        this.getModifiableContents().add((Object)result);
        EMap<EObject, IMatch> map = this.getModifiableMatchMap(role_p);
        IMatch found = (IMatch)map.put((Object)element_p, (Object)result);
        if (found != null) {
            this.getModifiableContents().remove((Object)found);
        }
        return result;
    }

    @Override
    public IMatch mapIncrementally(EObject element1_p, Role role1_p, EObject element2_p, Role role2_p) {
        EMap<EObject, IMatch> map2;
        IMatch found;
        EMap<EObject, IMatch> map1;
        assert (role1_p != null && role2_p != null && role1_p != role2_p);
        IMatch result = null;
        HashMap<Role, EObject> elements = new HashMap<Role, EObject>(3);
        elements.put(role1_p, element1_p);
        elements.put(role2_p, element2_p);
        Role role3 = Role.otherThan(role1_p, role2_p);
        EObject element3 = null;
        if (element1_p != null && (result = (IMatch)(map1 = this.getModifiableMatchMap(role1_p)).get((Object)element1_p)) != null) {
            element3 = result.get(role3);
        }
        if (element2_p != null && (found = (IMatch)(map2 = this.getModifiableMatchMap(role2_p)).get((Object)element2_p)) != null) {
            EObject inRole3 = found.get(role3);
            if (inRole3 != null) {
                element3 = inRole3;
            }
            if (result != null && result != found) {
                this.getModifiableContents().remove((Object)found);
            } else {
                result = found;
            }
        }
        elements.put(role3, element3);
        if (result == null) {
            result = this.getComparison().newMatch((EObject)elements.get((Object)Role.TARGET), (EObject)elements.get((Object)Role.REFERENCE), (EObject)elements.get((Object)Role.ANCESTOR));
            this.getModifiableContents().add((Object)((EMatch)result));
        } else {
            ((IMatch.Editable)result).reset((EObject)elements.get((Object)Role.TARGET), (EObject)elements.get((Object)Role.REFERENCE), (EObject)elements.get((Object)Role.ANCESTOR));
        }
        Role[] roleArray = Role.values();
        int n = roleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Role role = roleArray[n2];
            EObject element = (EObject)elements.get((Object)role);
            if (element != null) {
                this.getModifiableMatchMap(role).put((Object)element, (Object)result);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public boolean maps(EObject target_p, EObject reference_p) {
        return this.maps(target_p, Role.TARGET, reference_p, Role.REFERENCE);
    }

    @Override
    public boolean maps(EObject target_p, EObject reference_p, EObject ancestor_p) {
        return this.maps(ancestor_p, Role.ANCESTOR, target_p, Role.TARGET) && this.maps(ancestor_p, Role.ANCESTOR, reference_p, Role.REFERENCE) && this.maps(target_p, Role.TARGET, reference_p, Role.REFERENCE);
    }

    @Override
    public boolean maps(EObject element1_p, Role role1_p, EObject element2_p, Role role2_p) {
        boolean result = false;
        if (element1_p != null) {
            IMatch fromElement1 = (IMatch)this.getModifiableMatchMap(role1_p).get((Object)element1_p);
            result = fromElement1 != null && fromElement1.get(role2_p) == element2_p;
        } else if (element2_p != null) {
            IMatch fromElement2 = (IMatch)this.getModifiableMatchMap(role2_p).get((Object)element2_p);
            result = fromElement2 != null && fromElement2.get(role1_p) == element1_p;
        }
        return result;
    }

    @Override
    public int size() {
        return this.getContents().size();
    }

    @Override
    public int size(Role role_p) {
        return this.getModifiableMatchMap(role_p).size();
    }

    @Override
    public EMap<EObject, EObject> toMap(Role keyRole_p, Role valueRole_p) {
        FHashMap result = new FHashMap();
        for (IMatch match : this.getContents()) {
            EObject key = match.get(keyRole_p);
            if (key == null) continue;
            result.put(key, match.get(valueRole_p));
        }
        return ECollections.unmodifiableEMap(result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ScopeCrossReferencer
    extends EcoreUtil.CrossReferencer {
        private static final long serialVersionUID = 1L;
        protected final Role _role;

        public ScopeCrossReferencer(Role role_p) {
            super(Collections.emptyList());
            this._role = role_p;
        }

        public void crossReference() {
            super.crossReference();
        }

        protected boolean crossReference(EObject element_p, EReference reference_p, EObject crossReferenced_p) {
            boolean result = false;
            if (reference_p.isChangeable() && !reference_p.isDerived()) {
                IMatch referencingMatch = EMappingImpl.this.getMatchFor(element_p, this._role);
                IMatch referencedMatch = EMappingImpl.this.getMatchFor(crossReferenced_p, this._role);
                if (referencingMatch != null && referencedMatch != null) {
                    result = referencingMatch.isPartial() && referencedMatch.isPartial();
                }
            }
            return result;
        }

        public Role getRole() {
            return this._role;
        }

        protected Collection<EStructuralFeature.Setting> newCollection() {
            return new FArrayList();
        }

        protected TreeIterator<Notifier> newContentsIterator() {
            return EMappingImpl.this.getComparison().getScope(this._role).getAllContents();
        }

        protected boolean resolve() {
            return false;
        }
    }
}

