/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.mapping.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.diffmerge.bridge.api.IBridgeExecution;
import org.eclipse.emf.diffmerge.bridge.api.IBridgeTrace;
import org.eclipse.emf.diffmerge.bridge.impl.AbstractBridge;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IMappingBridge;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IMappingExecution;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IQuery;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IQueryHolder;
import org.eclipse.emf.diffmerge.bridge.mapping.impl.MappingExecution;
import org.eclipse.emf.diffmerge.bridge.mapping.operations.MappingBridgeOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMappingBridge<SD, TD>
extends AbstractBridge<SD, TD>
implements IMappingBridge<SD, TD> {
    private final Set<IQuery<? super SD, ?>> _rootQueries = new LinkedHashSet();

    @Override
    public void accept(IQuery<? super SD, ?> query_p) {
        this._rootQueries.add(query_p);
    }

    public MappingExecution createExecution(IBridgeTrace.Editable trace_p) {
        return new MappingExecution(trace_p);
    }

    protected MappingBridgeOperation createMappingOperation(SD sourceDataSet_p, TD targetDataSet_p, MappingExecution execution_p) {
        MappingBridgeOperation operation = new MappingBridgeOperation(sourceDataSet_p, targetDataSet_p, this, execution_p);
        return operation;
    }

    @Override
    public IMappingExecution executeOn(SD sourceDataSet_p, TD targetDataSet_p, IBridgeExecution execution_p, IProgressMonitor monitor_p) {
        MappingExecution execution = execution_p instanceof MappingExecution ? (MappingExecution)execution_p : this.createExecution(null);
        MappingBridgeOperation operation = this.createMappingOperation(sourceDataSet_p, targetDataSet_p, execution);
        operation.run(monitor_p);
        return operation.getBridgeExecution();
    }

    @Override
    public int getNbQueries() {
        return this.getNbQueriesRec(this);
    }

    private int getNbQueriesRec(IQueryHolder<?> holder_p) {
        int result = holder_p instanceof IQuery ? 1 : 0;
        for (IQuery<?, ?> subQuery : holder_p.getQueries()) {
            result += this.getNbQueriesRec(subQuery);
        }
        return result;
    }

    @Override
    public int getNbRules() {
        int result = 0;
        for (IQuery<SD, ?> query : this.getQueries()) {
            result += this.getNbRulesRec(query);
        }
        return result;
    }

    private int getNbRulesRec(IQuery<?, ?> query_p) {
        int result = query_p.getRules().size();
        for (IQuery subQuery : query_p.getQueries()) {
            result += this.getNbRulesRec(subQuery);
        }
        return result;
    }

    @Override
    public Collection<? extends IQuery<? super SD, ?>> getQueries() {
        return Collections.unmodifiableCollection(this._rootQueries);
    }

    public int getWorkAmount(SD sourceDataSet_p, TD targetDataSet_p) {
        return 1 + this.getNbQueries() + this.getNbRules();
    }

    @Override
    public void targetsCreated(TD targetSet_p) {
    }

    @Override
    public void targetsDefined(TD targetSet_p) {
    }
}

