/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.impl;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.diffmerge.bridge.api.IBridgeExecution;
import org.eclipse.emf.diffmerge.bridge.api.IBridgeTrace;
import org.eclipse.emf.diffmerge.bridge.api.ICause;
import org.eclipse.emf.diffmerge.bridge.impl.StructureBasedCause;
import org.eclipse.emf.diffmerge.bridge.util.structures.IPureStructure;
import org.eclipse.emf.diffmerge.bridge.util.structures.Tuple2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBridgeExecution
implements IBridgeExecution.Editable {
    private IStatus _status = Status.OK_STATUS;

    @Override
    public IStatus getStatus() {
        return this._status;
    }

    protected void handleWrongCause(ICause<?, ?> cause_p) {
        throw new IllegalArgumentException("Wrong type of cause: " + cause_p);
    }

    @Override
    public <T> void put(ICause<?, T> cause_p, T target_p) {
        this.putInTrace(cause_p, target_p);
    }

    protected <T> void putInTrace(ICause<?, T> cause_p, T target_p) {
        IBridgeTrace.Editable trace = this.getTrace();
        if (trace != null) {
            if (target_p instanceof IPureStructure && cause_p instanceof ICause.Symbolic) {
                Collection contents = ((IPureStructure)target_p).getContents();
                for (Tuple2 slotAndValue : contents) {
                    StructureBasedCause structCause = new StructureBasedCause((ICause.Symbolic)cause_p, slotAndValue.get1());
                    trace.putCause(structCause, slotAndValue.get2());
                }
            } else {
                trace.putCause(cause_p, target_p);
            }
        }
    }

    public void setStatus(IStatus newStatus_p) {
        this._status = newStatus_p;
    }
}

