/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.sirius;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.gmf.GMFScope;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.style.StylePackage;

public class SiriusScope
extends GMFScope {
    public static final String SESSION_RESOURCE_FRAGMENT_EXTENSION = "airdfragment";
    public static final Collection<String> SIRIUS_FILE_EXTENSIONS = Arrays.asList("aird", "airdfragment");
    protected static final Collection<? extends EPackage> SIRIUS_PACKAGES = Arrays.asList(ViewpointPackage.eINSTANCE, StylePackage.eINSTANCE, NotationPackage.eINSTANCE, DiagramPackage.eINSTANCE);
    protected static final EReference SIRIUS_DESCRIPTOR_TO_REPRESENTATION_FEATURE = ViewpointPackage.eINSTANCE.getDRepresentationDescriptor_Representation();
    protected final Map<String, DRepresentationDescriptor> _idToDescriptor = new HashMap<String, DRepresentationDescriptor>();

    public SiriusScope(URI uri_p, EditingDomain domain, boolean readOnly_p) {
        super(uri_p, domain, readOnly_p);
    }

    public SiriusScope(URI uri_p, ResourceSet resourceSet_p, boolean readOnly_p) {
        super(uri_p, resourceSet_p, readOnly_p);
    }

    public SiriusScope(Collection<URI> uris_p, EditingDomain editingDomain_p, boolean readOnly_p) {
        super(uris_p, editingDomain_p, readOnly_p);
    }

    public SiriusScope(Collection<URI> uris_p, ResourceSet resourceSet_p, boolean readOnly_p) {
        super(uris_p, resourceSet_p, readOnly_p);
    }

    public boolean add(EObject source_p, EReference reference_p, EObject value_p) {
        boolean result;
        boolean isDescriptorToRepresentation;
        boolean bl = isDescriptorToRepresentation = reference_p == SIRIUS_DESCRIPTOR_TO_REPRESENTATION_FEATURE;
        if (isDescriptorToRepresentation) {
            this.add(value_p);
        }
        if ((result = super.add(source_p, reference_p, value_p)) && isDescriptorToRepresentation) {
            DRepresentationDescriptor descriptor = (DRepresentationDescriptor)source_p;
            String uid = this.getReferencedUID(descriptor);
            this._idToDescriptor.put(uid, descriptor);
        }
        return result;
    }

    public EObject getContainer(EObject element_p) {
        EObject result;
        if (element_p instanceof DRepresentation) {
            DRepresentation representation = (DRepresentation)element_p;
            result = (EObject)this._idToDescriptor.get(representation.getUid());
        } else {
            result = super.getContainer(element_p);
        }
        return result;
    }

    public EReference getContainment(EObject element_p) {
        Object result = element_p instanceof DRepresentation ? (this.getContainer(element_p) instanceof DRepresentationDescriptor ? SIRIUS_DESCRIPTOR_TO_REPRESENTATION_FEATURE : null) : super.getContainment(element_p);
        return result;
    }

    public List<EObject> getContents() {
        List superResult = super.getContents();
        FArrayList result = new FArrayList((Collection)superResult, null);
        Iterator it = result.iterator();
        while (it.hasNext()) {
            EObject current = (EObject)it.next();
            if (!(current instanceof DRepresentation) || this.getContainer(current) == null) continue;
            it.remove();
        }
        return Collections.unmodifiableList(result);
    }

    public List<EObject> getContents(EObject element_p) {
        DRepresentationDescriptor descriptor;
        DRepresentation referenced;
        List result = super.getContents(element_p);
        if (element_p instanceof DRepresentationDescriptor && (referenced = (descriptor = (DRepresentationDescriptor)element_p).getRepresentation()) != null) {
            List originalResult = result;
            result = new FArrayList(originalResult.size() + 1, null);
            result.addAll(originalResult);
            result.add(referenced);
        }
        return result;
    }

    protected Collection<EReference> getCrossReferencesInScope(EObject element_p) {
        Collection result = super.getCrossReferencesInScope(element_p);
        if (element_p instanceof DSemanticDecorator) {
            result.add(ViewpointPackage.eINSTANCE.getDSemanticDecorator_Target());
        } else if (element_p instanceof DAnalysis) {
            result.add(ViewpointPackage.eINSTANCE.getDAnalysis_ReferencedAnalysis());
            result.add(ViewpointPackage.eINSTANCE.getDAnalysis_Models());
        } else if (element_p instanceof DRepresentationDescriptor) {
            result.add(SIRIUS_DESCRIPTOR_TO_REPRESENTATION_FEATURE);
        }
        return result;
    }

    protected String getReferencedUID(DRepresentationDescriptor descriptor_p) {
        URI uri;
        String result = null;
        ResourceDescriptor rDescriptor = descriptor_p.getRepPath();
        if (rDescriptor != null && (uri = rDescriptor.getResourceURI()) != null) {
            result = uri.fragment();
        }
        return result;
    }

    public boolean isContainment(EReference reference_p) {
        return reference_p == SIRIUS_DESCRIPTOR_TO_REPRESENTATION_FEATURE || super.isContainment(reference_p);
    }

    protected boolean isSiriusElement(EObject element_p) {
        EPackage pack = element_p.eClass().getEPackage();
        return SIRIUS_PACKAGES.contains(pack) || element_p instanceof DRepresentation;
    }

    protected boolean isSiriusResource(Resource resource_p) {
        String extension;
        boolean result = false;
        if (resource_p.getURI() != null && (extension = resource_p.getURI().fileExtension()) != null) {
            extension = extension.toLowerCase();
            result = SIRIUS_FILE_EXTENSIONS.contains(extension);
        }
        return result;
    }

    protected boolean isSuitableFor(Resource resource_p, EObject root_p) {
        boolean result = this.isSiriusResource(resource_p) == this.isSiriusElement(root_p);
        return result;
    }

    protected void notifyExplored(EObject element_p) {
        DRepresentationDescriptor descriptor;
        String uid;
        if (element_p instanceof DRepresentationDescriptor && (uid = this.getReferencedUID(descriptor = (DRepresentationDescriptor)element_p)) != null) {
            this._idToDescriptor.put(uid, descriptor);
        }
    }

    public boolean remove(EObject source_p, EReference reference_p, EObject value_p) {
        boolean result;
        boolean isDescriptorToRepresentation = reference_p == SIRIUS_DESCRIPTOR_TO_REPRESENTATION_FEATURE;
        String uid = null;
        if (isDescriptorToRepresentation) {
            uid = this.getReferencedUID((DRepresentationDescriptor)source_p);
        }
        if ((result = super.remove(source_p, reference_p, value_p)) && isDescriptorToRepresentation) {
            this._idToDescriptor.remove(uid);
        }
        return result;
    }
}

