/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.diffdata.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.Messages;
import org.eclipse.emf.diffmerge.api.IComparison;
import org.eclipse.emf.diffmerge.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.api.IMergePolicy;
import org.eclipse.emf.diffmerge.api.IMergeSelector;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IAttributeValuePresence;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IElementPresence;
import org.eclipse.emf.diffmerge.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.diffdata.DiffdataPackage;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.diffdata.EMapping;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.diffdata.impl.EAttributeValuePresenceImpl;
import org.eclipse.emf.diffmerge.diffdata.impl.EElementPresenceImpl;
import org.eclipse.emf.diffmerge.diffdata.impl.EMappingImpl;
import org.eclipse.emf.diffmerge.diffdata.impl.EMatchImpl;
import org.eclipse.emf.diffmerge.diffdata.impl.EReferenceValuePresenceImpl;
import org.eclipse.emf.diffmerge.impl.helpers.DiffOperation;
import org.eclipse.emf.diffmerge.impl.helpers.MatchOperation;
import org.eclipse.emf.diffmerge.impl.helpers.MergeOperation;
import org.eclipse.emf.diffmerge.impl.policies.DefaultDiffPolicy;
import org.eclipse.emf.diffmerge.impl.policies.DefaultMatchPolicy;
import org.eclipse.emf.diffmerge.impl.policies.DefaultMergePolicy;
import org.eclipse.emf.diffmerge.structures.IEqualityTester;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.diffmerge.structures.common.FHashSet;
import org.eclipse.emf.diffmerge.structures.common.FOrderedSet;
import org.eclipse.emf.diffmerge.util.IExpensiveOperation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

public class EComparisonImpl
extends EObjectImpl
implements EComparison {
    protected static final IEditableModelScope ANCESTOR_SCOPE_EDEFAULT = null;
    protected IEditableModelScope ancestorScope = ANCESTOR_SCOPE_EDEFAULT;
    protected static final IEditableModelScope REFERENCE_SCOPE_EDEFAULT = null;
    protected IEditableModelScope referenceScope = REFERENCE_SCOPE_EDEFAULT;
    protected static final IEditableModelScope TARGET_SCOPE_EDEFAULT = null;
    protected IEditableModelScope targetScope = TARGET_SCOPE_EDEFAULT;
    protected static final IMatchPolicy LAST_MATCH_POLICY_EDEFAULT = null;
    protected IMatchPolicy lastMatchPolicy = LAST_MATCH_POLICY_EDEFAULT;
    protected static final IDiffPolicy LAST_DIFF_POLICY_EDEFAULT = null;
    protected IDiffPolicy lastDiffPolicy = LAST_DIFF_POLICY_EDEFAULT;
    protected static final IMergePolicy LAST_MERGE_POLICY_EDEFAULT = null;
    protected IMergePolicy lastMergePolicy = LAST_MERGE_POLICY_EDEFAULT;
    protected EMapping mapping;
    private final Map<Role, Set<Object>> _duplicateIDs;

    protected EComparisonImpl() {
        HashMap duplicateIDs = new HashMap(3);
        Role[] roleArray = Role.values();
        int n = roleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Role role = roleArray[n2];
            duplicateIDs.put(role, new HashSet(0));
            ++n2;
        }
        this._duplicateIDs = Collections.unmodifiableMap(duplicateIDs);
    }

    public EComparisonImpl(IEditableModelScope targetScope_p, IEditableModelScope referenceScope_p) {
        this(targetScope_p, referenceScope_p, null);
    }

    public EComparisonImpl(IEditableModelScope targetScope_p, IEditableModelScope referenceScope_p, IEditableModelScope ancestorScope_p) {
        this();
        this.setTargetScope(targetScope_p);
        this.setReferenceScope(referenceScope_p);
        this.setAncestorScope(ancestorScope_p);
        this.setMapping(new EMappingImpl());
    }

    protected EClass eStaticClass() {
        return DiffdataPackage.Literals.ECOMPARISON;
    }

    @Override
    public IEditableModelScope getAncestorScope() {
        return this.ancestorScope;
    }

    @Override
    public void setAncestorScope(IEditableModelScope newAncestorScope) {
        IEditableModelScope oldAncestorScope = this.ancestorScope;
        this.ancestorScope = newAncestorScope;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldAncestorScope, (Object)this.ancestorScope));
        }
    }

    @Override
    public IEditableModelScope getReferenceScope() {
        return this.referenceScope;
    }

    @Override
    public void setReferenceScope(IEditableModelScope newReferenceScope) {
        IEditableModelScope oldReferenceScope = this.referenceScope;
        this.referenceScope = newReferenceScope;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldReferenceScope, (Object)this.referenceScope));
        }
    }

    @Override
    public IEditableModelScope getTargetScope() {
        return this.targetScope;
    }

    @Override
    public void setTargetScope(IEditableModelScope newTargetScope) {
        IEditableModelScope oldTargetScope = this.targetScope;
        this.targetScope = newTargetScope;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldTargetScope, (Object)this.targetScope));
        }
    }

    @Override
    public IMatchPolicy getLastMatchPolicy() {
        return this.lastMatchPolicy;
    }

    @Override
    public void setLastMatchPolicy(IMatchPolicy newLastMatchPolicy) {
        IMatchPolicy oldLastMatchPolicy = this.lastMatchPolicy;
        this.lastMatchPolicy = newLastMatchPolicy;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldLastMatchPolicy, (Object)this.lastMatchPolicy));
        }
    }

    @Override
    public IDiffPolicy getLastDiffPolicy() {
        return this.lastDiffPolicy;
    }

    @Override
    public void setLastDiffPolicy(IDiffPolicy newLastDiffPolicy) {
        IDiffPolicy oldLastDiffPolicy = this.lastDiffPolicy;
        this.lastDiffPolicy = newLastDiffPolicy;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldLastDiffPolicy, (Object)this.lastDiffPolicy));
        }
    }

    @Override
    public IMergePolicy getLastMergePolicy() {
        return this.lastMergePolicy;
    }

    @Override
    public void setLastMergePolicy(IMergePolicy newLastMergePolicy) {
        IMergePolicy oldLastMergePolicy = this.lastMergePolicy;
        this.lastMergePolicy = newLastMergePolicy;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldLastMergePolicy, (Object)this.lastMergePolicy));
        }
    }

    @Override
    public EMapping getMapping() {
        return this.mapping;
    }

    public NotificationChain basicSetMapping(EMapping newMapping, NotificationChain msgs) {
        NotificationChain result = msgs;
        EMapping oldMapping = this.mapping;
        this.mapping = newMapping;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldMapping, (Object)newMapping);
            if (result == null) {
                result = notification;
            } else {
                result.add((Notification)notification);
            }
        }
        return result;
    }

    @Override
    public void setMapping(EMapping newMapping) {
        if (newMapping != this.mapping) {
            NotificationChain msgs = null;
            if (this.mapping != null) {
                msgs = ((InternalEObject)this.mapping).eInverseRemove((InternalEObject)this, -7, null, msgs);
            }
            if (newMapping != null) {
                msgs = ((InternalEObject)newMapping).eInverseAdd((InternalEObject)this, -7, null, msgs);
            }
            if ((msgs = this.basicSetMapping(newMapping, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)newMapping, (Object)newMapping));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 6: {
                return this.basicSetMapping(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getAncestorScope();
            }
            case 1: {
                return this.getReferenceScope();
            }
            case 2: {
                return this.getTargetScope();
            }
            case 3: {
                return this.getLastMatchPolicy();
            }
            case 4: {
                return this.getLastDiffPolicy();
            }
            case 5: {
                return this.getLastMergePolicy();
            }
            case 6: {
                return this.getMapping();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setAncestorScope((IEditableModelScope)newValue);
                return;
            }
            case 1: {
                this.setReferenceScope((IEditableModelScope)newValue);
                return;
            }
            case 2: {
                this.setTargetScope((IEditableModelScope)newValue);
                return;
            }
            case 3: {
                this.setLastMatchPolicy((IMatchPolicy)newValue);
                return;
            }
            case 4: {
                this.setLastDiffPolicy((IDiffPolicy)newValue);
                return;
            }
            case 5: {
                this.setLastMergePolicy((IMergePolicy)newValue);
                return;
            }
            case 6: {
                this.setMapping((EMapping)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setAncestorScope(ANCESTOR_SCOPE_EDEFAULT);
                return;
            }
            case 1: {
                this.setReferenceScope(REFERENCE_SCOPE_EDEFAULT);
                return;
            }
            case 2: {
                this.setTargetScope(TARGET_SCOPE_EDEFAULT);
                return;
            }
            case 3: {
                this.setLastMatchPolicy(LAST_MATCH_POLICY_EDEFAULT);
                return;
            }
            case 4: {
                this.setLastDiffPolicy(LAST_DIFF_POLICY_EDEFAULT);
                return;
            }
            case 5: {
                this.setLastMergePolicy(LAST_MERGE_POLICY_EDEFAULT);
                return;
            }
            case 6: {
                this.setMapping(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return ANCESTOR_SCOPE_EDEFAULT == null ? this.ancestorScope != null : !ANCESTOR_SCOPE_EDEFAULT.equals(this.ancestorScope);
            }
            case 1: {
                return REFERENCE_SCOPE_EDEFAULT == null ? this.referenceScope != null : !REFERENCE_SCOPE_EDEFAULT.equals(this.referenceScope);
            }
            case 2: {
                return TARGET_SCOPE_EDEFAULT == null ? this.targetScope != null : !TARGET_SCOPE_EDEFAULT.equals(this.targetScope);
            }
            case 3: {
                return LAST_MATCH_POLICY_EDEFAULT == null ? this.lastMatchPolicy != null : !LAST_MATCH_POLICY_EDEFAULT.equals(this.lastMatchPolicy);
            }
            case 4: {
                return LAST_DIFF_POLICY_EDEFAULT == null ? this.lastDiffPolicy != null : !LAST_DIFF_POLICY_EDEFAULT.equals(this.lastDiffPolicy);
            }
            case 5: {
                return LAST_MERGE_POLICY_EDEFAULT == null ? this.lastMergePolicy != null : !LAST_MERGE_POLICY_EDEFAULT.equals(this.lastMergePolicy);
            }
            case 6: {
                return this.mapping != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (ancestorScope: ");
        result.append(this.ancestorScope);
        result.append(", referenceScope: ");
        result.append(this.referenceScope);
        result.append(", targetScope: ");
        result.append(this.targetScope);
        result.append(", lastMatchPolicy: ");
        result.append(this.lastMatchPolicy);
        result.append(", lastDiffPolicy: ");
        result.append(this.lastDiffPolicy);
        result.append(", lastMergePolicy: ");
        result.append(this.lastMergePolicy);
        result.append(')');
        return result.toString();
    }

    @Override
    public void clear() {
        this.getMapping().clear();
        this.setLastMatchPolicy(null);
        this.setLastDiffPolicy(null);
        this.setLastMergePolicy(null);
        Role[] roleArray = Role.values();
        int n = roleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Role role = roleArray[n2];
            this._duplicateIDs.get((Object)role).clear();
            ++n2;
        }
    }

    @Override
    public IStatus compute(IMatchPolicy matchPolicy_p, IDiffPolicy diffPolicy_p, IMergePolicy mergePolicy_p, IProgressMonitor monitor_p) {
        IProgressMonitor nonNullMonitor = monitor_p != null ? monitor_p : new NullProgressMonitor();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)nonNullMonitor, (String)Messages.Comparison_Task_Main, (int)2);
        this.setLastMatchPolicy(matchPolicy_p != null ? matchPolicy_p : new DefaultMatchPolicy());
        this.setLastDiffPolicy(diffPolicy_p != null ? diffPolicy_p : new DefaultDiffPolicy());
        this.setLastMergePolicy(mergePolicy_p != null ? mergePolicy_p : new DefaultMergePolicy());
        IStatus result = this.computeMatch(this.getLastMatchPolicy(), (IProgressMonitor)subMonitor.newChild(1));
        if (result.isOK()) {
            result = this.computeDiff(this.getLastDiffPolicy(), this.getLastMergePolicy(), (IProgressMonitor)subMonitor.newChild(1));
        }
        return result;
    }

    protected IStatus computeMatch(IMatchPolicy matchPolicy_p, IProgressMonitor monitor_p) {
        IExpensiveOperation matchOperation = this.getMatchOperation(matchPolicy_p, this._duplicateIDs);
        IStatus result = matchOperation.run(monitor_p);
        return result;
    }

    protected IStatus computeDiff(IDiffPolicy diffPolicy_p, IMergePolicy mergePolicy_p, IProgressMonitor monitor_p) {
        IExpensiveOperation diffOperation = this.getDiffOperation(diffPolicy_p, mergePolicy_p);
        IStatus result = diffOperation.run(monitor_p);
        return result;
    }

    @Override
    public TreeIterator<IMatch> getAllContents(final Role role_p) {
        return new AbstractTreeIterator<IMatch>((Object)this, false){

            protected Iterator<? extends IMatch> getChildren(Object object_p) {
                Iterator<IMatch> result = object_p instanceof IComparison ? ((IComparison)object_p).getContents(role_p).iterator() : EComparisonImpl.this.getContentsOf((IMatch)object_p, role_p).iterator();
                return result;
            }
        };
    }

    @Override
    public IMatch getContainerOf(IMatch match_p, Role role_p) {
        IEditableModelScope scope;
        EObject container;
        IMatch result = null;
        EObject child = match_p.get(role_p);
        if (child != null && (container = (scope = this.getScope(role_p)).getContainer(child)) != null) {
            result = this.getMapping().getMatchFor(container, role_p);
        }
        return result;
    }

    @Override
    public List<IMatch> getContents() {
        List<IMatch> targetMatches = this.getContents(Role.TARGET);
        List<IMatch> referenceMatches = this.getContents(Role.REFERENCE);
        FArrayList result = new FArrayList(referenceMatches, null);
        for (IMatch targetMatch : targetMatches) {
            if (result.contains(targetMatch)) continue;
            result.add(targetMatch);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<IMatch> getContents(Role role_p) {
        FArrayList result = new FArrayList();
        List<EObject> contents = this.getScope(role_p).getContents();
        for (EObject child : contents) {
            IMatch childMatch = this.getMapping().getMatchFor(child, role_p);
            if (childMatch == null) continue;
            result.add(childMatch);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<IMatch> getContentsOf(IMatch match_p) {
        List<IMatch> targetMatches = this.getContentsOf(match_p, Role.TARGET);
        List<IMatch> referenceMatches = this.getContentsOf(match_p, Role.REFERENCE);
        FOrderedSet result = new FOrderedSet(referenceMatches, null);
        for (IMatch targetMatch : targetMatches) {
            result.add(targetMatch);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<IMatch> getContentsOf(IMatch match_p, Role role_p) {
        FArrayList result = new FArrayList();
        List<EObject> contents = null;
        EObject container = match_p.get(role_p);
        if (container != null) {
            IEditableModelScope scope = this.getScope(role_p);
            contents = scope.getContents(container);
        }
        if (contents != null) {
            for (EObject child : contents) {
                IMatch childMatch = this.getMapping().getMatchFor(child, role_p);
                if (childMatch == null) continue;
                result.add(childMatch);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<IDifference> getDifferences(Role role_p) {
        FArrayList result = new FArrayList();
        TreeIterator<IMatch> it = this.getAllContents(role_p);
        while (it.hasNext()) {
            IMatch current = (IMatch)it.next();
            result.addAll(current.getPresenceDifferencesIn(role_p));
        }
        return result;
    }

    protected IExpensiveOperation getDiffOperation(IDiffPolicy diffPolicy_p, IMergePolicy mergePolicy_p) {
        return new DiffOperation(this, diffPolicy_p, mergePolicy_p);
    }

    @Override
    public Collection<Object> getDuplicateMatchIDs(Role role_p) {
        return this._duplicateIDs.get((Object)role_p);
    }

    protected IExpensiveOperation getMatchOperation(IMatchPolicy policy_p, Map<Role, Set<Object>> duplicateIDs_p) {
        return new MatchOperation(this, policy_p, duplicateIDs_p);
    }

    @Override
    public int getNbDifferences() {
        int result = 0;
        for (IMatch match : this.getMapping().getContents()) {
            result += match.getRelatedDifferences().size();
        }
        return result;
    }

    @Override
    public int getNbNoContainmentDifferences() {
        int result = 0;
        for (IMatch match : this.getMapping().getContents()) {
            result += match.getNbNoContainmentDifferences();
        }
        return result;
    }

    @Override
    public Collection<IDifference> getRemainingDifferences() {
        FHashSet result = new FHashSet(IEqualityTester.BY_EQUALS);
        for (IMatch match : this.getMapping().getContents()) {
            for (IDifference difference : match.getAllDifferences()) {
                if (difference.isMerged()) continue;
                result.add(difference);
            }
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public IEditableModelScope getScope(Role role_p) {
        IEditableModelScope result;
        switch (role_p) {
            case TARGET: {
                result = this.getTargetScope();
                break;
            }
            case REFERENCE: {
                result = this.getReferenceScope();
                break;
            }
            default: {
                result = this.getAncestorScope();
            }
        }
        return result;
    }

    @Override
    public boolean hasRemainingDifferences() {
        for (IMatch match : this.getMapping().getContents()) {
            for (IDifference difference : match.getAllDifferences()) {
                if (difference.isMerged()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isConsistent() {
        Role[] roleArray = Role.values();
        int n = roleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Role role = roleArray[n2];
            if (!this.getDuplicateMatchIDs(role).isEmpty()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean isThreeWay() {
        return this.getAncestorScope() != null;
    }

    @Override
    public Collection<IDifference> merge(final Role destination_p, boolean updateReferences_p, IProgressMonitor monitor_p) {
        Collection<IDifference> result = this.merge(new IMergeSelector(){

            @Override
            public Role getMergeDirection(IDifference difference_p) {
                return destination_p;
            }
        }, updateReferences_p, monitor_p);
        return result;
    }

    @Override
    public Collection<IDifference> merge(Collection<? extends IDifference> differences_p, Role destination_p, boolean updateReferences_p, IProgressMonitor monitor_p) {
        MergeOperation operation = new MergeOperation(this, differences_p, destination_p, updateReferences_p);
        operation.run(monitor_p);
        return operation.getOutput();
    }

    @Override
    public Collection<IDifference> merge(IMergeSelector merger_p, boolean updateReferences_p, IProgressMonitor monitor_p) {
        MergeOperation operation = new MergeOperation(this, merger_p, updateReferences_p);
        operation.run(monitor_p);
        return operation.getOutput();
    }

    @Override
    public IAttributeValuePresence newAttributeValuePresence(IMatch elementMatch_p, EAttribute attribute_p, Object value_p, Role presenceRole_p, boolean isOrder_p) {
        EAttributeValuePresenceImpl result = new EAttributeValuePresenceImpl(this, (EMatch)elementMatch_p, attribute_p, value_p, presenceRole_p, isOrder_p);
        return result;
    }

    @Override
    public IElementPresence newElementPresence(IMatch elementMatch_p, IMatch ownerMatch_p) {
        return new EElementPresenceImpl((EComparison)this, (EMatch)elementMatch_p, (EMatch)ownerMatch_p);
    }

    @Override
    public EMatch newMatch(EObject targetElement_p, EObject referenceElement_p, EObject ancestorElement_p) {
        return new EMatchImpl(targetElement_p, referenceElement_p, ancestorElement_p);
    }

    @Override
    public IReferenceValuePresence newReferenceValuePresence(IMatch elementMatch_p, EReference reference_p, EObject value_p, IMatch valueMatch_p, Role presenceRole_p, boolean isOrder_p) {
        EReferenceValuePresenceImpl result = new EReferenceValuePresenceImpl(this, (EMatch)elementMatch_p, reference_p, value_p, (EMatch)valueMatch_p, presenceRole_p, isOrder_p);
        return result;
    }

    @Override
    public boolean swapScopes() {
        boolean isEmpty = this.getMapping().isEmpty();
        if (isEmpty) {
            IEditableModelScope formerTarget = this.targetScope;
            this.targetScope = this.referenceScope;
            this.referenceScope = formerTarget;
        }
        return isEmpty;
    }
}

