/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.interactive.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Display;

public class AccumulatingJobMonitor
extends ProgressMonitorWrapper {
    protected final Display _display;
    protected Collector _collector;
    protected String _currentTask = "";

    public AccumulatingJobMonitor(IProgressMonitor monitor_p, Display display_p) {
        super(monitor_p);
        Assert.isNotNull((Object)display_p);
        this._display = display_p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTask(final String name_p, final int totalWork_p) {
        AccumulatingJobMonitor accumulatingJobMonitor = this;
        synchronized (accumulatingJobMonitor) {
            this._collector = null;
        }
        this._display.asyncExec(new Runnable(){

            @Override
            public void run() {
                AccumulatingJobMonitor.this._currentTask = name_p;
                AccumulatingJobMonitor.this.getWrappedProgressMonitor().beginTask(name_p, totalWork_p);
            }
        });
    }

    protected synchronized void clearCollector(Collector collectorToClear_p) {
        if (this._collector == collectorToClear_p) {
            this._collector = null;
        }
    }

    protected void createCollector(String subTask_p, double work_p) {
        this._collector = new Collector(subTask_p, work_p, this.getWrappedProgressMonitor());
        this._display.asyncExec((Runnable)this._collector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        AccumulatingJobMonitor accumulatingJobMonitor = this;
        synchronized (accumulatingJobMonitor) {
            this._collector = null;
        }
        this._display.asyncExec(new Runnable(){

            @Override
            public void run() {
                AccumulatingJobMonitor.this.getWrappedProgressMonitor().done();
            }
        });
    }

    public synchronized void internalWorked(double work_p) {
        if (this._collector == null) {
            this.createCollector(null, work_p);
        } else {
            this._collector.worked(work_p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskName(final String name_p) {
        AccumulatingJobMonitor accumulatingJobMonitor = this;
        synchronized (accumulatingJobMonitor) {
            this._collector = null;
        }
        this._display.asyncExec(new Runnable(){

            @Override
            public void run() {
                AccumulatingJobMonitor.this._currentTask = name_p;
                AccumulatingJobMonitor.this.getWrappedProgressMonitor().setTaskName(name_p);
            }
        });
    }

    public synchronized void subTask(String name_p) {
        if (this._collector == null) {
            this.createCollector(name_p, 0.0);
        } else {
            this._collector.subTask(name_p);
        }
    }

    public synchronized void worked(int work_p) {
        this.internalWorked(work_p);
    }

    public void clearBlocked() {
        final IProgressMonitor pm = this.getWrappedProgressMonitor();
        if (!(pm instanceof IProgressMonitorWithBlocking)) {
            return;
        }
        this._display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ((IProgressMonitorWithBlocking)pm).clearBlocked();
                Dialog.getBlockedHandler().clearBlocked();
            }
        });
    }

    public void setBlocked(final IStatus reason_p) {
        final IProgressMonitor pm = this.getWrappedProgressMonitor();
        if (!(pm instanceof IProgressMonitorWithBlocking)) {
            return;
        }
        this._display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ((IProgressMonitorWithBlocking)pm).setBlocked(reason_p);
                Dialog.getBlockedHandler().showBlocked(pm, reason_p, AccumulatingJobMonitor.this._currentTask);
            }
        });
    }

    private class Collector
    implements Runnable {
        private String _subTask;
        private double _worked;
        private IProgressMonitor _monitor;

        public Collector(String subTask_p, double work_p, IProgressMonitor monitor_p) {
            this._subTask = subTask_p;
            this._worked = work_p;
            this._monitor = monitor_p;
        }

        public void worked(double workedIncrement_p) {
            this._worked += workedIncrement_p;
        }

        public void subTask(String subTaskName_p) {
            this._subTask = subTaskName_p;
        }

        @Override
        public void run() {
            AccumulatingJobMonitor.this.clearCollector(this);
            if (this._subTask != null) {
                this._monitor.subTask(this._subTask);
            }
            if (this._worked > 0.0) {
                this._monitor.internalWorked(this._worked);
            }
        }
    }
}

