/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.core.api.status;

import org.eclipse.emf.diffmerge.patterns.core.Messages;
import org.eclipse.emf.diffmerge.patterns.core.api.status.AbstractStatus;
import org.eclipse.emf.diffmerge.patterns.core.api.status.IPatternConformityStatus;

public class PatternConformityStatus
extends AbstractStatus
implements IPatternConformityStatus {
    private int _extraValues;
    private int _missingValues;

    public PatternConformityStatus(boolean isOk_p, String description_p) {
        this(isOk_p, false, description_p);
    }

    public PatternConformityStatus(boolean isOk_p, boolean hasWarnings_p, String description_p) {
        this(isOk_p, hasWarnings_p, description_p, false);
    }

    public PatternConformityStatus(boolean isOk_p, boolean hasWarnings_p, String description_p, boolean mutable_p) {
        super(isOk_p, hasWarnings_p, description_p, mutable_p);
        this._missingValues = 0;
        this._extraValues = 0;
    }

    public PatternConformityStatus(int missingValues_p, int extraValues_p) {
        super(true, false, null, true);
        this._missingValues = missingValues_p;
        this._extraValues = extraValues_p;
    }

    public void addExtraValues(int increment_p) {
        if (this.isMutable()) {
            this._extraValues += increment_p;
        }
    }

    public void addMissingValues(int increment_p) {
        if (this.isMutable()) {
            this._missingValues += increment_p;
        }
    }

    @Override
    public String getDescription() {
        String result = this._description;
        if (result == null || result.length() == 0) {
            result = this.getValueBasedDescription();
        }
        return result;
    }

    @Override
    public int getExtraValues() {
        return this._extraValues;
    }

    @Override
    public int getMissingValues() {
        return this._missingValues;
    }

    private String getValueBasedDescription() {
        String result = this._extraValues == 0 && this._missingValues == 0 ? Messages.PatternConformityStatus_Conforms : (this._missingValues == 0 ? String.format(Messages.PatternConformityStatus_ConformityExtra, this._extraValues) : String.format(Messages.PatternConformityStatus_NonConformityDetails, this._missingValues, this._extraValues));
        return result;
    }

    @Override
    public boolean isOk() {
        return super.isOk() && this._extraValues == 0 && this._missingValues == 0;
    }
}

