/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.specification.ext;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.diffmerge.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.api.IMergePolicy;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethod;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.emf.diffmerge.ui.viewers.AbstractComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonViewer;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;

public class DefaultComparisonMethod
implements IComparisonMethod {
    private final Map<Role, IModelScopeDefinition> _roleToScopeDefinition = new HashMap<Role, IModelScopeDefinition>();
    private Role _twoWayReferenceRole;
    private IMatchPolicy _matchPolicy;
    private IDiffPolicy _diffPolicy;
    private IMergePolicy _mergePolicy;
    private EditingDomain _editingDomain;

    public DefaultComparisonMethod(IModelScopeDefinition leftScopeSpec_p, IModelScopeDefinition rightScopeSpec_p, IModelScopeDefinition ancestorScopeSpec_p) {
        this._roleToScopeDefinition.put(Role.TARGET, leftScopeSpec_p);
        this._roleToScopeDefinition.put(Role.REFERENCE, rightScopeSpec_p);
        this._roleToScopeDefinition.put(Role.ANCESTOR, ancestorScopeSpec_p);
        this._twoWayReferenceRole = null;
        this._editingDomain = null;
        this._matchPolicy = this.createMatchPolicy();
        this._diffPolicy = this.createDiffPolicy();
        this._mergePolicy = this.createMergePolicy();
    }

    public void configure() {
    }

    public AbstractComparisonViewer createComparisonViewer(Composite parent_p, IActionBars actionBars_p) {
        ComparisonViewer result = new ComparisonViewer(parent_p, actionBars_p);
        ILabelProvider customLP = this.getCustomLabelProvider();
        if (customLP != null) {
            result.setDelegateLabelProvider(customLP);
        }
        return result;
    }

    protected IDiffPolicy createDiffPolicy() {
        return null;
    }

    protected IMatchPolicy createMatchPolicy() {
        return null;
    }

    protected IMergePolicy createMergePolicy() {
        return null;
    }

    public void dispose() {
        AdapterFactoryEditingDomain afed;
        AdapterFactory af;
        EditingDomain domain = this.getEditingDomain();
        if (domain.getResourceSet().getResources().isEmpty() && domain instanceof AdapterFactoryEditingDomain && (af = (afed = (AdapterFactoryEditingDomain)domain).getAdapterFactory()) instanceof IDisposable) {
            ((IDisposable)af).dispose();
        }
    }

    protected EditingDomain doGetEditingDomain() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        return new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)new BasicCommandStack());
    }

    public IModelScopeDefinition getModelScopeDefinition(Role role_p) {
        return this._roleToScopeDefinition.get(role_p);
    }

    public final IDiffPolicy getDiffPolicy() {
        return this._diffPolicy;
    }

    public final EditingDomain getEditingDomain() {
        if (this._editingDomain == null) {
            this._editingDomain = this.doGetEditingDomain();
        }
        return this._editingDomain;
    }

    protected ILabelProvider getCustomLabelProvider() {
        return null;
    }

    public final IMatchPolicy getMatchPolicy() {
        return this._matchPolicy;
    }

    public final IMergePolicy getMergePolicy() {
        return this._mergePolicy;
    }

    public ResourceSet getResourceSet() {
        return null;
    }

    public Role getTwoWayReferenceRole() {
        return this._twoWayReferenceRole;
    }

    public boolean isConfigurable() {
        return false;
    }

    public final boolean isThreeWay() {
        return this.getModelScopeDefinition(Role.ANCESTOR) != null;
    }

    public void setTwoWayReferenceRole(Role role_p) {
        if (!this.isThreeWay() && Role.TARGET == role_p || Role.REFERENCE == role_p) {
            this._twoWayReferenceRole = role_p;
        }
    }

    public boolean swapScopeDefinitions(Role role1_p, Role role2_p) {
        boolean result = false;
        IModelScopeDefinition scope1 = this.getModelScopeDefinition(role1_p);
        IModelScopeDefinition scope2 = this.getModelScopeDefinition(role2_p);
        if (scope1 != null && scope2 != null) {
            this._roleToScopeDefinition.put(role1_p, scope2);
            this._roleToScopeDefinition.put(role2_p, scope1);
            result = true;
        }
        return result;
    }
}

