/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.diffmerge.api.IComparison;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.IPureMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.util.DelegatingLabelProvider;
import org.eclipse.emf.diffmerge.ui.util.DifferenceKind;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonResourceManager;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparisonTreeViewer
extends TreeViewer {
    public ComparisonTreeViewer(Composite parent_p) {
        this(parent_p, 770);
    }

    public ComparisonTreeViewer(Composite parent_p, int style_p) {
        super(parent_p, style_p);
        this.setContentProvider((IContentProvider)new ContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this);
        this.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    public ITreePathContentProvider getContentProvider() {
        return (ITreePathContentProvider)super.getContentProvider();
    }

    protected Role getDrivingRole() {
        return this.getInput().getDrivingRole();
    }

    public EMFDiffNode getInput() {
        return (EMFDiffNode)((Object)super.getInput());
    }

    protected TreePath getFirstIn(TreePath path_p) {
        TreePath result = null;
        Object[] children = this.getSortedChildren(path_p);
        if (children.length > 0) {
            result = path_p.createChildPath(children[0]);
        }
        return result;
    }

    protected TreePath getLastIn(TreePath path_p) {
        TreePath result = null;
        Object[] children = this.getSortedChildren(path_p);
        if (children.length > 0) {
            result = path_p;
            while (children.length > 0) {
                Object last = children[children.length - 1];
                result = result.createChildPath(last);
                children = this.getSortedChildren(result);
            }
        }
        return result;
    }

    protected TreePath getNextOf(TreePath path_p) {
        TreePath result = this.getFirstIn(path_p);
        if (result == null && path_p.getSegmentCount() > 0 && (result = this.getNextSiblingOf(path_p)) == null) {
            TreePath parentPath = path_p.getParentPath();
            while (result == null && parentPath.getSegmentCount() > 0) {
                result = this.getNextSiblingOf(parentPath);
                parentPath = parentPath.getParentPath();
            }
        }
        return result;
    }

    protected TreePath getNextSiblingOf(TreePath path_p) {
        TreePath parentPath;
        Object[] siblingsArray;
        List<Object> siblings;
        int nextPos;
        TreePath result = null;
        Object end = path_p.getLastSegment();
        if (end != null && (nextPos = (siblings = Arrays.asList(siblingsArray = this.getSortedChildren(parentPath = path_p.getParentPath()))).indexOf(end) + 1) < siblings.size()) {
            result = parentPath.createChildPath(siblings.get(nextPos));
        }
        return result;
    }

    public TreePath getNextUserDifference(TreePath path_p) {
        TreePath result = null;
        TreePath next = this.getNextOf(path_p);
        while (result == null && next != null) {
            if (this.getInput().representAsUserDifference(next)) {
                result = next;
                continue;
            }
            next = this.getNextOf(next);
        }
        return result;
    }

    protected List<List<IMatch>> getPathsFor(IMatch match_p, boolean parentsOnly_p) {
        List<List<Object>> result;
        if (match_p == null) {
            result = new ArrayList<List<IMatch>>();
        } else {
            Role drivingRole;
            boolean isRoot;
            IComparison comparison = match_p.getMapping().getComparison();
            boolean bl = isRoot = comparison.getContents(drivingRole = this.getDrivingRole()).contains(match_p) || match_p.getUncoveredRole() == drivingRole && comparison.getContents(drivingRole.opposite()).contains(match_p);
            if (isRoot) {
                result = new ArrayList();
                result.add(new ArrayList());
            } else {
                IMatch drivingContainer = comparison.getContainerOf(match_p, drivingRole);
                result = this.getPathsFor(drivingContainer, false);
                IMatch oppositeContainer = comparison.getContainerOf(match_p, drivingRole.opposite());
                if (oppositeContainer != null && oppositeContainer != drivingContainer) {
                    for (List<IMatch> oppositePath : this.getPathsFor(oppositeContainer, false)) {
                        if (this.getInput().representAsMoveOrigin(UIUtil.toTreePath(oppositePath))) continue;
                        result.add(oppositePath);
                    }
                }
            }
            if (!parentsOnly_p) {
                for (List<Object> path : result) {
                    path.add(match_p);
                }
            }
        }
        return result;
    }

    protected TreePath getPreviousOf(TreePath path_p) {
        TreePath result = null;
        if (path_p.getSegmentCount() == 0) {
            result = this.getLastIn(path_p);
        } else {
            TreePath siblingPath = this.getPreviousSiblingOf(path_p);
            if (siblingPath != null) {
                result = this.getLastIn(siblingPath);
                if (result == null) {
                    result = siblingPath;
                }
            } else {
                TreePath parentPath = path_p.getParentPath();
                if (parentPath.getSegmentCount() > 0) {
                    result = parentPath;
                }
            }
        }
        return result;
    }

    protected TreePath getPreviousSiblingOf(TreePath path_p) {
        TreePath parentPath;
        Object[] siblingsArray;
        List<Object> siblings;
        int prevPos;
        TreePath result = null;
        Object end = path_p.getLastSegment();
        if (end != null && (prevPos = (siblings = Arrays.asList(siblingsArray = this.getSortedChildren(parentPath = path_p.getParentPath()))).indexOf(end) - 1) >= 0) {
            result = parentPath.createChildPath(siblings.get(prevPos));
        }
        return result;
    }

    public TreePath getPreviousUserDifference(TreePath path_p) {
        TreePath result = null;
        TreePath previous = this.getPreviousOf(path_p);
        while (result == null && previous != null) {
            if (this.getInput().representAsUserDifference(previous)) {
                result = previous;
                continue;
            }
            previous = this.getPreviousOf(previous);
        }
        return result;
    }

    protected Object[] getRawChildren(Object parent_p) {
        Object[] result = parent_p instanceof TreePath && ((TreePath)parent_p).getSegmentCount() == 0 ? this.getContentProvider().getElements((Object)this.getInput()) : super.getRawChildren(parent_p);
        return result;
    }

    protected ComparisonResourceManager getResourceManager() {
        return this.getInput() == null ? null : this.getInput().getResourceManager();
    }

    public ITreeSelection getSelection() {
        return (ITreeSelection)super.getSelection();
    }

    public Object[] getSortedChildren(Object parentElementOrTreePath_p) {
        return super.getSortedChildren(parentElementOrTreePath_p);
    }

    protected class ContentProvider
    implements ITreePathContentProvider {
        protected ContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(TreePath parentPath_p) {
            IMatch end = (IMatch)parentPath_p.getLastSegment();
            List result = end == null ? ComparisonTreeViewer.this.getInput().getActualComparison().getContents() : (ComparisonTreeViewer.this.getInput().representAsMoveOrigin(parentPath_p) ? Collections.emptyList() : ComparisonTreeViewer.this.getInput().getActualComparison().getContentsOf(end));
            return result.toArray();
        }

        public Object[] getElements(Object inputElement_p) {
            EMFDiffNode input = (EMFDiffNode)((Object)inputElement_p);
            List result = input.getActualComparison().getContents();
            return result.toArray();
        }

        public TreePath[] getParents(Object element_p) {
            List<List<IMatch>> resultAsList = ComparisonTreeViewer.this.getPathsFor((IMatch)element_p, true);
            return UIUtil.toTreePaths(resultAsList);
        }

        public boolean hasChildren(TreePath path_p) {
            return ComparisonTreeViewer.this.getSortedChildren(path_p).length > 0;
        }

        public void inputChanged(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
        }
    }

    protected class LabelProvider
    extends DelegatingLabelProvider
    implements ITreePathLabelProvider {
        protected LabelProvider() {
        }

        private EObject getElementToRepresent(IMatch match_p) {
            Role drivingRole = ComparisonTreeViewer.this.getDrivingRole();
            EObject result = match_p.getUncoveredRole() == drivingRole ? match_p.get(drivingRole.opposite()) : match_p.get(drivingRole);
            return result;
        }

        public Font getFont(Object element_p) {
            IMatch match = (IMatch)element_p;
            Font result = ComparisonTreeViewer.this.getControl().getFont();
            if (ComparisonTreeViewer.this.getInput().representAsUserDifference(match)) {
                result = UIUtil.getBold(result);
            }
            return result;
        }

        public Color getForeground(Object element_p) {
            EMatch match = (EMatch)element_p;
            DifferenceKind kind = ComparisonTreeViewer.this.getInput().getDifferenceKind((IMatch)match);
            EMFDiffMergeUIPlugin.DifferenceColorKind colorKind = EMFDiffMergeUIPlugin.getDefault().getDifferenceColorKind(kind);
            return ComparisonTreeViewer.this.getInput().getDifferenceColor(colorKind);
        }

        public Image getImage(Object element_p) {
            IMatch match = (IMatch)element_p;
            Image result = this.getDelegate().getImage((Object)this.getElementToRepresent(match));
            if (result != null && ComparisonTreeViewer.this.getInput().usesCustomIcons()) {
                DifferenceKind kind = ComparisonTreeViewer.this.getInput().getDifferenceKind(match);
                result = ComparisonTreeViewer.this.getResourceManager().adaptImage(result, kind);
            }
            return result;
        }

        private Font getPathFont(TreePath path_p) {
            Font result = ComparisonTreeViewer.this.getControl().getFont();
            Object last = path_p.getLastSegment();
            if (last != null && !ComparisonTreeViewer.this.getInput().representAsMoveOrigin(path_p)) {
                result = this.getFont(last);
            }
            return result;
        }

        private Image getPathImage(TreePath path_p) {
            Image result = null;
            IMatch last = (IMatch)path_p.getLastSegment();
            if (last != null) {
                result = this.getDelegate().getImage((Object)this.getElementToRepresent(last));
                if (ComparisonTreeViewer.this.getInput().representAsMoveOrigin(path_p) && result != null) {
                    result = ComparisonTreeViewer.this.getResourceManager().getDisabledVersion(result);
                }
                if (result != null && ComparisonTreeViewer.this.getInput().usesCustomIcons()) {
                    DifferenceKind kind = ComparisonTreeViewer.this.getInput().getDifferenceKind(last);
                    result = ComparisonTreeViewer.this.getResourceManager().adaptImage(result, kind);
                }
            }
            return result;
        }

        private String getPathText(TreePath path_p) {
            String result = null;
            IMatch last = (IMatch)path_p.getLastSegment();
            if (last != null) {
                result = this.getText(last);
            }
            return result;
        }

        public String getText(Object element_p) {
            int nb;
            EMatch match = (EMatch)element_p;
            String result = this.getDelegate().getText((Object)this.getElementToRepresent((IMatch)match));
            if (ComparisonTreeViewer.this.getInput().usesCustomLabels()) {
                DifferenceKind kind = ComparisonTreeViewer.this.getInput().getDifferenceKind((IMatch)match);
                String prefix = EMFDiffMergeUIPlugin.getDefault().getDifferencePrefix(kind);
                result = String.valueOf(prefix) + result;
            }
            if ((nb = ComparisonTreeViewer.this.getInput().getUIDifferenceNumber(match)) > 0) {
                result = String.valueOf(result) + " (" + nb + ")";
            }
            return result;
        }

        public String getToolTipText(Object element_p) {
            Object matchID;
            String result = null;
            if (element_p instanceof IPureMatch && (matchID = ((IPureMatch)element_p).getMatchID()) != null) {
                String matchIDText = matchID.toString();
                result = String.valueOf(Messages.ComparisonTreeViewer_MatchIDTooltip) + matchIDText;
            }
            return result;
        }

        public void updateLabel(ViewerLabel label_p, TreePath elementPath_p) {
            String text = this.getPathText(elementPath_p);
            label_p.setText(text);
            Object element = elementPath_p.getLastSegment();
            label_p.setImage(this.getPathImage(elementPath_p));
            label_p.setBackground(this.getBackground(element));
            label_p.setForeground(this.getForeground(element));
            label_p.setFont(this.getPathFont(elementPath_p));
        }
    }
}

