/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.repositories.catalogs.operations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternSymbol;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternVersion;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.PatternRepository;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.PatternSymbol;
import org.eclipse.emf.diffmerge.patterns.core.operations.AbstractModelOperation;
import org.eclipse.emf.diffmerge.patterns.core.util.ModelsUtil;
import org.eclipse.emf.diffmerge.patterns.core.util.ResourcesUtil;
import org.eclipse.emf.diffmerge.patterns.repositories.catalogs.Messages;
import org.eclipse.emf.diffmerge.patterns.repositories.catalogs.PatternCatalogsPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenCatalogOperation
extends AbstractModelOperation<Collection<PatternRepository>> {
    private URI _file;
    private final Collection<IPatternInstance> _instancesToUpdate;
    private final Map<URI, Throwable> _throwables = new HashMap<URI, Throwable>();

    public OpenCatalogOperation(IPatternInstance instance_p, ResourceSet resourceSet_p) {
        this((Object)OpenCatalogOperation.getLastCatalogPath(instance_p), resourceSet_p);
    }

    public OpenCatalogOperation(IPatternInstance instance_p, TransactionalEditingDomain domain_p) {
        this((Object)OpenCatalogOperation.getLastCatalogPath(instance_p), domain_p);
    }

    public OpenCatalogOperation(Object file_p, ResourceSet resourceSet_p) {
        this(file_p, resourceSet_p, Collections.emptyList());
    }

    public OpenCatalogOperation(Object file_p, TransactionalEditingDomain domain_p) {
        this(file_p, domain_p, Collections.emptyList());
    }

    public OpenCatalogOperation(Object file_p, TransactionalEditingDomain domain_p, Collection<? extends IPatternInstance> instancesToUpdate_p) {
        super(Messages.OpenCatalogOperation_Name, domain_p.getResourceSet(), !instancesToUpdate_p.isEmpty(), false, true, (Object)domain_p, instancesToUpdate_p);
        this._instancesToUpdate = new ModelsUtil.ROrderedSet(instancesToUpdate_p);
        this._file = null;
        if (file_p instanceof URI) {
            this._file = (URI)file_p;
        } else if (file_p instanceof IFile) {
            this._file = ResourcesUtil.getUriForFile((IFile)((IFile)file_p));
        } else if (file_p instanceof String) {
            this._file = URI.createURI((String)((String)file_p));
        }
    }

    public OpenCatalogOperation(Object file_p, ResourceSet resourceSet_p, Collection<? extends IPatternInstance> instancesToUpdate_p) {
        super(Messages.OpenCatalogOperation_Name, resourceSet_p, !instancesToUpdate_p.isEmpty(), false, true, (Object)resourceSet_p, instancesToUpdate_p);
        this._instancesToUpdate = new ModelsUtil.ROrderedSet(instancesToUpdate_p);
        this._file = null;
        if (file_p instanceof URI) {
            this._file = (URI)file_p;
        } else if (file_p instanceof IFile) {
            this._file = ResourcesUtil.getUriForFile((IFile)((IFile)file_p));
        } else if (file_p instanceof String) {
            this._file = URI.createURI((String)((String)file_p));
        }
    }

    private static URI getLastCatalogPath(IPatternInstance instance_p) {
        String stringPath;
        IPatternSymbol symbol;
        URI result = null;
        IPatternVersion version = instance_p.getPatternVersion();
        if (version != null && (symbol = version.getPatternSymbol()) != null && (stringPath = symbol.getLastPath()) != null) {
            result = URI.createURI((String)stringPath);
            result = result.trimFragment();
        }
        return result;
    }

    public Map<URI, Throwable> getErrors() {
        return Collections.unmodifiableMap(this._throwables);
    }

    protected Collection<PatternRepository> run() {
        ArrayList<PatternRepository> result = new ArrayList<PatternRepository>();
        PatternRepository catalog = null;
        try {
            catalog = PatternCatalogsPlugin.getDefault().getAccessor().openCatalog(this._file, this.getResourceSet());
        }
        catch (IOException e) {
            this._throwables.put(this._file, e);
        }
        if (catalog != null) {
            result.add(catalog);
        }
        this.updateLastPathOfInstances(this._instancesToUpdate, result);
        return result;
    }

    private void updateLastPathOfInstances(Collection<IPatternInstance> instancesToUpdate_p, List<PatternRepository> loadedRepositories_p) {
        HashSet<Resource> resources = new HashSet<Resource>(loadedRepositories_p.size());
        for (PatternRepository repository : loadedRepositories_p) {
            if (repository.eResource() == null) continue;
            resources.add(repository.eResource());
        }
        for (IPatternInstance instance : instancesToUpdate_p) {
            String newPath;
            URI uri;
            IPatternSymbol iSymbol = instance.getPatternVersion().getPatternSymbol();
            if (!(iSymbol instanceof PatternSymbol)) continue;
            PatternSymbol symbol = (PatternSymbol)iSymbol;
            String id = symbol.getPatternId();
            EObject pattern = CorePatternsPlugin.getDefault().getIdProvider().getById(id, resources);
            if (pattern == null || (uri = EcoreUtil.getURI((EObject)pattern)) == null || (newPath = uri.toString()).equals(symbol.getLastPath())) continue;
            symbol.setLastPath(newPath);
        }
    }
}

