/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.diagrams.sirius.util;

import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.ViewpointFactory;
import org.eclipse.swt.graphics.RGB;

public class ColorUtil {
    private ColorUtil() {
    }

    public static RGBValues getRGBColor(int red, int green, int blue) {
        ViewpointFactory fact = ViewpointFactory.eINSTANCE;
        RGBValues rgbValues = fact.createRGBValues();
        if (rgbValues != null) {
            rgbValues.setRed(red);
            rgbValues.setGreen(green);
            rgbValues.setBlue(blue);
            return rgbValues;
        }
        return ColorUtil.getRGBColor(0, 0, 0);
    }

    public static RGB convertRGBValuesToRGB(RGBValues rgbValuesObject_p) {
        if (rgbValuesObject_p != null) {
            return new RGB(rgbValuesObject_p.getRed(), rgbValuesObject_p.getGreen(), rgbValuesObject_p.getBlue());
        }
        return new RGB(0, 0, 0);
    }

    public static RGBValues convertRGBToRGBValues(RGB rgbObject_p) {
        ViewpointFactory fact = ViewpointFactory.eINSTANCE;
        RGBValues rgbValues = fact.createRGBValues();
        if (rgbObject_p != null && rgbValues != null) {
            rgbValues.setBlue(rgbObject_p.blue);
            rgbValues.setGreen(rgbObject_p.green);
            rgbValues.setRed(rgbObject_p.red);
            return rgbValues;
        }
        return ColorUtil.getRGBColor(0, 0, 0);
    }

    public static int convertRGBValuesToIntColor(RGBValues rgbValues_p) {
        if (rgbValues_p == null) {
            return -1;
        }
        return rgbValues_p.getRed() + rgbValues_p.getGreen() * 256 + rgbValues_p.getBlue() * 65536;
    }

    public static RGBValues convertIntColorToRGBValues(int color_p) {
        ViewpointFactory fact = ViewpointFactory.eINSTANCE;
        RGBValues rgbValues = fact.createRGBValues();
        int redpart = color_p % 256;
        int greenpart = (color_p - redpart) / 256;
        int green = greenpart % 256;
        rgbValues.setRed(redpart);
        rgbValues.setGreen(green);
        rgbValues.setBlue((greenpart - green) / 256);
        return rgbValues;
    }
}

