/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.templates.engine.ext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstanceMarker;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IPatternSupport;
import org.eclipse.emf.diffmerge.patterns.support.gen.commonpatternsupport.CommonPatternInstance;
import org.eclipse.emf.diffmerge.patterns.templates.engine.NamingUtil;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.ISemanticRuleProvider;
import org.eclipse.emf.diffmerge.util.ModelsUtil;
import org.eclipse.emf.diffmerge.util.structures.FOrderedSet;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModellerSemanticRuleProvider
implements ISemanticRuleProvider {
    public boolean deriveOwnership(EObject element_p, Object context_p) {
        IPatternSupport support;
        boolean result = false;
        if (element_p instanceof IPatternInstance && (support = CorePatternsPlugin.getDefault().getPatternSupportFor(element_p)) != null) {
            result = support.storeInstance((IPatternInstance)element_p, context_p);
        }
        return result;
    }

    @Override
    public EAttribute getNameAttribute(EObject element_p) {
        if (element_p != null) {
            for (EAttribute attribute : element_p.eClass().getEAllAttributes()) {
                if (!NamingUtil.isName((EStructuralFeature)attribute)) continue;
                return attribute;
            }
        }
        return null;
    }

    public List<EObject> getPossibleContainersIn(Collection<? extends EObject> roots_p, Collection<? extends EObject> toStore_p) {
        FOrderedSet result = new FOrderedSet();
        for (EObject eObject : roots_p) {
            result.addAll(this.getPossibleContainersIn(eObject, toStore_p));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<EObject> getPossibleContainersInContext(Object context_p, Collection<? extends EObject> toStore_p) {
        List<EObject> roots = this.getRootsForContainerRetrieval(context_p);
        List<EObject> result = roots == null || roots.isEmpty() ? Collections.emptyList() : this.getPossibleContainersIn(roots, toStore_p);
        return result;
    }

    public List<EObject> getPossibleContainersIn(EObject context_p, Collection<? extends EObject> toStore_p) {
        FOrderedSet result = new FOrderedSet();
        if (this.isPossibleContainerFor(context_p, toStore_p)) {
            result.add(context_p);
        }
        TreeIterator it = context_p.eAllContents();
        while (it.hasNext()) {
            EObject current = (EObject)it.next();
            if (!this.isPossibleContainerFor(current, toStore_p)) continue;
            result.add(current);
        }
        return Collections.unmodifiableList(result);
    }

    public List<EObject> getRootsForContainerRetrieval(Object context_p) {
        FOrderedSet result = new FOrderedSet();
        if (context_p instanceof CommonPatternInstance) {
            IPatternSupport support = CorePatternsPlugin.getDefault().getPatternSupportFor((EObject)context_p);
            Resource modelResource = support.getModelResource((IPatternInstanceMarker)((CommonPatternInstance)context_p));
            if (modelResource != null && !modelResource.getContents().isEmpty()) {
                result.add((EObject)modelResource.getContents().get(0));
            }
        } else if (context_p instanceof EObject) {
            result.add(EcoreUtil.getRootContainer((EObject)((EObject)context_p)));
        } else if (context_p instanceof Resource) {
            result.addAll(((Resource)context_p).getContents());
        }
        return Collections.unmodifiableList(result);
    }

    public boolean isPossibleContainerFor(EObject container_p, Collection<? extends EObject> toStore_p) {
        EClass type = ModelsUtil.getCommonType(toStore_p);
        for (EReference containment : this.getReferencesForAddition(container_p, type, true, true)) {
            if (!this.supportsAdditionOf(container_p, containment, toStore_p, true)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean ownershipMightBeDerived(EObject element_p) {
        return element_p instanceof IPatternInstance;
    }

    @Override
    public boolean supportsAdditionOf(EObject element_p, EReference reference_p, EObject value_p, boolean nonErasing_p) {
        return this.supportsAdditionOf(element_p, reference_p, value_p.eClass(), nonErasing_p);
    }

    @Override
    public boolean supportsAdditionOf(EObject element_p, EReference reference_p, Collection<? extends EObject> values_p, boolean nonErasing_p) {
        for (EObject eObject : values_p) {
            if (this.supportsAdditionOf(element_p, reference_p, eObject, nonErasing_p)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<EReference> getReferencesForAddition(EObject element_p, EClass valueType_p, boolean nonErasing_p, boolean containmentOnly_p) {
        ArrayList<EReference> result = new ArrayList<EReference>();
        if (element_p != null) {
            EList candidates = containmentOnly_p ? element_p.eClass().getEAllContainments() : element_p.eClass().getEAllReferences();
            for (EReference candidate : candidates) {
                if (!this.supportsAdditionOf(element_p, candidate, valueType_p, nonErasing_p)) continue;
                result.add(candidate);
            }
        }
        return Collections.unmodifiableList(result);
    }

    protected boolean supportsSettingOf(EReference reference_p, EClass valueType_p) {
        if (reference_p != null && valueType_p != null && reference_p.getEReferenceType() != null) {
            return !reference_p.isDerived() && reference_p.isChangeable() && reference_p.getEReferenceType().isSuperTypeOf(valueType_p);
        }
        return false;
    }

    protected boolean supportsAdditionOf(EObject element_p, EReference reference_p, EClass valueType_p, boolean nonErasing_p) {
        boolean result = false;
        if (element_p != null) {
            boolean bl = result = element_p.eClass().getEAllReferences().contains((Object)reference_p) && this.supportsSettingOf(reference_p, valueType_p);
            if (result && nonErasing_p && !FeatureMapUtil.isMany((EObject)element_p, (EStructuralFeature)reference_p)) {
                Object currentValue = element_p.eGet((EStructuralFeature)reference_p);
                result = currentValue == null;
            }
        }
        return result;
    }

    @Override
    public boolean hasNotInScopeDependencies(EObject sourceElement_p, IModelScope scope_p) {
        if (sourceElement_p != null) {
            EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)sourceElement_p.eCrossReferences().iterator();
            while (featureIterator.hasNext()) {
                EObject referenced = (EObject)featureIterator.next();
                EReference reference = (EReference)featureIterator.feature();
                if (!this.isDependency(reference) || scope_p.covers(referenced)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public abstract boolean isApplicableTo(EObject var1);

    @Override
    public List<EObject> getDependencies(EObject object_p) {
        FOrderedSet result = new FOrderedSet();
        if (object_p != null) {
            EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)object_p.eCrossReferences().iterator();
            while (featureIterator.hasNext()) {
                EObject referenced = (EObject)featureIterator.next();
                EReference reference = (EReference)featureIterator.feature();
                if (!this.isDependency(reference)) continue;
                result.add(referenced);
            }
        }
        return result;
    }

    public abstract boolean isDependency(EReference var1);

    @Override
    public boolean isMainModel() {
        return true;
    }
}

