/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.interactive;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.diffmerge.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.api.IMergePolicy;
import org.eclipse.emf.diffmerge.api.IMergeSelector;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.bridge.api.IBridge;
import org.eclipse.emf.diffmerge.bridge.incremental.EMFIncrementalBridge;
import org.eclipse.emf.diffmerge.bridge.interactive.BridgeComparisonViewer;
import org.eclipse.emf.diffmerge.bridge.interactive.Messages;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.ui.util.DiffMergeDialog;
import org.eclipse.emf.diffmerge.ui.viewers.AbstractComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFInteractiveBridge<SD, TD extends IEditableModelScope>
extends EMFIncrementalBridge<SD, TD> {
    public EMFInteractiveBridge(IBridge<SD, TD> bridge_p, IDiffPolicy diffPolicy_p, IMergePolicy mergePolicy_p, IMergeSelector merger_p) {
        super(bridge_p, diffPolicy_p, mergePolicy_p, merger_p);
    }

    protected AbstractComparisonViewer createComparisonViewer(Composite parent_p) {
        return new BridgeComparisonViewer(parent_p);
    }

    protected EMFDiffNode createDiffNode(EComparison comparison_p, EditingDomain domain_p) {
        EMFDiffNode diffNode = new EMFDiffNode(comparison_p, domain_p, true, false);
        diffNode.setDefaultShowImpact(false);
        diffNode.setReferenceRole(TARGET_DATA_ROLE);
        diffNode.setDrivingRole(TARGET_DATA_ROLE);
        diffNode.setLeftRole(TARGET_DATA_ROLE.opposite());
        return diffNode;
    }

    protected Window createMergeDialog(EMFDiffNode diffNode_p) {
        return new DiffMergeDialog(Display.getDefault().getActiveShell(), this.getTitle(), diffNode_p){

            protected AbstractComparisonViewer createComparisonViewer(Composite parent_p) {
                return EMFInteractiveBridge.this.createComparisonViewer(parent_p);
            }
        };
    }

    protected String getTitle() {
        return Messages.InteractiveEMFBridge_DefaultDialogTitle;
    }

    protected boolean isAlwaysInteractive() {
        return true;
    }

    protected IStatus mergeInteractively(EComparison comparison_p, IProgressMonitor monitor_p) {
        EditingDomain domain = null;
        IEditableModelScope targetScope = comparison_p.getTargetScope();
        if (targetScope.getAllContents().hasNext()) {
            domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)((EObject)targetScope.getAllContents().next()));
        }
        final EMFDiffNode diffNode = this.createDiffNode(comparison_p, domain);
        final int[] done = new int[1];
        Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            public void run() {
                Window dialog = EMFInteractiveBridge.this.createMergeDialog(diffNode);
                done[0] = dialog.open();
            }
        });
        IStatus result = done[0] == 0 ? Status.OK_STATUS : Status.CANCEL_STATUS;
        return result;
    }
}

