/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.editor.ace;

import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.ide.common.CommonUtils;
import org.eclipse.dirigible.ide.debug.model.DebugModelFacade;
import org.eclipse.dirigible.ide.editor.ace.Messages;
import org.eclipse.dirigible.ide.editor.text.editor.AbstractTextEditorWidget;
import org.eclipse.dirigible.ide.editor.text.editor.EditorMode;
import org.eclipse.dirigible.ide.editor.text.editor.IEditorWidgetListener;
import org.eclipse.dirigible.repository.ext.debug.DebugSessionModel;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class EditorWidget
extends AbstractTextEditorWidget {
    private static final long serialVersionUID = -8881201238299386468L;
    private static final Logger logger = Logger.getLogger(EditorWidget.class);
    private static final String SCRIPT_EVALUATION_FAILED = Messages.EditorWidget_SCRIPT_EVALUATION_FAILED;
    private static final String EDITOR_URL = "/aceeditor/editor.html";
    private Browser browser;
    private String text;
    private IEditorWidgetListener listener;
    private String mode;
    private boolean loaded;
    private boolean disabledForReadOnly;
    private boolean readOnly;
    private boolean breakpointsEnabled;
    private int row;

    public EditorWidget(Composite parent) {
        this(parent, false);
    }

    public EditorWidget(Composite parent, final boolean javaScriptEditor) {
        super(parent, 0);
        super.setLayout((Layout)new FillLayout());
        this.browser = new Browser((Composite)this, 0);
        this.browser.setUrl(String.valueOf(CommonParameters.getContextPath()) + EDITOR_URL);
        this.browser.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event) {
                DebugSessionModel session;
                EditorWidget.this.loaded = true;
                EditorWidget.this.updateWidgetContents();
                if (javaScriptEditor && DebugModelFacade.getDebugModel() != null && (session = DebugModelFacade.getDebugModel().getActiveSession()) != null && session.getCurrentLineBreak() != null) {
                    String filePath = session.getCurrentLineBreak().getBreakpoint().getFullPath();
                    String path = CommonUtils.formatToRuntimePath((String)"ScriptingServices", (String)filePath);
                    int[] breakpoints = DebugModelFacade.getDebugModel().getBreakpointsMetadata().getBreakpoints(path);
                    EditorWidget.this.loadBreakpoints(breakpoints);
                }
            }

            public void changed(ProgressEvent event) {
            }
        });
        new BrowserFunction(this.browser, "saveCalled"){

            public Object function(Object[] arguments) {
                if (EditorWidget.this.listener != null) {
                    EditorWidget.this.listener.save();
                }
                return null;
            }
        };
        new BrowserFunction(this.browser, "dirtyChanged"){

            public Object function(Object[] arguments) {
                if (EditorWidget.this.listener != null) {
                    EditorWidget.this.listener.dirtyStateChanged(((Boolean)arguments[0]).booleanValue());
                }
                return null;
            }
        };
        new BrowserFunction(this.browser, "setBreakpoint"){

            public Object function(Object[] arguments) {
                if (EditorWidget.this.listener != null && arguments[0] != null && arguments[0] instanceof Number) {
                    EditorWidget.this.listener.setBreakpoint(((Number)arguments[0]).intValue());
                }
                return null;
            }
        };
        new BrowserFunction(this.browser, "clearBreakpoint"){

            public Object function(Object[] arguments) {
                if (EditorWidget.this.listener != null && arguments[0] != null && arguments[0] instanceof Number) {
                    EditorWidget.this.listener.clearBreakpoint(((Number)arguments[0]).intValue());
                }
                return null;
            }
        };
    }

    public void setListener(IEditorWidgetListener listener) {
        this.listener = listener;
    }

    public void setText(String text, EditorMode mode, boolean readOnly, boolean breakpointsEnabled, int row) {
        this.text = text;
        this.mode = mode.getName();
        this.readOnly = readOnly;
        this.breakpointsEnabled = breakpointsEnabled;
        this.row = row;
        if (this.loaded) {
            this.updateWidgetContents();
        }
    }

    public String getText() {
        return (String)this.browser.evaluate("return getText();");
    }

    public void setDirty(boolean dirty) {
        this.execute("setDirty", dirty);
    }

    public void setDebugRow(int row) {
        this.execute("setDebugRow", row);
    }

    public void loadBreakpoints(int[] breakpoints) {
        int i = 0;
        while (i < breakpoints.length) {
            int breakpoint = breakpoints[i];
            this.execute("loadBreakpoint", breakpoint);
            ++i;
        }
    }

    private void updateWidgetContents() {
        this.evaluate("setText", this.text, this.mode, this.readOnly, this.breakpointsEnabled, this.row);
    }

    public void setMode(String mode) {
        this.evaluate("setMode", mode);
    }

    public void setReadOnly(boolean readOnly) {
        if (this.disabledForReadOnly) {
            this.execute("setReadOnly", false);
            return;
        }
        this.execute("setReadOnly", readOnly);
    }

    public void setBreakpointsEnabled(boolean status) {
        this.evaluate("setBreakpointsEnabled", status);
    }

    private void execute(String function, Object ... arguments) {
        this.browser.execute(this.buildFunctionCall(function, arguments));
    }

    private Object evaluate(String function, Object ... arguments) {
        String script = this.buildFunctionCall(function, arguments);
        try {
            return this.browser.evaluate(script);
        }
        catch (Exception ex) {
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new IllegalStateException(String.valueOf(SCRIPT_EVALUATION_FAILED) + script);
        }
    }

    private String buildFunctionCall(String function, Object ... arguments) {
        StringBuilder call = new StringBuilder();
        call.append(function).append('(');
        if (arguments != null) {
            Object[] objectArray = arguments;
            int n = arguments.length;
            int n2 = 0;
            while (n2 < n) {
                Object argument = objectArray[n2];
                String strArg = null;
                strArg = argument instanceof String ? this.prepareStringArgument((String)argument) : String.valueOf(argument);
                call.append(strArg).append(",");
                ++n2;
            }
            if (arguments.length > 0) {
                call.deleteCharAt(call.length() - 1);
            }
        }
        call.append(')');
        return call.toString();
    }

    private String prepareStringArgument(String argument) {
        return "'" + StringEscapeUtils.escapeJavaScript((String)argument) + "'";
    }
}

