/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.repository.logging.Logger;

public class ProxyUtils {
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTPS_PROXY_HOST = "https.proxyHost";
    public static final String HTTPS_PROXY_PORT = "https.proxyPort";
    public static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private static final Logger logger = Logger.getLogger(ProxyUtils.class);
    private static final String PROXY_PROPERTIES_FILE_LOCATION = "proxy.properties";
    private static final String DEFAULT_PROXY_VALUE = "false";
    private static final String PROXY = "proxy";

    public static void setProxySettings() throws IOException {
        ProxyUtils.setSystemProxySettings();
        ProxyUtils.setTrustAllSSL();
    }

    public static HttpClient getHttpClient(boolean trustAll) {
        DefaultHttpClient httpClient = null;
        if (trustAll) {
            try {
                PlainSocketFactory plainSocketFactory = PlainSocketFactory.getSocketFactory();
                SSLSocketFactory sslSocketFactory = new SSLSocketFactory(ProxyUtils.createTrustAllSSLContext());
                Scheme httpScheme = new Scheme("http", 80, (SchemeSocketFactory)plainSocketFactory);
                Scheme httpsScheme = new Scheme("https", 443, (SchemeSocketFactory)sslSocketFactory);
                SchemeRegistry schemeRegistry = new SchemeRegistry();
                schemeRegistry.register(httpScheme);
                schemeRegistry.register(httpsScheme);
                SingleClientConnManager cm = new SingleClientConnManager(schemeRegistry);
                httpClient = new DefaultHttpClient((ClientConnectionManager)cm);
            }
            catch (Exception exception) {
                httpClient = new DefaultHttpClient();
            }
        } else {
            httpClient = new DefaultHttpClient();
        }
        String httpProxyHost = System.getProperty(HTTP_PROXY_HOST);
        String httpProxyPort = System.getProperty(HTTP_PROXY_PORT);
        if (httpProxyHost != null && httpProxyPort != null) {
            HttpHost httpProxy = new HttpHost(httpProxyHost, Integer.parseInt(httpProxyPort));
            httpClient.getParams().setParameter("http.route.default-proxy", (Object)httpProxy);
        }
        return httpClient;
    }

    private static void loadLocalBuildProxy() throws IOException {
        InputStream in = ProxyUtils.class.getResourceAsStream(PROXY_PROPERTIES_FILE_LOCATION);
        Properties properties = new Properties();
        properties.load(in);
        String proxy = properties.getProperty(PROXY, DEFAULT_PROXY_VALUE);
        boolean needsProxy = Boolean.parseBoolean(proxy);
        if (needsProxy) {
            String httpProxyHost = properties.getProperty(HTTP_PROXY_HOST);
            String httpProxyPort = properties.getProperty(HTTP_PROXY_PORT);
            String httpsProxyHost = properties.getProperty(HTTPS_PROXY_HOST);
            String httpsProxyPort = properties.getProperty(HTTPS_PROXY_PORT);
            System.setProperty(HTTP_PROXY_HOST, httpProxyHost);
            System.setProperty(HTTP_PROXY_PORT, httpProxyPort);
            System.setProperty(HTTPS_PROXY_HOST, httpsProxyHost);
            System.setProperty(HTTPS_PROXY_PORT, httpsProxyPort);
        }
    }

    private static void setSystemProxySettings() {
        String parameterHTTP_PROXY_HOST = CommonParameters.get(HTTP_PROXY_HOST);
        if (parameterHTTP_PROXY_HOST != null) {
            System.setProperty(HTTP_PROXY_HOST, parameterHTTP_PROXY_HOST);
            logger.debug("HTTP_PROXY_HOST:" + parameterHTTP_PROXY_HOST);
        } else {
            logger.debug("HTTP_PROXY_HOST not set");
        }
        String parameterHTTP_PROXY_PORT = CommonParameters.get(HTTP_PROXY_PORT);
        if (parameterHTTP_PROXY_PORT != null) {
            System.setProperty(HTTP_PROXY_PORT, parameterHTTP_PROXY_PORT);
            logger.debug("HTTP_PROXY_PORT:" + parameterHTTP_PROXY_PORT);
        } else {
            logger.debug("HTTP_PROXY_PORT not set");
        }
        String parameterHTTPS_PROXY_HOST = CommonParameters.get(HTTPS_PROXY_HOST);
        if (parameterHTTPS_PROXY_HOST != null) {
            System.setProperty(HTTPS_PROXY_HOST, parameterHTTPS_PROXY_HOST);
            logger.debug("HTTPS_PROXY_HOST:" + parameterHTTPS_PROXY_HOST);
        } else {
            logger.debug("HTTPS_PROXY_HOST not set");
        }
        String parameterHTTPS_PROXY_PORT = CommonParameters.get(HTTPS_PROXY_PORT);
        if (parameterHTTPS_PROXY_PORT != null) {
            System.setProperty(HTTPS_PROXY_PORT, parameterHTTPS_PROXY_PORT);
            logger.debug("HTTPS_PROXY_PORT:" + parameterHTTPS_PROXY_PORT);
        } else {
            logger.debug("HTTPS_PROXY_PORT not set");
        }
        String parameterHTTP_NON_PROXY_HOSTS = CommonParameters.get(HTTP_NON_PROXY_HOSTS);
        if (parameterHTTP_NON_PROXY_HOSTS != null) {
            System.setProperty(HTTP_NON_PROXY_HOSTS, parameterHTTP_NON_PROXY_HOSTS);
            logger.debug("HTTP_NON_PROXY_HOSTS:" + parameterHTTP_NON_PROXY_HOSTS);
        } else {
            logger.debug("HTTP_NON_PROXY_HOSTS not set");
        }
    }

    private static void setTrustAllSSL() throws IOException {
        try {
            HttpsURLConnection.setDefaultSSLSocketFactory(ProxyUtils.createTrustAllSSLContext().getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (KeyManagementException e) {
            throw new IOException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    private static SSLContext createTrustAllSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("SSL");
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        sslContext.init(null, trustAllCerts, new SecureRandom());
        return sslContext;
    }
}

